/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.block;

import com.yungnickyoung.minecraft.yungscavebiomes.mixin.accessor.AbstractCauldronBlockAccessor;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.DamageTypeModule;
import com.yungnickyoung.minecraft.yungscavebiomes.services.Services;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class IcicleBlock
extends Block
implements Fallable,
SimpleWaterloggedBlock {
    public static final EnumProperty<DripstoneThickness> THICKNESS = BlockStateProperties.DRIPSTONE_THICKNESS;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape BASE_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape FRUSTUM_SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape TIP_SHAPE = Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);

    public IcicleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(THICKNESS, (Comparable)DripstoneThickness.TIP)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{THICKNESS, WATERLOGGED});
    }

    public boolean canSurvive(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return IcicleBlock.isValidPosition(levelReader, blockPos);
    }

    public BlockState updateShape(BlockState currState, Direction neighborDirection, BlockState neighborBlockState, LevelAccessor levelAccessor, BlockPos currPos, BlockPos neighborPos) {
        if (((Boolean)currState.getValue((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.scheduleTick(currPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)levelAccessor));
        }
        if (neighborDirection != Direction.UP && neighborDirection != Direction.DOWN) {
            return currState;
        }
        if (levelAccessor.getBlockTicks().hasScheduledTick(currPos, (Object)this)) {
            return currState;
        }
        if (neighborDirection == Direction.UP && !this.canSurvive(currState, (LevelReader)levelAccessor, currPos)) {
            levelAccessor.scheduleTick(currPos, (Block)this, 2);
            return currState;
        }
        DripstoneThickness thickness = IcicleBlock.calculateIcicleThickness((LevelReader)levelAccessor, currPos);
        return (BlockState)currState.setValue(THICKNESS, (Comparable)thickness);
    }

    public void onProjectileHit(Level level, @NotNull BlockState blockState, BlockHitResult blockHitResult, @NotNull Projectile projectile) {
        BlockPos blockPos = blockHitResult.getBlockPos();
        if (!level.isClientSide && projectile.mayInteract(level, blockPos) && projectile instanceof AbstractArrow && projectile.getDeltaMovement().length() > 0.4) {
            level.destroyBlock(blockPos, true);
        }
    }

    public void tick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        IcicleBlock.spawnFallingIcicle(blockState, serverLevel, blockPos);
    }

    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        IcicleBlock.maybeFillCauldron(blockState, serverLevel, blockPos, random.nextFloat());
        if (random.nextFloat() < 0.011377778f && IcicleBlock.isTop(blockState, (LevelReader)serverLevel, blockPos)) {
            IcicleBlock.tryToGrowIcicle(blockState, serverLevel, blockPos);
        }
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource random) {
        if (!IcicleBlock.canDrip(blockState)) {
            return;
        }
        float chance = random.nextFloat();
        if (chance > 0.12f) {
            return;
        }
        IcicleBlock.getFluidAboveIcicle(level, blockPos).filter(fluid -> chance < 0.02f || IcicleBlock.canFillCauldron(fluid)).ifPresent(fluid -> IcicleBlock.spawnDripParticle(level, blockPos, blockState, fluid));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        Level levelAccessor = blockPlaceContext.getLevel();
        if (!IcicleBlock.isValidPosition((LevelReader)levelAccessor, blockPlaceContext.getClickedPos())) {
            return null;
        }
        boolean isWaterlogged = levelAccessor.getFluidState(blockPlaceContext.getClickedPos()).getType() == Fluids.WATER;
        DripstoneThickness thickness = IcicleBlock.calculateIcicleThickness((LevelReader)levelAccessor, blockPlaceContext.getClickedPos());
        if (thickness == null) {
            return null;
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue(THICKNESS, (Comparable)thickness)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
    }

    @NotNull
    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        DripstoneThickness thickness = (DripstoneThickness)blockState.getValue(THICKNESS);
        VoxelShape voxelShape = switch (thickness) {
            case DripstoneThickness.BASE -> BASE_SHAPE;
            case DripstoneThickness.MIDDLE -> MIDDLE_SHAPE;
            case DripstoneThickness.FRUSTUM -> FRUSTUM_SHAPE;
            default -> TIP_SHAPE;
        };
        Vec3 vec3 = blockState.getOffset(blockGetter, blockPos);
        return voxelShape.move(vec3.x, 0.0, vec3.z);
    }

    public boolean isCollisionShapeFullBlock(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return false;
    }

    public float getMaxHorizontalOffset() {
        return 0.125f;
    }

    public void onBrokenAfterFall(Level level, BlockPos blockPos, FallingBlockEntity fallingBlockEntity) {
        if (!fallingBlockEntity.isSilent() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Services.PLATFORM.sendIcicleProjectileShatterS2CPacket(serverLevel, Vec3.atCenterOf((Vec3i)blockPos));
            fallingBlockEntity.playSound(SoundEvents.GLASS_BREAK, 1.0f, 1.2f / (new Random().nextFloat() * 0.2f + 0.9f));
        }
    }

    @NotNull
    public DamageSource getFallDamageSource(@NotNull Entity entity) {
        return DamageTypeModule.of(entity.level().registryAccess(), DamageTypeModule.FALLING_ICICLE);
    }

    @NotNull
    public FluidState getFluidState(BlockState blockState) {
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(blockState);
    }

    @Nullable
    private static BlockPos findTip(BlockState blockState, LevelAccessor levelAccessor, BlockPos blockPos, int searchDistance) {
        if (IcicleBlock.isTip(blockState)) {
            return blockPos;
        }
        return IcicleBlock.findBlockVertical(levelAccessor, blockPos, Direction.DOWN, state -> state.is((Block)BlockModule.ICICLE.get()), IcicleBlock::isTip, searchDistance).orElse(null);
    }

    @Nullable
    private static BlockPos findRoot(LevelAccessor levelAccessor, BlockPos blockPos) {
        Predicate<BlockState> matchingPredicate = state -> state.is((Block)BlockModule.ICICLE.get());
        Predicate<BlockState> stoppingPredicate = state -> !state.is((Block)BlockModule.ICICLE.get());
        return IcicleBlock.findBlockVertical(levelAccessor, blockPos, Direction.UP, matchingPredicate, stoppingPredicate, 11).orElse(null);
    }

    private static boolean isValidPosition(LevelReader levelReader, BlockPos blockPos) {
        BlockPos posAbove = blockPos.relative(Direction.UP);
        BlockState blockStateAbove = levelReader.getBlockState(posAbove);
        return blockStateAbove.isFaceSturdy((BlockGetter)levelReader, posAbove, Direction.DOWN) || blockStateAbove.is((Block)BlockModule.ICICLE.get());
    }

    private static boolean isTip(BlockState blockState) {
        if (!blockState.is((Block)BlockModule.ICICLE.get())) {
            return false;
        }
        DripstoneThickness thickness = (DripstoneThickness)blockState.getValue(THICKNESS);
        return thickness == DripstoneThickness.TIP;
    }

    private static boolean isTop(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return blockState.is((Block)BlockModule.ICICLE.get()) && !levelReader.getBlockState(blockPos.above()).is((Block)BlockModule.ICICLE.get());
    }

    private static Optional<BlockPos> findBlockVertical(LevelAccessor levelAccessor, BlockPos startPos, Direction searchDirection, Predicate<BlockState> predicate, Predicate<BlockState> stoppingPredicate, int searchDistance) {
        BlockPos.MutableBlockPos mutable = startPos.mutable();
        for (int i = 1; i < searchDistance; ++i) {
            mutable.move(searchDirection);
            BlockState blockState = levelAccessor.getBlockState((BlockPos)mutable);
            if (stoppingPredicate.test(blockState)) {
                return Optional.of(mutable.immutable());
            }
            if (predicate.test(blockState) && !levelAccessor.isOutsideBuildHeight(mutable.getY())) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static DripstoneThickness calculateIcicleThickness(LevelReader levelReader, BlockPos blockPos) {
        BlockState blockBelow = levelReader.getBlockState(blockPos.relative(Direction.DOWN));
        BlockState blockAbove = levelReader.getBlockState(blockPos.relative(Direction.UP));
        if (!blockBelow.is((Block)BlockModule.ICICLE.get())) {
            return DripstoneThickness.TIP;
        }
        if (blockBelow.getValue(THICKNESS) == DripstoneThickness.TIP) {
            return DripstoneThickness.FRUSTUM;
        }
        if (!blockAbove.is((Block)BlockModule.ICICLE.get())) {
            return DripstoneThickness.BASE;
        }
        return DripstoneThickness.MIDDLE;
    }

    private static void spawnFallingIcicle(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos) {
        BlockPos.MutableBlockPos mutable = blockPos.mutable();
        BlockState blockState2 = blockState;
        while (blockState2.is((Block)BlockModule.ICICLE.get())) {
            FallingBlockEntity fallingBlockEntity = FallingBlockEntity.fall((Level)serverLevel, (BlockPos)mutable, (BlockState)blockState2);
            if (IcicleBlock.isTip(blockState2)) {
                int icicleSize = Math.max(1 + blockPos.getY() - mutable.getY(), 6);
                float damagePerBlock = 0.5f * (float)icicleSize;
                fallingBlockEntity.setHurtsEntities(damagePerBlock, 10);
                break;
            }
            mutable.move(Direction.DOWN);
            blockState2 = serverLevel.getBlockState((BlockPos)mutable);
        }
    }

    private static void tryToGrowIcicle(BlockState rootIcicleBlock, ServerLevel serverLevel, BlockPos rootIcicleBlockPos) {
        if (!IcicleBlock.canGrow(serverLevel.getBlockState(rootIcicleBlockPos.above(1)), serverLevel.getBlockState(rootIcicleBlockPos.above(2)))) {
            return;
        }
        BlockPos tipPos = IcicleBlock.findTip(rootIcicleBlock, (LevelAccessor)serverLevel, rootIcicleBlockPos, 6);
        if (tipPos == null || !IcicleBlock.isTip(serverLevel.getBlockState(tipPos))) {
            return;
        }
        if (IcicleBlock.doesTipHaveRoomToGrow(serverLevel, tipPos)) {
            IcicleBlock.growIcicle(serverLevel, tipPos);
        }
    }

    private static boolean canGrow(BlockState blockState, BlockState blockStateAbove) {
        return blockState.is(BlockTags.ICE) && blockStateAbove.is(Blocks.WATER) && blockStateAbove.getFluidState().isSource();
    }

    private static boolean doesTipHaveRoomToGrow(ServerLevel serverLevel, BlockPos tipPos) {
        BlockPos belowTipPos = tipPos.relative(Direction.DOWN);
        BlockState belowTipBlock = serverLevel.getBlockState(belowTipPos);
        if (!belowTipBlock.getFluidState().isEmpty()) {
            return false;
        }
        return belowTipBlock.isAir();
    }

    private static void growIcicle(ServerLevel serverLevel, BlockPos tipPos) {
        BlockPos belowTipBlock = tipPos.below();
        IcicleBlock.createIcicle((LevelAccessor)serverLevel, belowTipBlock, DripstoneThickness.TIP);
    }

    private static void createIcicle(LevelAccessor levelAccessor, BlockPos blockPos, DripstoneThickness thickness) {
        BlockState blockState = (BlockState)((BlockState)((Block)BlockModule.ICICLE.get()).defaultBlockState().setValue(THICKNESS, (Comparable)thickness)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelAccessor.getFluidState(blockPos).getType() == Fluids.WATER));
        levelAccessor.setBlock(blockPos, blockState, 3);
    }

    @Nullable
    public static BlockPos findIcicleTipAboveCauldron(Level level, BlockPos blockPos) {
        return IcicleBlock.findBlockVertical((LevelAccessor)level, blockPos, Direction.UP, BlockBehaviour.BlockStateBase::isAir, IcicleBlock::canDrip, 11).orElse(null);
    }

    private static boolean canDrip(BlockState blockState) {
        return blockState.getBlock() == BlockModule.ICICLE.get() && blockState.getValue(THICKNESS) == DripstoneThickness.TIP && (Boolean)blockState.getValue((Property)WATERLOGGED) == false;
    }

    private static Optional<Fluid> getFluidAboveIcicle(Level level, BlockPos blockPos) {
        BlockPos rootPos = IcicleBlock.findRoot((LevelAccessor)level, blockPos);
        if (rootPos == null) {
            return Optional.empty();
        }
        return Optional.of(level.getFluidState(rootPos.above()).getType());
    }

    private static boolean canFillCauldron(Fluid fluid) {
        return fluid == Fluids.WATER;
    }

    private static void spawnDripParticle(Level level, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        Vec3 vec3 = blockState.getOffset((BlockGetter)level, blockPos);
        double d = 0.0625;
        double x = (double)blockPos.getX() + 0.5 + vec3.x;
        double y = (double)((float)(blockPos.getY() + 1) - 0.6875f) - d;
        double z = (double)blockPos.getZ() + 0.5 + vec3.z;
        level.addParticle((ParticleOptions)ParticleTypes.DRIPPING_DRIPSTONE_WATER, x, y, z, 0.0, 0.0, 0.0);
    }

    public static Fluid getCauldronFillFluidType(Level level, BlockPos blockPos) {
        return IcicleBlock.getFluidAboveIcicle(level, blockPos).filter(IcicleBlock::canFillCauldron).orElse(null);
    }

    private static void maybeFillCauldron(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, float f) {
        if (f > 0.17578125f) {
            return;
        }
        if (!IcicleBlock.isTop(blockState, (LevelReader)serverLevel, blockPos)) {
            return;
        }
        Fluid fluid = IcicleBlock.getCauldronFillFluidType((Level)serverLevel, blockPos);
        if (fluid != Fluids.WATER) {
            return;
        }
        float dripChance = 0.17578125f;
        if (f >= dripChance) {
            return;
        }
        BlockPos tipPos = IcicleBlock.findTip(blockState, (LevelAccessor)serverLevel, blockPos, 11);
        if (tipPos == null) {
            return;
        }
        Predicate<BlockState> isValidCauldron = state -> state.getBlock() instanceof AbstractCauldronBlock && ((AbstractCauldronBlockAccessor)state.getBlock()).callCanReceiveStalactiteDrip(fluid);
        BlockPos cauldronPos = IcicleBlock.findBlockVertical((LevelAccessor)serverLevel, tipPos, Direction.DOWN, BlockBehaviour.BlockStateBase::isAir, isValidCauldron, 11).orElse(null);
        if (cauldronPos == null) {
            return;
        }
        int yDist = tipPos.getY() - cauldronPos.getY();
        int timeUntilCauldronTick = 50 + yDist;
        BlockState cauldronBlockState = serverLevel.getBlockState(cauldronPos);
        serverLevel.scheduleTick(cauldronPos, cauldronBlockState.getBlock(), timeUntilCauldronTick);
    }
}

