/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.justaraftmod.entities;

import com.mrbysco.justaraftmod.config.RaftConfig;
import com.mrbysco.justaraftmod.entities.RaftType;
import com.mrbysco.justaraftmod.init.RaftRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class Raft
extends Boat {
    public Raft(EntityType<? extends Raft> entityType, Level level) {
        super(entityType, level);
    }

    public Raft(Level level, double x, double y, double z) {
        this(RaftRegistry.RAFT.get(), level);
        this.setPos(x, y, z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putString("Type", this.getRaftType().getName());
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("Type", 8)) {
            this.setRaftType(RaftType.byName(tag.getString("Type")));
        }
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
        this.lastYd = this.getDeltaMovement().y;
        if (!this.isPassenger()) {
            if (onGround) {
                if (this.fallDistance > 3.0f) {
                    if (this.status != Boat.Status.ON_LAND) {
                        this.resetFallDistance();
                        return;
                    }
                    this.causeFallDamage(this.fallDistance, 1.0f, this.damageSources().fall());
                    if (!this.level().isClientSide && !this.isRemoved()) {
                        this.kill();
                        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                            for (int i = 0; i < 3; ++i) {
                                this.spawnAtLocation((ItemLike)this.getRaftType().getPlanks());
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.spawnAtLocation((ItemLike)Items.STICK);
                            }
                        }
                    }
                }
                this.resetFallDistance();
            } else if (!this.level().getFluidState(this.blockPosition().below()).is(FluidTags.WATER) && y < 0.0) {
                this.fallDistance -= (float)y;
            }
        }
    }

    public void tick() {
        super.tick();
        if (((Boolean)RaftConfig.SERVER.SinkTheRaft.get()).booleanValue() && this.getPassengers().size() > 1) {
            Vec3 motion = this.getDeltaMovement();
            double newY = motion.y - 0.035;
            this.setDeltaMovement(motion.x, newY, motion.z);
        }
    }

    public Boat.Status getStatus() {
        Boat.Status boatStatus = this.isUnderwater();
        if (boatStatus != null) {
            this.waterLevel = this.getBoundingBox().maxY;
            return boatStatus;
        }
        if (this.checkInWater()) {
            return Boat.Status.IN_WATER;
        }
        float f = this.getGroundFriction();
        if (f > 0.0f) {
            this.landFriction = (Boolean)RaftConfig.SERVER.SlipperyFast.get() != false ? f : 0.0f;
            return Boat.Status.ON_LAND;
        }
        return Boat.Status.IN_AIR;
    }

    public void floatBoat() {
        double d1 = this.isNoGravity() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        this.invFriction = 0.05f;
        if (this.oldStatus == Boat.Status.IN_AIR && this.status != Boat.Status.IN_AIR && this.status != Boat.Status.ON_LAND) {
            this.waterLevel = this.getBoundingBox().minY + (double)this.getBbHeight();
            this.setPos(this.getX(), (double)(this.getWaterLevelAbove() - this.getBbHeight()) + 0.101, this.getZ());
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.0, 1.0));
            this.lastYd = 0.0;
            this.status = Boat.Status.IN_WATER;
        } else {
            if (this.status == Boat.Status.IN_WATER) {
                d2 = (this.waterLevel - this.getBoundingBox().minY + 0.1) / (double)this.getBbHeight();
                this.invFriction = 0.9f;
            } else if (this.status == Boat.Status.UNDER_FLOWING_WATER) {
                d1 = -7.0E-4;
                this.invFriction = 0.9f;
            } else if (this.status == Boat.Status.UNDER_WATER) {
                d2 = 0.01f;
                this.invFriction = 0.45f;
            } else if (this.status == Boat.Status.IN_AIR) {
                this.invFriction = 0.9f;
            } else if (this.status == Boat.Status.ON_LAND) {
                this.invFriction = this.landFriction;
                if (this.getControllingPassenger() instanceof Player) {
                    this.landFriction /= 2.0f;
                }
            }
            Vec3 Vector3d = this.getDeltaMovement();
            this.setDeltaMovement(Vector3d.x * (double)this.invFriction, Vector3d.y + d1, Vector3d.z * (double)this.invFriction);
            this.deltaRotation *= this.invFriction;
            if (d2 > 0.0) {
                Vec3 Vector3d1 = this.getDeltaMovement();
                this.setDeltaMovement(Vector3d1.x, (Vector3d1.y + d2 * 0.06153846016296973) * 0.75, Vector3d1.z);
            }
        }
    }

    public void controlBoat() {
        if (this.isVehicle()) {
            float f = 0.0f;
            if (this.inputLeft) {
                this.deltaRotation -= ((Double)RaftConfig.SERVER.TurnMultiplier.get()).floatValue();
            }
            if (this.inputRight) {
                this.deltaRotation += ((Double)RaftConfig.SERVER.TurnMultiplier.get()).floatValue();
            }
            if (this.inputRight != this.inputLeft && !this.inputUp && !this.inputDown) {
                f += 0.005f;
            }
            this.setYRot(this.getYRot() + this.deltaRotation);
            if (this.inputUp) {
                f += 0.04f * ((Double)RaftConfig.SERVER.SpeedMultiplier.get()).floatValue();
            }
            if (this.inputDown) {
                f -= 0.005f * ((Double)RaftConfig.SERVER.SpeedMultiplier.get()).floatValue();
            }
            this.setDeltaMovement(this.getDeltaMovement().add((double)(Mth.sin((float)(-this.getYRot() * ((float)Math.PI / 180))) * f), 0.0, (double)(Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * f)));
            this.setPaddleState(this.inputRight && !this.inputLeft || this.inputUp, this.inputLeft && !this.inputRight || this.inputUp);
        }
    }

    public float getSinglePassengerXOffset() {
        return 0.0f;
    }

    public Item getDropItem() {
        if (this.getRaftType() == null) {
            return Items.STICK;
        }
        return (Item)this.getRaftType().getRaft().value();
    }

    public void setRaftType(RaftType type) {
        this.entityData.set(DATA_ID_TYPE, (Object)type.getId());
    }

    public RaftType getRaftType() {
        return RaftType.byId((Integer)this.entityData.get(DATA_ID_TYPE));
    }
}

