/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.configs.neoforge;

import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.api.platform.configs.neoforge.ForgeConfigHolder;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.mehvahdjukaar.moonlight.core.databuddy.ConfigHelper;
import net.mehvahdjukaar.moonlight.neoforge.ConfigHacks;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.http.annotation.Experimental;

public class ConfigBuilderImpl
extends ConfigBuilder {
    private ModConfigSpec.ConfigValue<?> currentValue;
    private final List<ValueWrapper<?, ?>> specialValues = new ArrayList();
    private final ModConfigSpec.Builder builder;
    private final Deque<String> cat = new ArrayDeque<String>();

    public static ConfigBuilder create(ResourceLocation name, ConfigType type) {
        return new ConfigBuilderImpl(name, type);
    }

    public ConfigBuilderImpl(ResourceLocation name, ConfigType type) {
        super(name, type);
        this.builder = new ModConfigSpec.Builder();
        ConfigHacks.init();
    }

    @Override
    public String currentCategory() {
        return this.cat.peekFirst();
    }

    @Override
    public ForgeConfigHolder build() {
        return new ForgeConfigHolder(this.getName(), this.builder.build(), this.type, this.changeCallback, this.specialValues);
    }

    @Override
    public ConfigBuilderImpl push(String category) {
        this.builder.push(category);
        this.cat.push(category);
        this.translations.put(this.translationKey(""), LangBuilder.getReadableName(category));
        return this;
    }

    @Override
    public ConfigBuilderImpl pop() {
        this.builder.pop();
        this.cat.pop();
        return this;
    }

    @Override
    public Supplier<Boolean> define(String name, boolean defaultValue) {
        ModConfigSpec.BooleanValue value;
        this.addTranslationsAndComments(name);
        this.currentValue = value = this.builder.define(name, defaultValue);
        return value;
    }

    @Override
    public Supplier<Integer> define(String name, int defaultValue, int min, int max) {
        ModConfigSpec.IntValue value;
        this.addTranslationsAndComments(name);
        this.currentValue = value = this.builder.defineInRange(name, defaultValue, min, max);
        return value;
    }

    @Override
    public Supplier<Double> define(String name, double defaultValue, double min, double max) {
        ModConfigSpec.DoubleValue value;
        this.addTranslationsAndComments(name);
        this.currentValue = value = this.builder.defineInRange(name, defaultValue, min, max);
        return value;
    }

    @Override
    @Experimental
    public Supplier<Float> define(String name, float defaultValue, float min, float max) {
        ModConfigSpec.DoubleValue value;
        this.addTranslationsAndComments(name);
        this.currentValue = value = this.builder.defineInRange(name, (double)defaultValue, (double)min, (double)max);
        ValueWrapper<Float, Double> wrapper = new ValueWrapper<Float, Double>(this, (ModConfigSpec.ConfigValue)value){

            @Override
            Float map(Double value) {
                return Float.valueOf(value.floatValue());
            }
        };
        this.specialValues.add(wrapper);
        return wrapper;
    }

    @Override
    public Supplier<Integer> defineColor(String name, int defaultValue) {
        ModConfigSpec.ConfigValue value;
        this.addTranslationsAndComments(name);
        String def = (String)ColorUtils.CODEC.encodeStart((DynamicOps)JavaOps.INSTANCE, (Object)defaultValue).getOrThrow();
        this.currentValue = value = this.builder.define(name, (Object)def, o -> {
            String s;
            return o instanceof String && ColorUtils.isValidString(s = (String)o);
        });
        ValueWrapper<Integer, String> wrapper = new ValueWrapper<Integer, String>(this, value){

            @Override
            Integer map(String value) {
                return (Integer)ColorUtils.CODEC.parse((DynamicOps)JavaOps.INSTANCE, (Object)value).getOrThrow();
            }
        };
        this.specialValues.add(wrapper);
        return wrapper;
    }

    @Override
    public Supplier<String> define(String name, String defaultValue, Predicate<Object> validator) {
        ModConfigSpec.ConfigValue value;
        this.addTranslationsAndComments(name);
        this.currentValue = value = this.builder.define(name, (Object)defaultValue, validator);
        return value;
    }

    public <T> Supplier<T> define(String name, Supplier<T> defaultValue, Predicate<Object> validator) {
        ModConfigSpec.ConfigValue value;
        this.addTranslationsAndComments(name);
        this.currentValue = value = this.builder.define(name, defaultValue, validator);
        return value;
    }

    @Override
    public <T extends String> Supplier<List<String>> define(String name, List<? extends T> defaultValue, Predicate<Object> predicate) {
        ModConfigSpec.ConfigValue value;
        this.addTranslationsAndComments(name);
        this.currentValue = value = this.builder.defineList(name, defaultValue, predicate);
        return () -> (List)value.get();
    }

    @Override
    public <T> Supplier<T> defineObject(String name, com.google.common.base.Supplier<T> defaultSupplier, Codec<T> codec) {
        if (this.usesDataBuddy) {
            return ConfigHelper.defineObject(this.builder, name, codec, defaultSupplier);
        }
        return StringCodecConfigValue.define(this, name, defaultSupplier, codec);
    }

    @Override
    public <T> Supplier<List<T>> defineObjectList(String name, com.google.common.base.Supplier<List<T>> defaultSupplier, Codec<T> codec) {
        this.builder.comment("This is a list. Add more entries with syntax [[...]]");
        return super.defineObjectList(name, defaultSupplier, codec);
    }

    public StringJsonConfigValue defineJson(String path, JsonElement defaultValue) {
        return StringJsonConfigValue.define(this, path, defaultValue);
    }

    public StringJsonConfigValue defineJson(String path, Supplier<JsonElement> defaultValue) {
        return StringJsonConfigValue.define(this, path, defaultValue);
    }

    @Override
    public <V extends Enum<V>> Supplier<V> define(String name, V defaultValue) {
        ModConfigSpec.EnumValue value;
        this.addTranslationsAndComments(name);
        this.currentValue = value = this.builder.defineEnum(name, defaultValue);
        return value;
    }

    @Override
    public ConfigBuilder gameRestart() {
        this.builder.gameRestart();
        return this;
    }

    @Override
    public ConfigBuilder worldReload() {
        this.builder.worldRestart();
        return this;
    }

    @Override
    protected void addTranslationsAndComments(String name) {
        this.builder.translation(this.translationKey(name));
        super.addTranslationsAndComments(name);
    }

    @Override
    public ConfigBuilder comment(String comment) {
        this.builder.comment(comment);
        return super.comment(comment);
    }

    private static class StringCodecConfigValue<T>
    implements Supplier<T> {
        private final StringJsonConfigValue inner;
        private final Codec<T> codec;
        private T cache;

        public static <T> StringCodecConfigValue<T> define(ConfigBuilderImpl cfg, String name, Supplier<T> defaultValueSupplier, Codec<T> codec) {
            Supplier<JsonElement> jsonSupplier = () -> {
                DataResult e = codec.encodeStart((DynamicOps)JsonOps.INSTANCE, defaultValueSupplier.get());
                Optional json = e.resultOrPartial(s -> {
                    throw new RuntimeException("Invalid default value for config " + name + ": " + s);
                });
                if (json.isEmpty()) {
                    throw new RuntimeException("Invalid default value for config " + name);
                }
                return (JsonElement)json.get();
            };
            Supplier jsonConfig = cfg.defineJson(name, (Supplier)jsonSupplier);
            return new StringCodecConfigValue<T>((StringJsonConfigValue)jsonConfig, codec);
        }

        public StringCodecConfigValue(StringJsonConfigValue jsonConfig, Codec<T> codec) {
            this.inner = jsonConfig;
            this.codec = codec;
        }

        @Override
        public T get() {
            if (this.inner.hasBeenReset()) {
                this.cache = null;
            }
            if (this.cache == null) {
                JsonElement j = this.inner.get();
                DataResult d = this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)j);
                Optional o = d.resultOrPartial(s -> {
                    throw new RuntimeException("Failed to decode config: " + s);
                });
                if (o.isEmpty()) {
                    throw new RuntimeException("Failed to parse decode with value" + String.valueOf(j));
                }
                return (T)((Pair)o.get()).getFirst();
            }
            return null;
        }
    }

    private static class StringJsonConfigValue
    implements Supplier<JsonElement> {
        private static final Field cachedValue = ObfuscationReflectionHelper.findField(ModConfigSpec.ConfigValue.class, (String)"cachedValue");
        private final ModConfigSpec.ConfigValue<String> inner;
        private JsonElement cache = null;

        public static StringJsonConfigValue define(ConfigBuilderImpl cfg, String path, Supplier<JsonElement> defaultValueSupplier) {
            com.google.common.base.Supplier lazyDefaultValue = Suppliers.memoize(defaultValueSupplier::get);
            return new StringJsonConfigValue(cfg.define(path, () -> ((JsonElement)lazyDefaultValue.get()).toString().replace(" ", "").replace("\"", "'"), o -> o != null && ((JsonElement)lazyDefaultValue.get()).getClass().isAssignableFrom(o.getClass())));
        }

        public static StringJsonConfigValue define(ConfigBuilderImpl cfg, String path, JsonElement defaultValue) {
            return new StringJsonConfigValue(cfg.define(path, defaultValue.toString().replace(" ", "").replace("\"", "'")));
        }

        StringJsonConfigValue(Supplier<String> innerConfig) {
            this.inner = (ModConfigSpec.ConfigValue)innerConfig;
        }

        @Override
        public JsonElement get() {
            if (this.hasBeenReset()) {
                this.cache = null;
            }
            if (this.cache == null) {
                String s = ((String)this.inner.get()).replace("'", "\"");
                try {
                    this.cache = JsonParser.parseString((String)s);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to parse json config: ", e);
                }
            }
            return this.cache;
        }

        public boolean hasBeenReset() {
            try {
                return cachedValue.get(this.inner) == null;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        static {
            cachedValue.setAccessible(true);
        }
    }

    static abstract class ValueWrapper<T, C>
    implements Supplier<T> {
        private final ModConfigSpec.ConfigValue<C> original;
        private T cachedValue = null;

        ValueWrapper(ModConfigSpec.ConfigValue<C> original) {
            this.original = original;
        }

        abstract T map(C var1);

        public void clearCache() {
            this.cachedValue = null;
        }

        @Override
        public T get() {
            if (this.cachedValue == null) {
                this.cachedValue = this.map(this.original.get());
            }
            return this.cachedValue;
        }
    }
}

