/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import net.mehvahdjukaar.moonlight.api.misc.PathSearchTrie;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ResourceLocationSearchTrie
extends PathSearchTrie<ResourceLocation> {
    public void insert(ResourceLocation objectToAdd) {
        super.insert(ResourceLocationSearchTrie.getResPath(objectToAdd), objectToAdd);
    }

    public void insertPath(String fullPath) {
        super.insert(fullPath, ResourceLocationSearchTrie.fromPath(fullPath));
    }

    @NotNull
    public static String getResPath(ResourceLocation objectToAdd) {
        Object path = objectToAdd.getNamespace() + "/" + objectToAdd.getPath();
        path = ResourceLocationSearchTrie.getFolderPath((String)path);
        return path;
    }

    private static String getFolderPath(String path) {
        int lastIndex = path.lastIndexOf(47);
        if (lastIndex == -1) {
            return "";
        }
        return path.substring(0, lastIndex);
    }

    @NotNull
    private static ResourceLocation fromPath(@NotNull String folderPath) {
        int firstSlash = folderPath.indexOf(47);
        if (firstSlash == -1) {
            return ResourceLocation.fromNamespaceAndPath((String)folderPath, (String)"");
        }
        String namespace = folderPath.substring(0, firstSlash);
        String path = folderPath.substring(firstSlash + 1);
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }

    public boolean remove(ResourceLocation object) {
        return super.remove(ResourceLocationSearchTrie.getResPath(object));
    }
}

