/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.misc.OptHolderRef;
import net.mehvahdjukaar.moonlight.api.misc.WeakHashSet;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import org.jetbrains.annotations.ApiStatus;

public class HolderRef<T> {
    private final ResourceKey<Registry<T>> registryKey;
    private final ResourceKey<T> key;
    private final WeakHashMap<HolderLookup.Provider, Holder<T>> cache = new WeakHashMap();
    private static final WeakHashSet<HolderRef<?>> REFERENCES = new WeakHashSet();

    @ApiStatus.Internal
    public static void clearCache() {
        REFERENCES.forEach(HolderRef::invalidateCache);
    }

    private void invalidateCache() {
        this.cache.clear();
    }

    protected HolderRef(ResourceKey<Registry<T>> registryKey, ResourceKey<T> key) {
        this.registryKey = registryKey;
        this.key = key;
        REFERENCES.add(this);
    }

    public static <A> HolderRef<A> wrap(A obj, ResourceKey<Registry<A>> registry) {
        return HolderRef.of(Utils.getID(obj), registry);
    }

    public static <A> HolderRef<A> of(String id, ResourceKey<Registry<A>> registry) {
        return HolderRef.of(ResourceLocation.tryParse((String)id), registry);
    }

    public static <A> HolderRef<A> of(ResourceLocation location, ResourceKey<Registry<A>> registry) {
        return new HolderRef<A>(registry, ResourceKey.create(registry, (ResourceLocation)location));
    }

    public static <A> HolderRef<A> of(ResourceKey<A> key) {
        return new HolderRef<A>(ResourceKey.createRegistryKey((ResourceLocation)key.registry()), key);
    }

    public static <A> OptHolderRef<A> optional(ResourceLocation location, ResourceKey<Registry<A>> registry) {
        return new OptHolderRef<A>(registry, ResourceKey.create(registry, (ResourceLocation)location));
    }

    public static <A> OptHolderRef<A> optional(ResourceKey<A> key) {
        return new OptHolderRef<A>(ResourceKey.createRegistryKey((ResourceLocation)key.registry()), key);
    }

    public T get(Entity entity) {
        return this.get(entity.level());
    }

    public T get(Level level) {
        return this.get((HolderLookup.Provider)level.registryAccess());
    }

    public T get(LevelReader level) {
        return this.get((HolderLookup.Provider)level.registryAccess());
    }

    public T get(HolderLookup.Provider r) {
        return (T)this.getHolder(r).value();
    }

    public boolean is(T object, HolderLookup.Provider r) {
        return this.getHolder(r).value() == object;
    }

    public boolean is(T object, LevelReader level) {
        return this.is(object, (HolderLookup.Provider)level.registryAccess());
    }

    public boolean is(TagKey<T> tag, HolderLookup.Provider r) {
        return this.getHolder(r).is(tag);
    }

    public boolean is(TagKey<T> tag, LevelReader level) {
        return this.is(tag, (HolderLookup.Provider)level.registryAccess());
    }

    public Holder<T> getHolder(Entity entity) {
        return this.getHolder(entity.level());
    }

    public Holder<T> getHolder(Level level) {
        return this.getHolder((HolderLookup.Provider)level.registryAccess());
    }

    public Holder<T> getHolder(LevelReader level) {
        return this.getHolder((HolderLookup.Provider)level.registryAccess());
    }

    public Holder<T> getHolder(HolderLookup.Provider r) {
        Holder<T> holder = this.cache.get(r);
        if (holder != null) {
            return holder;
        }
        Optional lookupReg = r.lookup(this.registryKey);
        HolderLookup.RegistryLookup reg = (HolderLookup.RegistryLookup)lookupReg.get();
        holder = this.lookup((HolderGetter<T>)reg);
        this.cache.put(r, holder);
        return holder;
    }

    public Holder<T> lookup(HolderGetter<T> lookup) {
        try {
            return lookup.getOrThrow(this.key);
        }
        catch (Exception e) {
            Object extra = "";
            if (lookup instanceof HolderLookup) {
                HolderLookup l = (HolderLookup)lookup;
                extra = ".\nRegistry content was: " + String.valueOf(l.listElements().map(b -> b.key().location()).toList());
            }
            throw new RuntimeException("Failed to get object from registry: " + String.valueOf(this.key) + ".\nCalled from " + String.valueOf(Thread.currentThread()) + ".\n" + (String)extra);
        }
    }

    public String getRegisteredName() {
        return this.key.location().toString();
    }

    public ResourceLocation getID() {
        return this.key.location();
    }

    public ResourceKey<T> getKey() {
        return this.key;
    }

    public boolean is(ResourceLocation location) {
        return this.registryKey.location().equals((Object)location);
    }

    public boolean is(ResourceKey<T> resourceKey) {
        return resourceKey == this.key;
    }

    public boolean is(Predicate<ResourceKey<T>> predicate) {
        return predicate.test(this.key);
    }

    public boolean is(Holder<T> other) {
        return other.unwrapKey().get() == this.key;
    }

    public String toString() {
        return "DynamicHolder{" + String.valueOf(this.key) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HolderRef)) {
            return false;
        }
        HolderRef that = (HolderRef)o;
        return Objects.equals(this.registryKey, that.registryKey) && Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.registryKey, this.key);
    }

    @Deprecated(forRemoval=true)
    public static class Opt<T>
    extends OptHolderRef<T> {
        protected Opt(ResourceKey<Registry<T>> registryKey, ResourceKey<T> key) {
            super(registryKey, key);
        }
    }
}

