/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.new_slab_variants.core.common.block;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HoneySlabBlock
extends SlabBlock {
    private static final double SLIDE_STARTS_WHEN_VERTICAL_SPEED_IS_AT_LEAST = 0.13;
    private static final double MIN_FALL_SPEED_TO_BE_CONSIDERED_SLIDING = 0.08;
    private static final double THROTTLE_SLIDE_SPEED_TO = 0.05;
    private static final int SLIDE_ADVANCEMENT_CHECK_INTERVAL = 20;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public HoneySlabBlock(BlockBehaviour.Properties $$0) {
        super($$0);
    }

    private static boolean doesEntityDoHoneyBlockSlideEffects(Entity $$0) {
        return $$0 instanceof LivingEntity || $$0 instanceof AbstractMinecart || $$0 instanceof PrimedTnt || $$0 instanceof Boat;
    }

    public VoxelShape m_5939_(BlockState $$0, BlockGetter $$1, BlockPos $$2, CollisionContext $$3) {
        return SHAPE;
    }

    public void m_142072_(Level $$0, BlockState $$1, BlockPos $$2, Entity $$3, float $$4) {
        $$3.m_5496_(SoundEvents.f_11968_, 1.0f, 1.0f);
        if (!$$0.f_46443_) {
            $$0.m_7605_($$3, (byte)54);
        }
        if ($$3.m_142535_($$4, 0.2f, $$0.m_269111_().m_268989_())) {
            $$3.m_5496_(this.f_60446_.m_56779_(), this.f_60446_.m_56773_() * 0.5f, this.f_60446_.m_56774_() * 0.75f);
        }
    }

    public void m_7892_(BlockState $$0, Level $$1, BlockPos $$2, Entity $$3) {
        if (this.isSlidingDown($$2, $$3)) {
            this.maybeDoSlideAchievement($$3, $$2);
            this.doSlideMovement($$3);
            this.maybeDoSlideEffects($$1, $$3);
        }
        super.m_7892_($$0, $$1, $$2, $$3);
    }

    private boolean isSlidingDown(BlockPos $$0, Entity $$1) {
        if ($$1.m_20096_()) {
            return false;
        }
        if ($$1.m_20186_() > (double)$$0.m_123342_() + 0.9375 - 1.0E-7) {
            return false;
        }
        if ($$1.m_20184_().f_82480_ >= -0.08) {
            return false;
        }
        double $$2 = Math.abs((double)$$0.m_123341_() + 0.5 - $$1.m_20185_());
        double $$3 = Math.abs((double)$$0.m_123343_() + 0.5 - $$1.m_20189_());
        double $$4 = 0.4375 + (double)($$1.m_20205_() / 2.0f);
        return $$2 + 1.0E-7 > $$4 || $$3 + 1.0E-7 > $$4;
    }

    private void maybeDoSlideAchievement(Entity $$0, BlockPos $$1) {
        if ($$0 instanceof ServerPlayer && $$0.m_9236_().m_46467_() % 20L == 0L) {
            CriteriaTriggers.f_10559_.m_66978_((ServerPlayer)$$0, $$0.m_9236_().m_8055_($$1));
        }
    }

    private void doSlideMovement(Entity $$0) {
        Vec3 $$1 = $$0.m_20184_();
        if ($$1.f_82480_ < -0.13) {
            double $$2 = -0.05 / $$1.f_82480_;
            $$0.m_20256_(new Vec3($$1.f_82479_ * $$2, -0.05, $$1.f_82481_ * $$2));
        } else {
            $$0.m_20256_(new Vec3($$1.f_82479_, -0.05, $$1.f_82481_));
        }
        $$0.m_183634_();
    }

    private void maybeDoSlideEffects(Level $$0, Entity $$1) {
        if (HoneySlabBlock.doesEntityDoHoneyBlockSlideEffects($$1)) {
            if ($$0.f_46441_.m_188503_(5) == 0) {
                $$1.m_5496_(SoundEvents.f_11968_, 1.0f, 1.0f);
            }
            if (!$$0.f_46443_ && $$0.f_46441_.m_188503_(5) == 0) {
                $$0.m_7605_($$1, (byte)53);
            }
        }
    }

    public static void showSlideParticles(Entity $$0) {
        HoneySlabBlock.showParticles($$0, 5);
    }

    public static void showJumpParticles(Entity $$0) {
        HoneySlabBlock.showParticles($$0, 10);
    }

    private static void showParticles(Entity $$0, int $$1) {
        if ($$0.m_9236_().f_46443_) {
            BlockState $$2 = Blocks.f_50719_.m_49966_();
            for (int $$3 = 0; $$3 < $$1; ++$$3) {
                $$0.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, $$2), $$0.m_20185_(), $$0.m_20186_(), $$0.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }
}

