/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.core;

import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.core.CommonAbstractions;
import fuzs.mutantmonsters.core.ZombieResurrection;
import fuzs.mutantmonsters.network.S2CSeismicWaveFluidParticlesMessage;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SeismicWave
extends BlockPos {
    private final boolean first;
    private final boolean affectsTerrain;

    public SeismicWave(int x, int y, int z, boolean first, boolean affectsTerrain) {
        super(x, y, z);
        this.first = first;
        this.affectsTerrain = affectsTerrain;
    }

    public boolean isFirst() {
        return this.first;
    }

    public boolean affectsTerrain() {
        return this.affectsTerrain;
    }

    public static void createWaves(Level world, List<SeismicWave> list, int x1, int z1, int x2, int z2, int y) {
        int deltaX = x2 - x1;
        int deltaZ = z2 - z1;
        int xStep = deltaX < 0 ? -1 : 1;
        int zStep = deltaZ < 0 ? -1 : 1;
        deltaX = Math.abs(deltaX);
        deltaZ = Math.abs(deltaZ);
        int x = x1;
        int z = z1;
        int deltaX2 = deltaX * 2;
        int deltaZ2 = deltaZ * 2;
        int firstY = ZombieResurrection.getSuitableGround(world, x1, y, z1, 3, false);
        SeismicWave wave = new SeismicWave(x1, y, z1, true, true);
        if (firstY != -1) {
            wave = new SeismicWave(x1, firstY, z1, true, true);
        }
        list.add(wave);
        if (deltaX2 >= deltaZ2) {
            int error = deltaX;
            for (int i = 0; i < deltaX; ++i) {
                x += xStep;
                if ((error += deltaZ2) > deltaX2) {
                    z += zStep;
                    error -= deltaX2;
                }
                SeismicWave.addWave(world, list, x, y, z);
            }
        } else {
            int error = deltaZ;
            for (int i = 0; i < deltaZ; ++i) {
                z += zStep;
                if ((error += deltaX2) > deltaZ2) {
                    x += xStep;
                    error -= deltaZ2;
                }
                SeismicWave.addWave(world, list, x, y, z);
            }
        }
    }

    @Nullable
    public static SeismicWave addWave(Level world, List<SeismicWave> list, int x, int y, int z) {
        y = ZombieResurrection.getSuitableGround(world, x, y, z, 3, false);
        SeismicWave wave = null;
        if (y != -1) {
            wave = new SeismicWave(x, y, z, false, true);
            list.add(wave);
        }
        if (world.f_46441_.m_188503_(2) == 0) {
            list.add(new SeismicWave(x, y + 1, z, false, false));
        }
        return wave;
    }

    public void affectBlocks(Level world, Entity entity) {
        if (this.affectsTerrain) {
            Player playerEntity;
            BlockPos posAbove = this.m_7494_();
            BlockState blockstate = world.m_8055_((BlockPos)this);
            Block block = blockstate.m_60734_();
            Player player = playerEntity = entity instanceof Player ? (Player)entity : null;
            if (playerEntity != null && playerEntity.m_36326_() || world.m_46469_().m_46207_(GameRules.f_46132_)) {
                if (blockstate.m_60713_(Blocks.f_50440_) || blockstate.m_60713_(Blocks.f_152481_) || blockstate.m_60713_(Blocks.f_50093_) || blockstate.m_60713_(Blocks.f_50599_) || blockstate.m_60713_(Blocks.f_50195_)) {
                    world.m_46597_((BlockPos)this, Blocks.f_50493_.m_49966_());
                }
                BlockState blockstateAbove = world.m_8055_(posAbove);
                float hardness = blockstateAbove.m_60800_((BlockGetter)world, posAbove);
                if (blockstateAbove.m_60812_((BlockGetter)world, posAbove).m_83281_() && hardness > -1.0f && hardness <= 1.0f) {
                    world.m_46961_(posAbove, playerEntity != null);
                }
                if (block instanceof DoorBlock) {
                    if (DoorBlock.m_52817_((BlockState)blockstate)) {
                        world.m_46796_(1019, (BlockPos)this, 0);
                    } else {
                        world.m_46796_(1020, (BlockPos)this, 0);
                    }
                }
                if (block instanceof TntBlock) {
                    CommonAbstractions.INSTANCE.onBlockCaughtFire(block, blockstate, world, this, null, (LivingEntity)playerEntity);
                    world.m_7471_((BlockPos)this, false);
                }
            }
            if (block instanceof BellBlock) {
                ((BellBlock)block).m_49701_(world, blockstate, new BlockHitResult(Vec3.m_82528_((Vec3i)this), entity.m_6350_(), (BlockPos)this, false), playerEntity, true);
            }
            if (blockstate.m_60713_(Blocks.f_50173_)) {
                block.m_141947_(world, (BlockPos)this, blockstate, entity);
            }
            if (blockstate.m_60819_().m_76178_()) {
                world.m_46796_(2001, posAbove, Block.m_49956_((BlockState)blockstate));
            } else {
                MutantMonsters.NETWORK.sendToAllNearExcept((MessageV2)new S2CSeismicWaveFluidParticlesMessage(this), null, (double)this.m_123341_() + 0.5, (double)this.m_123342_(), (double)this.m_123343_() + 0.5, 1024.0, entity.m_9236_());
            }
        }
    }
}

