/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.datagen;

import com.github.alexthe666.iceandfire.datagen.IafConfiguredFeatures;
import com.github.alexthe666.iceandfire.world.CustomBiomeFilter;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public final class IafPlacedFeatures {
    public static final ResourceKey<PlacedFeature> PLACED_FIRE_DRAGON_ROOST = IafPlacedFeatures.registerKey("fire_dragon_roost");
    public static final ResourceKey<PlacedFeature> PLACED_ICE_DRAGON_ROOST = IafPlacedFeatures.registerKey("ice_dragon_roost");
    public static final ResourceKey<PlacedFeature> PLACED_LIGHTNING_DRAGON_ROOST = IafPlacedFeatures.registerKey("lightning_dragon_roost");
    public static final ResourceKey<PlacedFeature> PLACED_FIRE_DRAGON_CAVE = IafPlacedFeatures.registerKey("fire_dragon_cave");
    public static final ResourceKey<PlacedFeature> PLACED_ICE_DRAGON_CAVE = IafPlacedFeatures.registerKey("ice_dragon_cave");
    public static final ResourceKey<PlacedFeature> PLACED_LIGHTNING_DRAGON_CAVE = IafPlacedFeatures.registerKey("lightning_dragon_cave");
    public static final ResourceKey<PlacedFeature> PLACED_CYCLOPS_CAVE = IafPlacedFeatures.registerKey("cyclops_cave");
    public static final ResourceKey<PlacedFeature> PLACED_PIXIE_VILLAGE = IafPlacedFeatures.registerKey("pixie_village");
    public static final ResourceKey<PlacedFeature> PLACED_SIREN_ISLAND = IafPlacedFeatures.registerKey("siren_island");
    public static final ResourceKey<PlacedFeature> PLACED_HYDRA_CAVE = IafPlacedFeatures.registerKey("hydra_cave");
    public static final ResourceKey<PlacedFeature> PLACED_MYRMEX_HIVE_DESERT = IafPlacedFeatures.registerKey("myrmex_hive_desert");
    public static final ResourceKey<PlacedFeature> PLACED_MYRMEX_HIVE_JUNGLE = IafPlacedFeatures.registerKey("myrmex_hive_jungle");
    public static final ResourceKey<PlacedFeature> PLACED_SPAWN_DEATH_WORM = IafPlacedFeatures.registerKey("spawn_death_worm");
    public static final ResourceKey<PlacedFeature> PLACED_SPAWN_DRAGON_SKELETON_L = IafPlacedFeatures.registerKey("spawn_dragon_skeleton_lightning");
    public static final ResourceKey<PlacedFeature> PLACED_SPAWN_DRAGON_SKELETON_F = IafPlacedFeatures.registerKey("spawn_dragon_skeleton_fire");
    public static final ResourceKey<PlacedFeature> PLACED_SPAWN_DRAGON_SKELETON_I = IafPlacedFeatures.registerKey("spawn_dragon_skeleton_ice");
    public static final ResourceKey<PlacedFeature> PLACED_SPAWN_HIPPOCAMPUS = IafPlacedFeatures.registerKey("spawn_hippocampus");
    public static final ResourceKey<PlacedFeature> PLACED_SPAWN_SEA_SERPENT = IafPlacedFeatures.registerKey("spawn_sea_serpent");
    public static final ResourceKey<PlacedFeature> PLACED_SPAWN_STYMPHALIAN_BIRD = IafPlacedFeatures.registerKey("spawn_stymphalian_bird");
    public static final ResourceKey<PlacedFeature> PLACED_SPAWN_WANDERING_CYCLOPS = IafPlacedFeatures.registerKey("spawn_wandering_cyclops");
    public static final ResourceKey<PlacedFeature> PLACED_SILVER_ORE = IafPlacedFeatures.registerKey("silver_ore");
    public static final ResourceKey<PlacedFeature> PLACED_SAPPHIRE_ORE = IafPlacedFeatures.registerKey("sapphire_ore");
    public static final ResourceKey<PlacedFeature> PLACED_FIRE_LILY = IafPlacedFeatures.registerKey("fire_lily");
    public static final ResourceKey<PlacedFeature> PLACED_LIGHTNING_LILY = IafPlacedFeatures.registerKey("lightning_lily");
    public static final ResourceKey<PlacedFeature> PLACED_FROST_LILY = IafPlacedFeatures.registerKey("frost_lily");

    private static List<PlacementModifier> orePlacement(PlacementModifier pCountPlacement, PlacementModifier pHeightRange) {
        return List.of(pCountPlacement, InSquarePlacement.m_191715_(), pHeightRange, BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> commonOrePlacement(int pCount, PlacementModifier pHeightRange) {
        return IafPlacedFeatures.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)pCount), pHeightRange);
    }

    public static void bootstrap(BootstapContext<PlacedFeature> context) {
        HolderGetter features = context.m_255420_(Registries.f_256911_);
        context.m_255272_(PLACED_FIRE_DRAGON_ROOST, (Object)new PlacedFeature((Holder)features.m_255043_(IafConfiguredFeatures.FIRE_DRAGON_ROOST), List.of(PlacementUtils.f_195354_, BiomeFilter.m_191561_())));
        context.m_255272_(PLACED_ICE_DRAGON_ROOST, (Object)new PlacedFeature((Holder)features.m_255043_(IafConfiguredFeatures.ICE_DRAGON_ROOST), List.of(PlacementUtils.f_195354_, BiomeFilter.m_191561_())));
        context.m_255272_(PLACED_LIGHTNING_DRAGON_ROOST, (Object)new PlacedFeature((Holder)features.m_255043_(IafConfiguredFeatures.LIGHTNING_DRAGON_ROOST), List.of(PlacementUtils.f_195354_, BiomeFilter.m_191561_())));
        context.m_255272_(PLACED_CYCLOPS_CAVE, (Object)new PlacedFeature((Holder)features.m_255043_(IafConfiguredFeatures.CYCLOPS_CAVE), List.of(PlacementUtils.f_195354_, BiomeFilter.m_191561_())));
        context.m_255272_(PLACED_PIXIE_VILLAGE, (Object)new PlacedFeature((Holder)features.m_255043_(IafConfiguredFeatures.PIXIE_VILLAGE), List.of(PlacementUtils.f_195354_, BiomeFilter.m_191561_())));
        context.m_255272_(PLACED_SIREN_ISLAND, (Object)new PlacedFeature((Holder)features.m_255043_(IafConfiguredFeatures.SIREN_ISLAND), List.of(PlacementUtils.f_195354_, BiomeFilter.m_191561_())));
        context.m_255272_(PLACED_HYDRA_CAVE, (Object)new PlacedFeature((Holder)features.m_255043_(IafConfiguredFeatures.HYDRA_CAVE), List.of(PlacementUtils.f_195354_, BiomeFilter.m_191561_())));
        context.m_255272_(PLACED_MYRMEX_HIVE_DESERT, (Object)new PlacedFeature((Holder)features.m_255043_(IafConfiguredFeatures.MYRMEX_HIVE_DESERT), List.of(PlacementUtils.f_195354_, BiomeFilter.m_191561_())));
        context.m_255272_(PLACED_MYRMEX_HIVE_JUNGLE, (Object)new PlacedFeature((Holder)features.m_255043_(IafConfiguredFeatures.MYRMEX_HIVE_JUNGLE), List.of(PlacementUtils.f_195354_, BiomeFilter.m_191561_())));
        context.m_255272_(PLACED_SPAWN_DEATH_WORM, (Object)new PlacedFeature((Holder)features.m_255043_(IafConfiguredFeatures.SPAWN_DEATH_WORM), List.of(PlacementUtils.f_195354_, BiomeFilter.m_191561_())));
        context.m_255272_(PLACED_SPAWN_DRAGON_SKELETON_L, (Object)new PlacedFeature((Holder)features.m_255043_(IafConfiguredFeatures.SPAWN_DRAGON_SKELETON_L), List.of(PlacementUtils.f_195354_, BiomeFilter.m_191561_())));
        context.m_255272_(PLACED_SPAWN_DRAGON_SKELETON_F, (Object)new PlacedFeature((Holder)features.m_255043_(IafConfiguredFeatures.SPAWN_DRAGON_SKELETON_F), List.of(PlacementUtils.f_195354_, BiomeFilter.m_191561_())));
        context.m_255272_(PLACED_SPAWN_DRAGON_SKELETON_I, (Object)new PlacedFeature((Holder)features.m_255043_(IafConfiguredFeatures.SPAWN_DRAGON_SKELETON_I), List.of(PlacementUtils.f_195354_, BiomeFilter.m_191561_())));
        context.m_255272_(PLACED_SPAWN_HIPPOCAMPUS, (Object)new PlacedFeature((Holder)features.m_255043_(IafConfiguredFeatures.SPAWN_HIPPOCAMPUS), List.of(PlacementUtils.f_195354_, BiomeFilter.m_191561_())));
        context.m_255272_(PLACED_SPAWN_SEA_SERPENT, (Object)new PlacedFeature((Holder)features.m_255043_(IafConfiguredFeatures.SPAWN_SEA_SERPENT), List.of(PlacementUtils.f_195354_, BiomeFilter.m_191561_())));
        context.m_255272_(PLACED_SPAWN_STYMPHALIAN_BIRD, (Object)new PlacedFeature((Holder)features.m_255043_(IafConfiguredFeatures.SPAWN_STYMPHALIAN_BIRD), List.of(PlacementUtils.f_195354_, BiomeFilter.m_191561_())));
        context.m_255272_(PLACED_SPAWN_WANDERING_CYCLOPS, (Object)new PlacedFeature((Holder)features.m_255043_(IafConfiguredFeatures.SPAWN_WANDERING_CYCLOPS), List.of(PlacementUtils.f_195354_, BiomeFilter.m_191561_())));
        context.m_255272_(PLACED_FIRE_LILY, (Object)new PlacedFeature((Holder)features.m_255043_(IafConfiguredFeatures.FIRE_LILY), List.of(RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_())));
        context.m_255272_(PLACED_FROST_LILY, (Object)new PlacedFeature((Holder)features.m_255043_(IafConfiguredFeatures.FROST_LILY), List.of(RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_())));
        context.m_255272_(PLACED_LIGHTNING_LILY, (Object)new PlacedFeature((Holder)features.m_255043_(IafConfiguredFeatures.LIGHTNING_LILY), List.of(RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_())));
        context.m_255272_(PLACED_SILVER_ORE, (Object)new PlacedFeature((Holder)features.m_255043_(IafConfiguredFeatures.SILVER_ORE), IafPlacedFeatures.commonOrePlacement(16, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-16), (VerticalAnchor)VerticalAnchor.m_158922_((int)112)))));
        context.m_255272_(PLACED_SAPPHIRE_ORE, (Object)new PlacedFeature((Holder)features.m_255043_(IafConfiguredFeatures.SAPPHIRE_ORE), IafPlacedFeatures.commonOrePlacement(4, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-16), (VerticalAnchor)VerticalAnchor.m_158922_((int)112)))));
        context.m_255272_(PLACED_FIRE_DRAGON_CAVE, (Object)new PlacedFeature((Holder)features.m_255043_(IafConfiguredFeatures.FIRE_DRAGON_CAVE), List.of(CustomBiomeFilter.biome())));
        context.m_255272_(PLACED_ICE_DRAGON_CAVE, (Object)new PlacedFeature((Holder)features.m_255043_(IafConfiguredFeatures.ICE_DRAGON_CAVE), List.of(CustomBiomeFilter.biome())));
        context.m_255272_(PLACED_LIGHTNING_DRAGON_CAVE, (Object)new PlacedFeature((Holder)features.m_255043_(IafConfiguredFeatures.LIGHTNING_DRAGON_CAVE), List.of(CustomBiomeFilter.biome())));
    }

    public static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("iceandfire", name));
    }
}

