/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.worldgen.structure.structures;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.CappedProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosAlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.AppendLoot;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifier;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import samebutdifferent.ecologics.registry.ModStructurePieces;
import samebutdifferent.ecologics.worldgen.structure.DesertRuinStructure;

public class DesertRuinPieces {
    static final StructureProcessor DESERT_RUIN_PROCESSOR = DesertRuinPieces.archyRuleProcessor(Blocks.f_49992_, Blocks.f_271439_, BuiltInLootTables.f_276661_);
    private static final ResourceLocation[] DESERT_RUINS = new ResourceLocation[]{new ResourceLocation("ecologics", "desert_ruin/chest_house"), new ResourceLocation("ecologics", "desert_ruin/pit"), new ResourceLocation("ecologics", "desert_ruin/pillars1"), new ResourceLocation("ecologics", "desert_ruin/pillars2"), new ResourceLocation("ecologics", "desert_ruin/wall1"), new ResourceLocation("ecologics", "desert_ruin/wall2")};

    private static StructureProcessor archyRuleProcessor(Block block, Block suspiciousBlock, ResourceLocation lootTable) {
        return new CappedProcessor((StructureProcessor)new RuleProcessor(List.of(new ProcessorRule((RuleTest)new BlockMatchTest(block), (RuleTest)AlwaysTrueTest.f_73954_, (PosRuleTest)PosAlwaysTrueTest.f_74188_, suspiciousBlock.m_49966_(), (RuleBlockEntityModifier)new AppendLoot(lootTable)))), (IntProvider)ConstantInt.m_146483_((int)5));
    }

    private static ResourceLocation getRandomRuin(RandomSource random) {
        return (ResourceLocation)Util.m_214670_((Object[])DESERT_RUINS, (RandomSource)random);
    }

    public static void addPieces(StructureTemplateManager structureTemplateManager, BlockPos pos, Rotation rotation, StructurePieceAccessor structurePieceAccessor, RandomSource random, DesertRuinStructure structure) {
        DesertRuinPieces.addPiece(structureTemplateManager, pos, rotation, structurePieceAccessor, random, structure, 0.9f);
        if (random.m_188501_() <= 0.4f) {
            DesertRuinPieces.addClusterRuins(structureTemplateManager, random, rotation, pos, structure, structurePieceAccessor);
        }
    }

    private static void addClusterRuins(StructureTemplateManager structureTemplateManager, RandomSource random, Rotation rotation, BlockPos pos, DesertRuinStructure structure, StructurePieceAccessor structurePieceAccessor) {
        BlockPos blockPos = new BlockPos(pos.m_123341_(), 90, pos.m_123343_());
        BlockPos blockPos2 = StructureTemplate.m_74593_((BlockPos)new BlockPos(15, 0, 15), (Mirror)Mirror.NONE, (Rotation)rotation, (BlockPos)BlockPos.f_121853_).m_121955_((Vec3i)blockPos);
        BoundingBox boundingBox = BoundingBox.m_162375_((Vec3i)blockPos, (Vec3i)blockPos2);
        BlockPos blockPos3 = new BlockPos(Math.min(blockPos.m_123341_(), blockPos2.m_123341_()), blockPos.m_123342_(), Math.min(blockPos.m_123343_(), blockPos2.m_123343_()));
        List<BlockPos> list = DesertRuinPieces.allPositions(random, blockPos3);
        int i = Mth.m_216271_((RandomSource)random, (int)4, (int)8);
        for (int j = 0; j < i; ++j) {
            Rotation rotation2;
            BlockPos blockPos4;
            if (list.isEmpty() || BoundingBox.m_162375_((Vec3i)(blockPos4 = list.remove(random.m_188503_(list.size()))), (Vec3i)StructureTemplate.m_74593_((BlockPos)new BlockPos(5, 0, 6), (Mirror)Mirror.NONE, (Rotation)(rotation2 = Rotation.m_221990_((RandomSource)random)), (BlockPos)BlockPos.f_121853_).m_121955_((Vec3i)blockPos4)).m_71049_(boundingBox)) continue;
            DesertRuinPieces.addPiece(structureTemplateManager, blockPos4, rotation2, structurePieceAccessor, random, structure, 0.8f);
        }
    }

    private static List<BlockPos> allPositions(RandomSource random, BlockPos pos) {
        ArrayList list = Lists.newArrayList();
        list.add(pos.m_7918_(-16 + Mth.m_216271_((RandomSource)random, (int)1, (int)8), 0, 16 + Mth.m_216271_((RandomSource)random, (int)1, (int)7)));
        list.add(pos.m_7918_(-16 + Mth.m_216271_((RandomSource)random, (int)1, (int)8), 0, Mth.m_216271_((RandomSource)random, (int)1, (int)7)));
        list.add(pos.m_7918_(-16 + Mth.m_216271_((RandomSource)random, (int)1, (int)8), 0, -16 + Mth.m_216271_((RandomSource)random, (int)4, (int)8)));
        list.add(pos.m_7918_(Mth.m_216271_((RandomSource)random, (int)1, (int)7), 0, 16 + Mth.m_216271_((RandomSource)random, (int)1, (int)7)));
        list.add(pos.m_7918_(Mth.m_216271_((RandomSource)random, (int)1, (int)7), 0, -16 + Mth.m_216271_((RandomSource)random, (int)4, (int)6)));
        list.add(pos.m_7918_(16 + Mth.m_216271_((RandomSource)random, (int)1, (int)7), 0, 16 + Mth.m_216271_((RandomSource)random, (int)3, (int)8)));
        list.add(pos.m_7918_(16 + Mth.m_216271_((RandomSource)random, (int)1, (int)7), 0, Mth.m_216271_((RandomSource)random, (int)1, (int)7)));
        list.add(pos.m_7918_(16 + Mth.m_216271_((RandomSource)random, (int)1, (int)7), 0, -16 + Mth.m_216271_((RandomSource)random, (int)4, (int)8)));
        return list;
    }

    private static void addPiece(StructureTemplateManager structureTemplateManager, BlockPos pos, Rotation rotation, StructurePieceAccessor structurePieceAccessor, RandomSource random, DesertRuinStructure structure, float integrity) {
        ResourceLocation resourceLocation = DesertRuinPieces.getRandomRuin(random);
        structurePieceAccessor.m_142679_((StructurePiece)new DesertRuinPiece(structureTemplateManager, resourceLocation, pos, rotation, integrity));
    }

    public static class DesertRuinPiece
    extends TemplateStructurePiece {
        private final float integrity;

        public DesertRuinPiece(StructureTemplateManager structureTemplateManager, ResourceLocation location, BlockPos pos, Rotation rotation, float integrity) {
            super(ModStructurePieces.DESERT_RUIN.get(), 0, structureTemplateManager, location, location.toString(), DesertRuinPiece.makeSettings(rotation, integrity), pos);
            this.integrity = integrity;
        }

        private DesertRuinPiece(StructureTemplateManager structureTemplateManager, CompoundTag genDepth, Rotation rotation, float integrity) {
            super(ModStructurePieces.DESERT_RUIN.get(), genDepth, structureTemplateManager, resourceLocation -> DesertRuinPiece.makeSettings(rotation, integrity));
            this.integrity = integrity;
        }

        private static StructurePlaceSettings makeSettings(Rotation rotation, float integrity) {
            StructureProcessor structureProcessor = DESERT_RUIN_PROCESSOR;
            return new StructurePlaceSettings().m_74379_(rotation).m_74377_(Mirror.NONE).m_74383_((StructureProcessor)new BlockRotProcessor(integrity)).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74048_).m_74383_(structureProcessor);
        }

        public static DesertRuinPiece create(StructureTemplateManager structureTemplateManager, CompoundTag tag) {
            Rotation rotation = Rotation.valueOf((String)tag.m_128461_("Rot"));
            float f = tag.m_128457_("Integrity");
            return new DesertRuinPiece(structureTemplateManager, tag, rotation, f);
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
            super.m_183620_(context, tag);
            tag.m_128359_("Rot", this.f_73657_.m_74404_().name());
            tag.m_128350_("Integrity", this.integrity);
        }

        protected void m_213704_(String name, BlockPos pos, ServerLevelAccessor level, RandomSource random, BoundingBox box) {
            Husk husk;
            if ("chest".equals(name)) {
                level.m_7731_(pos, (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51480_, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_205070_(FluidTags.f_13131_))), 2);
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof ChestBlockEntity) {
                    ((ChestBlockEntity)blockEntity).m_59626_(BuiltInLootTables.f_279573_, random.m_188505_());
                }
            } else if ("drowned".equals(name) && (husk = (Husk)EntityType.f_20458_.m_20615_((Level)level.m_6018_())) != null) {
                husk.m_21530_();
                husk.m_20035_(pos, 0.0f, 0.0f);
                husk.m_6518_(level, level.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
                level.m_47205_((Entity)husk);
                if (pos.m_123342_() > level.m_5736_()) {
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
                } else {
                    level.m_7731_(pos, Blocks.f_49990_.m_49966_(), 2);
                }
            }
        }

        public void m_213694_(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
            int i = level.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, this.f_73658_.m_123341_(), this.f_73658_.m_123343_());
            this.f_73658_ = new BlockPos(this.f_73658_.m_123341_(), i, this.f_73658_.m_123343_());
            BlockPos blockPos = StructureTemplate.m_74593_((BlockPos)new BlockPos(this.f_73656_.m_163801_().m_123341_() - 1, 0, this.f_73656_.m_163801_().m_123343_() - 1), (Mirror)Mirror.NONE, (Rotation)this.f_73657_.m_74404_(), (BlockPos)BlockPos.f_121853_).m_121955_((Vec3i)this.f_73658_);
            this.f_73658_ = new BlockPos(this.f_73658_.m_123341_(), this.getHeight(this.f_73658_, (BlockGetter)level, blockPos), this.f_73658_.m_123343_());
            super.m_213694_(level, structureManager, generator, random, box, chunkPos, pos);
        }

        private int getHeight(BlockPos templatePos, BlockGetter level, BlockPos pos) {
            int i = templatePos.m_123342_();
            int j = 512;
            int k = i - 1;
            int l = 0;
            for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)templatePos, (BlockPos)pos)) {
                int m = blockPos.m_123341_();
                int n = blockPos.m_123343_();
                int o = templatePos.m_123342_() - 1;
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(m, o, n);
                BlockState blockState = level.m_8055_((BlockPos)mutableBlockPos);
                FluidState fluidState = level.m_6425_((BlockPos)mutableBlockPos);
                while (blockState.m_60795_() && o > level.m_141937_() + 1) {
                    mutableBlockPos.m_122178_(m, --o, n);
                    blockState = level.m_8055_((BlockPos)mutableBlockPos);
                    fluidState = level.m_6425_((BlockPos)mutableBlockPos);
                }
                j = Math.min(j, o);
                if (o >= k - 2) continue;
                ++l;
            }
            int p = Math.abs(templatePos.m_123341_() - pos.m_123341_());
            if (k - j > 2 && l > p - 2) {
                i = j + 1;
            }
            return i;
        }
    }
}

