/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.worldgen;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class KoboldData
extends SavedData {
    private static final String IDENTIFIER = "kobold_data";
    private static Map<Level, KoboldData> dataMap = new HashMap<Level, KoboldData>();
    private int rascalDelay;
    private int rascalChance;

    public static KoboldData get(Level world) {
        if (world instanceof ServerLevel) {
            ServerLevel overworld = world.m_7654_().m_129880_(Level.f_46428_);
            KoboldData map = dataMap.get(overworld);
            if (map == null) {
                DimensionDataStorage storage = overworld.m_8895_();
                KoboldData data = (KoboldData)storage.m_164861_(KoboldData::load, KoboldData::new, IDENTIFIER);
                if (data != null) {
                    data.m_77762_();
                }
                dataMap.put(world, data);
                return data;
            }
            return map;
        }
        return null;
    }

    public static KoboldData load(CompoundTag tag) {
        KoboldData data = new KoboldData();
        if (tag.m_128425_("RascalDelay", 99)) {
            data.rascalDelay = tag.m_128451_("RascalDelay");
        }
        if (tag.m_128425_("RascalChance", 99)) {
            data.rascalChance = tag.m_128451_("RascalChance");
        }
        return data;
    }

    public int getRascalDelay() {
        return this.rascalDelay;
    }

    public void setRascalDelay(int i) {
        this.rascalDelay = i;
    }

    public int getRascalChance() {
        return this.rascalChance;
    }

    public void setRascalChance(int i) {
        this.rascalChance = i;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128405_("RascalDelay", this.rascalDelay);
        tag.m_128405_("RascalChance", this.rascalChance);
        return tag;
    }
}

