/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.ForgeEventFactory;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.entity.Kobold;
import net.salju.kobolds.entity.KoboldCaptain;
import net.salju.kobolds.entity.KoboldEnchanter;
import net.salju.kobolds.entity.KoboldEngineer;
import net.salju.kobolds.entity.KoboldWarrior;
import net.salju.kobolds.init.KoboldsItems;
import net.salju.kobolds.init.KoboldsMobs;

public class KoboldZombie
extends Zombie {
    private static final EntityDataAccessor<Boolean> DATA_CONVERTING = SynchedEntityData.m_135353_(KoboldZombie.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> DATA_TYPE = SynchedEntityData.m_135353_(KoboldZombie.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private int zomboType;
    private int convert;

    public KoboldZombie(EntityType<KoboldZombie> type, Level world) {
        super(type, world);
        this.m_21530_();
        this.m_20299_(0.5f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CONVERTING, (Object)false);
        this.f_19804_.m_135372_(DATA_TYPE, (Object)"base");
    }

    protected void m_8099_() {
        super.m_8099_();
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("ZomboType", this.zomboType);
        tag.m_128405_("Convert", this.convert);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setZombo(tag.m_128451_("ZomboType"));
        this.convert = tag.m_128451_("Convert");
    }

    public double m_6049_() {
        return this.m_6162_() ? 0.0 : -0.225;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return this.m_6162_() ? 0.66f : 1.26f;
    }

    protected boolean m_7593_() {
        return false;
    }

    public boolean m_6162_() {
        return false;
    }

    public boolean m_21531_() {
        return false;
    }

    public boolean isConvert() {
        return (Boolean)this.m_20088_().m_135370_(DATA_CONVERTING);
    }

    public String getZomboType() {
        return (String)this.m_20088_().m_135370_(DATA_TYPE);
    }

    public SoundEvent m_7515_() {
        return SoundEvents.f_12615_;
    }

    public SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12646_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_12645_;
    }

    public void m_6075_() {
        super.m_6075_();
        if (!this.m_9236_().m_5776_() && this.m_6084_() && !this.m_21525_()) {
            if (this.convert > 1) {
                --this.convert;
                if (!this.isConvert()) {
                    this.m_20088_().m_135381_(DATA_CONVERTING, (Object)true);
                }
            } else if (this.convert == 1 && this.m_6084_()) {
                this.m_5496_(SoundEvents.f_12616_, 1.0f, 1.0f);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel lvl = (ServerLevel)level;
                    if (this.zomboType <= 1) {
                        KoboldCaptain capty = (KoboldCaptain)this.m_21406_((EntityType)KoboldsMobs.KOBOLD_CAPTAIN.get(), true);
                        capty.m_21553_(true);
                        ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)capty);
                    } else if (this.zomboType == 2) {
                        Kobold pirate = (Kobold)this.m_21406_((EntityType)KoboldsMobs.KOBOLD_PIRATE.get(), true);
                        pirate.m_21553_(true);
                        ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)pirate);
                    } else if (this.zomboType == 3) {
                        KoboldWarrior war = (KoboldWarrior)this.m_21406_((EntityType)KoboldsMobs.KOBOLD_WARRIOR.get(), true);
                        war.m_21553_(true);
                        ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)war);
                    } else if (this.zomboType == 4) {
                        KoboldEngineer engi = (KoboldEngineer)this.m_21406_((EntityType)KoboldsMobs.KOBOLD_ENGINEER.get(), true);
                        engi.m_21553_(true);
                        ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)engi);
                    } else if (this.zomboType == 5) {
                        KoboldEnchanter magic = (KoboldEnchanter)this.m_21406_((EntityType)KoboldsMobs.KOBOLD_ENCHANTER.get(), true);
                        magic.m_21553_(true);
                        ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)magic);
                    } else {
                        Kobold basic = (Kobold)this.m_21406_((EntityType)KoboldsMobs.KOBOLD.get(), true);
                        basic.m_21553_(true);
                        ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)basic);
                    }
                }
            }
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack apple = player.m_21120_(hand);
        int waitTicks = 0;
        int potionLevel = 0;
        if (!this.m_9236_().m_5776_() && apple.m_41720_() == Items.f_42436_ && this.m_21023_(MobEffects.f_19613_)) {
            if (this.m_9236_().m_46791_() == Difficulty.EASY) {
                potionLevel = 0;
                waitTicks = 1200;
            } else if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                potionLevel = 0;
                waitTicks = 2400;
            } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                potionLevel = 1;
                waitTicks = 4800;
            }
            if (!player.m_7500_()) {
                apple.m_41774_(1);
            }
            player.m_21011_(hand, true);
            this.m_5496_(SoundEvents.f_12644_, 1.0f, 1.0f);
            this.m_21195_(MobEffects.f_19613_);
            this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, waitTicks, potionLevel));
            this.convert = waitTicks;
            this.m_20088_().m_135381_(DATA_CONVERTING, (Object)true);
        }
        return super.m_6071_(player, hand);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (reason != MobSpawnType.CONVERSION) {
            this.setZombo(Mth.m_216271_((RandomSource)world.m_213780_(), (int)1, (int)6));
            this.m_213945_(world.m_213780_(), difficulty);
            this.m_213946_(world.m_213780_(), difficulty);
        }
        return super.m_6518_(world, difficulty, reason, data, tag);
    }

    protected void m_213945_(RandomSource randy, DifficultyInstance souls) {
        if (this.getZomboType() == "warrior") {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)KoboldsItems.KOBOLD_IRON_AXE.get()));
        } else if (this.getZomboType() == "pirate_captain") {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)KoboldsItems.KOBOLD_IRON_SWORD.get()));
        } else if (this.getZomboType() == "engineer") {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42717_));
        } else if (this.getZomboType() == "base" || this.getZomboType() == "pirate") {
            if (Math.random() >= 0.6) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42717_));
            } else {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)KoboldsItems.KOBOLD_IRON_SWORD.get()));
            }
        }
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        if (this.getZomboType() == "warrior") {
            this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42740_));
        }
        this.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
    }

    public void setZombo(AbstractKoboldEntity kobold) {
        if (kobold.m_6095_() == KoboldsMobs.KOBOLD_CAPTAIN.get()) {
            this.m_20088_().m_135381_(DATA_TYPE, (Object)"pirate_captain");
            this.zomboType = 1;
        } else if (kobold.m_6095_() == KoboldsMobs.KOBOLD_PIRATE.get()) {
            this.m_20088_().m_135381_(DATA_TYPE, (Object)"pirate");
            this.zomboType = 2;
        } else if (kobold.m_6095_() == KoboldsMobs.KOBOLD_WARRIOR.get()) {
            this.m_20088_().m_135381_(DATA_TYPE, (Object)"warrior");
            this.zomboType = 3;
        } else if (kobold.m_6095_() == KoboldsMobs.KOBOLD_ENGINEER.get()) {
            this.m_20088_().m_135381_(DATA_TYPE, (Object)"engineer");
            this.zomboType = 4;
        } else if (kobold.m_6095_() == KoboldsMobs.KOBOLD_ENCHANTER.get()) {
            this.m_20088_().m_135381_(DATA_TYPE, (Object)"enchanter");
            this.zomboType = 5;
        } else {
            this.m_20088_().m_135381_(DATA_TYPE, (Object)"base");
            this.zomboType = 6;
        }
    }

    public void setZombo(int i) {
        this.zomboType = i;
        if (i <= 1) {
            this.m_20088_().m_135381_(DATA_TYPE, (Object)"pirate_captain");
        } else if (i == 2) {
            this.m_20088_().m_135381_(DATA_TYPE, (Object)"pirate");
        } else if (i == 3) {
            this.m_20088_().m_135381_(DATA_TYPE, (Object)"warrior");
        } else if (i == 4) {
            this.m_20088_().m_135381_(DATA_TYPE, (Object)"engineer");
        } else if (i == 5) {
            this.m_20088_().m_135381_(DATA_TYPE, (Object)"enchanter");
        } else if (i >= 6) {
            this.m_20088_().m_135381_(DATA_TYPE, (Object)"base");
        }
    }

    public static AttributeSupplier.Builder m_34328_() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.2);
        builder = builder.m_22268_(Attributes.f_22276_, 18.0);
        builder = builder.m_22268_(Attributes.f_22284_, 2.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22266_(Attributes.f_22287_);
        return builder;
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)KoboldsMobs.KOBOLD_ZOMBIE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.m_217057_((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random));
    }
}

