/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.shulkerbox.corelib.inventory;

import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ItemListInventory
implements Container {
    protected NonNullList<ItemStack> items;
    private Runnable onMarkDirty;
    private Function<Player, Boolean> onIsUsableByPlayer;

    public ItemListInventory(NonNullList<ItemStack> items, Runnable onMarkDirty, Function<Player, Boolean> onIsUsableByPlayer) {
        this.items = items;
        this.onMarkDirty = onMarkDirty;
        this.onIsUsableByPlayer = onIsUsableByPlayer;
    }

    public ItemListInventory(NonNullList<ItemStack> items, Runnable onMarkDirty) {
        this(items, onMarkDirty, null);
    }

    public ItemListInventory(NonNullList<ItemStack> items) {
        this(items, null);
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        return this.items.stream().allMatch(ItemStack::m_41619_);
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack itemstack = ContainerHelper.m_18969_(this.items, (int)index, (int)count);
        if (!itemstack.m_41619_()) {
            this.m_6596_();
        }
        return itemstack;
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public void m_6596_() {
        if (this.onMarkDirty != null) {
            this.onMarkDirty.run();
        }
    }

    public boolean m_6542_(Player player) {
        if (this.onIsUsableByPlayer != null) {
            return this.onIsUsableByPlayer.apply(player);
        }
        return true;
    }

    public void m_6211_() {
        this.items.clear();
    }
}

