/*
 * Decompiled with CFR 0.152.
 */
package filthycoin.theorcs.common.entities;

import filthycoin.theorcs.common.entities.BaseModEntity;
import filthycoin.theorcs.common.entities.state_machines.StateHolder;
import filthycoin.theorcs.common.entities.state_machines.states.FirstAggroState;
import filthycoin.theorcs.common.entities.state_machines.states.MeleeAttackState;
import filthycoin.theorcs.common.entities.state_machines.states.MeleeChasingState;
import filthycoin.theorcs.common.entities.state_machines.states.MonsterWanderingState;
import filthycoin.theorcs.common.entities.state_machines.transitions.StateTransition;
import filthycoin.theorcs.common.entities.state_machines.transitions.StateTransitionParameter;
import filthycoin.theorcs.common.entities.state_machines.transitions.operators.StateTransitionEqual;
import filthycoin.theorcs.common.entities.state_machines.transitions.operators.StateTransitionGreater;
import filthycoin.theorcs.common.entities.state_machines.transitions.operators.StateTransitionGreaterEqual;
import filthycoin.theorcs.common.entities.state_machines.transitions.operators.StateTransitionLessEqual;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.core.animation.RawAnimation;

public class OrcGruntEntity
extends BaseModEntity {
    public OrcGruntEntity(EntityType<? extends PathfinderMob> p_21368_, Level p_21369_) {
        super(p_21368_, p_21369_);
        this.animations.put("idle", RawAnimation.begin().thenLoop("grunt.animation.idle"));
        this.animations.put("walk", RawAnimation.begin().thenLoop("grunt.animation.walk"));
        this.animations.put("death", RawAnimation.begin().thenPlay("grunt.animation.death"));
        this.animations.put("attack", RawAnimation.begin().thenPlay("grunt.animation.attack"));
        this.animations.put("aggro", RawAnimation.begin().thenPlay("grunt.animation.aggro"));
        this.wander_wait_time_range = 40;
        this.stateMachine.AddState("idle", new StateHolder(new MonsterWanderingState(false), new StateTransition[]{new StateTransition("aggro", new StateTransitionParameter[]{new StateTransitionParameter("aggro_timer", new StateTransitionLessEqual(0.0f)), new StateTransitionParameter("angry", new StateTransitionEqual(1.0f))}), new StateTransition("chasing", new StateTransitionParameter[]{new StateTransitionParameter("aggro_timer", new StateTransitionGreater(0.0f)), new StateTransitionParameter("angry", new StateTransitionEqual(1.0f))})}));
        this.stateMachine.AddState("aggro", new StateHolder(new FirstAggroState(), new StateTransition[]{new StateTransition("chasing", new StateTransitionParameter[]{new StateTransitionParameter("chasing", new StateTransitionGreaterEqual(1.0f))})}).SetStateLength(60));
        this.stateMachine.AddState("chasing", new StateHolder(new MeleeChasingState(), new StateTransition[]{new StateTransition("attacking", new StateTransitionParameter[]{new StateTransitionParameter("attacking", new StateTransitionGreaterEqual(1.0f))}), new StateTransition("idle", new StateTransitionParameter[]{new StateTransitionParameter("angry", new StateTransitionLessEqual(0.0f))})}));
        this.stateMachine.AddState("attacking", new StateHolder(new MeleeAttackState(15, 5.0f, 0.75f), new StateTransition[]{new StateTransition("chasing", new StateTransitionParameter[]{new StateTransitionParameter("attacking", new StateTransitionLessEqual(0.0f))})}).SetStateLength(20));
        this.stateMachine.SetCurrentState("idle");
        this.SetAnimation("idle");
        this.melee_attack_range = 3.0f;
    }

    public boolean m_147207_(MobEffectInstance effect, @Nullable Entity entity) {
        if (effect.m_19544_() == MobEffects.f_19614_) {
            return false;
        }
        return super.m_147207_(effect, entity);
    }

    public boolean m_6469_(DamageSource source, float damage) {
        return super.m_6469_(source, damage);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22265_();
    }
}

