/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.type;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.data.tags.BiomeTagGenerator;
import twilightforest.init.TFEntities;
import twilightforest.init.TFStructureTypes;
import twilightforest.world.components.structures.finalcastle.FinalCastleMainComponent;
import twilightforest.world.components.structures.util.AdvancementLockedStructure;
import twilightforest.world.components.structures.util.ConquerableStructure;
import twilightforest.world.components.structures.util.ControlledSpawns;
import twilightforest.world.components.structures.util.DecorationClearance;
import twilightforest.world.components.structures.util.StructureHints;

public class FinalCastleStructure
extends ConquerableStructure {
    public static final Codec<FinalCastleStructure> CODEC = RecordCodecBuilder.create(instance -> FinalCastleStructure.conquerStatusCodec(instance).apply((Applicative)instance, FinalCastleStructure::new));

    public FinalCastleStructure(ControlledSpawns.ControlledSpawningConfig controlledSpawningConfig, AdvancementLockedStructure.AdvancementLockConfig advancementLockConfig, StructureHints.HintConfig hintConfig, DecorationClearance.DecorationConfig decorationConfig, Structure.StructureSettings structureSettings) {
        super(controlledSpawningConfig, advancementLockConfig, hintConfig, decorationConfig, structureSettings);
    }

    @Override
    @Nullable
    protected StructurePiece getFirstPiece(Structure.GenerationContext context, RandomSource random, ChunkPos chunkPos, int x, int y, int z) {
        return new FinalCastleMainComponent(0, x, y, z);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)TFStructureTypes.FINAL_CASTLE.get();
    }

    public static FinalCastleStructure buildFinalCastleConfig(BootstapContext<Structure> context) {
        return new FinalCastleStructure(ControlledSpawns.ControlledSpawningConfig.create(List.of(List.of(), List.of(), List.of(), List.of()), List.of(), List.of()), new AdvancementLockedStructure.AdvancementLockConfig(List.of(TwilightForestMod.prefix("progress_troll"))), new StructureHints.HintConfig(StructureHints.HintConfig.defaultBook(), (EntityType<? extends Mob>)((EntityType)TFEntities.KOBOLD.get())), new DecorationClearance.DecorationConfig(4, false, true, false), new Structure.StructureSettings((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(BiomeTagGenerator.VALID_FINAL_CASTLE_BIOMES), Arrays.stream(MobCategory.values()).collect(Collectors.toMap(category -> category, category -> new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.m_146332_()))), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN));
    }
}

