/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import twilightforest.init.TFEntities;
import twilightforest.init.TFItems;
import twilightforest.init.custom.MagicPaintingVariants;
import twilightforest.util.MagicPaintingVariant;

public class MagicPainting
extends HangingEntity {
    private static final EntityDataAccessor<String> DATA_PAINTING_VARIANT_ID = SynchedEntityData.m_135353_(MagicPainting.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final String EMPTY = "null";

    public MagicPainting(EntityType<? extends MagicPainting> entityType, Level level) {
        super(entityType, level);
    }

    private MagicPainting(Level level, BlockPos pos) {
        super((EntityType)TFEntities.MAGIC_PAINTING.get(), level, pos);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_PAINTING_VARIANT_ID, (Object)EMPTY);
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (DATA_PAINTING_VARIANT_ID.equals(pKey)) {
            this.m_7087_();
        }
    }

    public void setVariant(String variant) {
        this.f_19804_.m_135381_(DATA_PAINTING_VARIANT_ID, (Object)variant);
    }

    public Optional<MagicPaintingVariant> getVariant() {
        String id = (String)this.f_19804_.m_135370_(DATA_PAINTING_VARIANT_ID);
        if (id.equals(EMPTY)) {
            return Optional.empty();
        }
        return MagicPaintingVariants.getVariant(this.m_9236_().m_9598_(), id);
    }

    public static Optional<MagicPainting> create(Level level, BlockPos pos, Direction direction) {
        MagicPainting magicPainting = new MagicPainting(level, pos);
        ArrayList<MagicPaintingVariant> list = new ArrayList<MagicPaintingVariant>();
        RegistryAccess regAccess = level.m_9598_();
        regAccess.m_175515_(MagicPaintingVariants.REGISTRY_KEY).forEach(list::add);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        magicPainting.m_6022_(direction);
        list.removeIf(variant -> {
            magicPainting.setVariant(MagicPaintingVariants.getVariantId(regAccess, variant));
            return !magicPainting.m_7088_();
        });
        if (list.isEmpty()) {
            return Optional.empty();
        }
        int biggestPossibleArea = list.stream().mapToInt(MagicPainting::variantArea).max().orElse(0);
        list.removeIf(variantArea -> MagicPainting.variantArea(variantArea) < biggestPossibleArea);
        Optional optional = Util.m_214676_(list, (RandomSource)magicPainting.f_19796_);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        magicPainting.setVariant(MagicPaintingVariants.getVariantId(regAccess, (MagicPaintingVariant)optional.get()));
        magicPainting.m_6022_(direction);
        return Optional.of(magicPainting);
    }

    private static int variantArea(MagicPaintingVariant variant) {
        return variant.width() * variant.height();
    }

    public void m_7380_(CompoundTag tag) {
        tag.m_128359_("variant", (String)this.f_19804_.m_135370_(DATA_PAINTING_VARIANT_ID));
        tag.m_128344_("facing", (byte)this.f_31699_.m_122416_());
        super.m_7380_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        this.setVariant(tag.m_128441_("variant") ? tag.m_128461_("variant") : EMPTY);
        this.f_31699_ = Direction.m_122407_((int)tag.m_128445_("facing"));
        super.m_7378_(tag);
        this.m_6022_(this.f_31699_);
    }

    public int m_7076_() {
        return this.getVariant().map(MagicPaintingVariant::width).orElse(16);
    }

    public int m_7068_() {
        return this.getVariant().map(MagicPaintingVariant::height).orElse(16);
    }

    public void m_5553_(@Nullable Entity entity) {
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_5496_(SoundEvents.f_12175_, 1.0f, 1.0f);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (player.m_150110_().f_35937_) {
                    return;
                }
            }
            this.m_19983_((ItemStack)Util.m_137469_((Object)new ItemStack((ItemLike)TFItems.MAGIC_PAINTING.get()), stack -> {
                CompoundTag tag = stack.m_41698_("EntityTag");
                tag.m_128359_("variant", (String)this.f_19804_.m_135370_(DATA_PAINTING_VARIANT_ID));
            }));
        }
    }

    public void m_7084_() {
        this.m_5496_(SoundEvents.f_12176_, 1.0f, 1.0f);
    }

    public void m_7678_(double x, double y, double z, float yaw, float pitch) {
        this.m_6034_(x, y, z);
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.m_6034_(x, y, z);
    }

    public Vec3 m_213870_() {
        return Vec3.m_82528_((Vec3i)this.f_31698_);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, this.f_31699_.m_122411_(), this.m_31748_());
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        this.m_6022_(Direction.m_122376_((int)packet.m_131509_()));
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)TFItems.MAGIC_PAINTING.get());
    }
}

