/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.custom.stalactites.entry;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import it.unimi.dsi.fastutil.Pair;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.registries.ForgeRegistries;
import twilightforest.data.custom.stalactites.entry.StalactiteReloadListener;

public record Stalactite(Map<Block, Integer> ores, float sizeVariation, int maxLength, int weight) {
    private static StalactiteReloadListener STALACTITE_CONFIG;

    public static void reloadStalactites(AddReloadListenerEvent event) {
        STALACTITE_CONFIG = new StalactiteReloadListener();
        event.addListener((PreparableReloadListener)STALACTITE_CONFIG);
    }

    public static StalactiteReloadListener getStalactiteConfig() {
        if (STALACTITE_CONFIG == null) {
            throw new IllegalStateException("Can not retrieve Stalactites yet!");
        }
        return STALACTITE_CONFIG;
    }

    public static enum HollowHillType {
        SMALL,
        MEDIUM,
        LARGE;

    }

    public static class Serializer
    implements JsonDeserializer<Stalactite>,
    JsonSerializer<Stalactite> {
        public Stalactite deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)json, (String)"stalactite");
            float size = GsonHelper.m_13915_((JsonObject)jsonobject, (String)"size_variation");
            int maxLength = GsonHelper.m_13927_((JsonObject)jsonobject, (String)"max_length");
            int weight = GsonHelper.m_13927_((JsonObject)jsonobject, (String)"weight");
            return new Stalactite(this.deserializeBlockMap(jsonobject), size, maxLength, weight);
        }

        private Map<Block, Integer> deserializeBlockMap(JsonObject json) {
            JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)"blocks");
            HashMap<Block, Integer> map = new HashMap<Block, Integer>();
            array.forEach(jsonElement -> map.put((Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)jsonElement.getAsJsonObject(), (String)"block"))), GsonHelper.m_13927_((JsonObject)jsonElement.getAsJsonObject(), (String)"weight")));
            return map;
        }

        public JsonElement serialize(Stalactite stalactite, Type type, JsonSerializationContext context) {
            JsonObject jsonobject = new JsonObject();
            JsonArray array = new JsonArray();
            List<Pair> blockWeights = stalactite.ores().entrySet().stream().map(e -> Pair.of((Object)ForgeRegistries.BLOCKS.getKey((Object)((Block)e.getKey())), (Object)((Integer)e.getValue()))).sorted(Comparator.comparing(Pair::left)).toList();
            for (Pair entry : blockWeights) {
                JsonObject entryObject = new JsonObject();
                entryObject.add("block", context.serialize((Object)((ResourceLocation)entry.left()).m_135815_()));
                entryObject.add("weight", context.serialize(entry.right()));
                array.add((JsonElement)entryObject);
            }
            jsonobject.add("blocks", (JsonElement)array);
            jsonobject.add("size_variation", context.serialize((Object)Float.valueOf(stalactite.sizeVariation())));
            jsonobject.add("max_length", context.serialize((Object)stalactite.maxLength()));
            jsonobject.add("weight", context.serialize((Object)stalactite.weight()));
            return jsonobject;
        }
    }
}

