/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.capabilities.shield;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;
import twilightforest.capabilities.shield.IShieldCapability;
import twilightforest.init.TFSounds;
import twilightforest.init.TFStats;
import twilightforest.network.TFPacketHandler;
import twilightforest.network.UpdateShieldPacket;

public class ShieldCapabilityHandler
implements IShieldCapability {
    private int temporaryShields;
    private int permanentShields;
    private LivingEntity host;
    private int timer;
    private int breakTimer;

    @Override
    public void setEntity(LivingEntity entity) {
        this.host = entity;
    }

    @Override
    public void update() {
        block6: {
            Player player;
            LivingEntity livingEntity;
            block5: {
                LivingEntity livingEntity2 = this.host;
                if (!(livingEntity2 instanceof Player)) break block5;
                Player player2 = (Player)livingEntity2;
                if (player2.m_150110_().f_35934_) break block6;
            }
            if (!(this.host.m_9236_().m_5776_() || this.temporaryShieldsLeft() <= 0 || this.timer-- > 0 || this.breakTimer > 0 || (livingEntity = this.host) instanceof Player && (player = (Player)livingEntity).m_7500_())) {
                this.breakShield();
            }
            if (this.breakTimer > 0) {
                --this.breakTimer;
            }
        }
    }

    @Override
    public int shieldsLeft() {
        return this.temporaryShields + this.permanentShields;
    }

    @Override
    public int temporaryShieldsLeft() {
        return this.temporaryShields;
    }

    @Override
    public int permanentShieldsLeft() {
        return this.permanentShields;
    }

    @Override
    public void breakShield() {
        if (this.breakTimer <= 0) {
            if (this.temporaryShields > 0) {
                --this.temporaryShields;
                this.resetTimer();
            } else if (this.permanentShields > 0) {
                --this.permanentShields;
            }
            LivingEntity livingEntity = this.host;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                player.m_36220_((ResourceLocation)TFStats.TF_SHIELDS_BROKEN.get());
            }
            this.sendUpdatePacket();
            this.host.m_9236_().m_5594_(null, this.host.m_20183_(), (SoundEvent)TFSounds.SHIELD_BREAK.get(), SoundSource.PLAYERS, 1.0f, ((this.host.m_217043_().m_188501_() - this.host.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
            this.breakTimer = 20;
        }
    }

    @Override
    public void replenishShields() {
        this.setShields(5, true);
        this.host.m_9236_().m_5594_(null, this.host.m_20183_(), (SoundEvent)TFSounds.SHIELD_ADD.get(), SoundSource.PLAYERS, 1.0f, (this.host.m_217043_().m_188501_() - this.host.m_217043_().m_188501_()) * 0.2f + 1.0f);
    }

    @Override
    public void setShields(int amount, boolean temp) {
        if (temp) {
            this.temporaryShields = Math.max(amount, 0);
            this.resetTimer();
        } else {
            this.permanentShields = Math.max(amount, 0);
        }
        this.sendUpdatePacket();
    }

    @Override
    public void addShields(int amount, boolean temp) {
        if (temp) {
            if (this.temporaryShields <= 0) {
                this.resetTimer();
            }
            this.temporaryShields = Math.max(this.temporaryShields + amount, 0);
        } else {
            this.permanentShields = Math.max(this.permanentShields + amount, 0);
        }
        this.sendUpdatePacket();
    }

    void initShields(int temporary, int permanent) {
        this.temporaryShields = Math.max(temporary, 0);
        this.permanentShields = Math.max(permanent, 0);
        this.resetTimer();
    }

    private void resetTimer() {
        this.timer = 240;
    }

    private void sendUpdatePacket() {
        if (this.host instanceof ServerPlayer) {
            TFPacketHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this.host), (Object)new UpdateShieldPacket((Entity)this.host, (IShieldCapability)this));
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("tempshields", this.temporaryShieldsLeft());
        tag.m_128405_("permshields", this.permanentShieldsLeft());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.initShields(tag.m_128451_("tempshields"), tag.m_128451_("permshields"));
    }
}

