/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.packet;

import com.lothrazar.library.core.IHasFluid;
import com.lothrazar.library.packet.PacketFlib;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketSyncFluid
extends PacketFlib {
    private BlockPos pos;
    private FluidStack fluid;

    public PacketSyncFluid(BlockPos p, FluidStack fluid) {
        this.pos = p;
        this.fluid = fluid;
    }

    public static void handle(PacketSyncFluid message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> PacketSyncFluid.doWork(message));
        message.done(ctx);
    }

    private static void doWork(PacketSyncFluid message) {
        BlockEntity te = Minecraft.m_91087_().f_91073_.m_7702_(message.pos);
        if (te instanceof IHasFluid) {
            IHasFluid tile = (IHasFluid)te;
            tile.setFluid(message.fluid);
        }
    }

    public static PacketSyncFluid decode(FriendlyByteBuf buf) {
        PacketSyncFluid msg = new PacketSyncFluid(buf.m_130135_(), FluidStack.loadFluidStackFromNBT((CompoundTag)buf.m_130260_()));
        return msg;
    }

    public static void encode(PacketSyncFluid msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        CompoundTag tags = new CompoundTag();
        if (msg.fluid != null) {
            msg.fluid.writeToNBT(tags);
        }
        buf.m_130079_(tags);
    }
}

