/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.overclocked_watches.core.network.packet;

import forge.com.cursee.overclocked_watches.core.ConfiguredValues;
import forge.com.cursee.overclocked_watches.core.registry.ModItemsForge;
import forge.com.cursee.overclocked_watches.platform.Services;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ForgeDayNightC2SPacket {
    public static final String CHARGES = "charges";

    public ForgeDayNightC2SPacket() {
    }

    public ForgeDayNightC2SPacket(FriendlyByteBuf buf) {
    }

    public void toBytes(FriendlyByteBuf buf) {
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            boolean WATCHES_ON_COOLDOWN;
            if (!ConfiguredValues.DAY_NIGHT_CYCLING_ALLOWED.get()) {
                return;
            }
            ServerPlayer player = context.getSender();
            boolean hasNetheriteWatch = Services.PLATFORM.playerHasNetheriteWatchEquipped((Player)player);
            boolean hasDiamondWatch = Services.PLATFORM.playerHasDiamondWatchEquipped((Player)player);
            boolean hasGoldenWatch = Services.PLATFORM.playerHasGoldenWatchEquipped((Player)player);
            if (!(hasNetheriteWatch || hasDiamondWatch || hasGoldenWatch)) {
                return;
            }
            boolean bl = WATCHES_ON_COOLDOWN = player.m_36335_().m_41519_((Item)ModItemsForge.NETHERITE_WATCH.get()) || player.m_36335_().m_41519_((Item)ModItemsForge.DIAMOND_WATCH.get()) || player.m_36335_().m_41519_((Item)ModItemsForge.GOLDEN_WATCH.get());
            if (WATCHES_ON_COOLDOWN) {
                return;
            }
            if (hasNetheriteWatch) {
                player.m_284548_().m_8615_((player.m_284548_().m_46468_() + ConfiguredValues.NETHERITE_TIME_ADVANCEMENT_TICKS.get()) % 24000L);
                ItemStack equippedWatch = Services.PLATFORM.getEquippedNetheriteWatch((Player)player);
                ForgeDayNightC2SPacket.applyCooldowns((Player)player, 1200 * (int)ConfiguredValues.NETHERITE_WATCH_COOLDOWN_MINUTES.get());
                CompoundTag validatedStackData = equippedWatch.m_41784_();
                int newChargeCount = validatedStackData.m_128451_(CHARGES) - 1;
                validatedStackData.m_128473_(CHARGES);
                validatedStackData.m_128405_(CHARGES, newChargeCount);
                equippedWatch.m_41739_(validatedStackData);
            } else if (hasDiamondWatch) {
                player.m_284548_().m_8615_((player.m_284548_().m_46468_() + ConfiguredValues.DIAMOND_TIME_ADVANCEMENT_TICKS.get()) % 24000L);
                ItemStack equippedWatch = Services.PLATFORM.getEquippedDiamondWatch((Player)player);
                ForgeDayNightC2SPacket.applyCooldowns((Player)player, 1200 * (int)ConfiguredValues.DIAMOND_WATCH_COOLDOWN_MINUTES.get());
                CompoundTag validatedStackData = equippedWatch.m_41784_();
                int newChargeCount = validatedStackData.m_128451_(CHARGES) - 1;
                validatedStackData.m_128473_(CHARGES);
                validatedStackData.m_128405_(CHARGES, newChargeCount);
                equippedWatch.m_41739_(validatedStackData);
            } else if (hasGoldenWatch) {
                player.m_284548_().m_8615_((player.m_284548_().m_46468_() + ConfiguredValues.GOLDEN_TIME_ADVANCEMENT_TICKS.get()) % 24000L);
                ItemStack equippedWatch = Services.PLATFORM.getEquippedGoldenWatch((Player)player);
                ForgeDayNightC2SPacket.applyCooldowns((Player)player, 1200 * (int)ConfiguredValues.GOLDEN_WATCH_COOLDOWN_MINUTES.get());
                CompoundTag validatedStackData = equippedWatch.m_41784_();
                int newChargeCount = validatedStackData.m_128451_(CHARGES) - 1;
                validatedStackData.m_128473_(CHARGES);
                validatedStackData.m_128405_(CHARGES, newChargeCount);
                equippedWatch.m_41739_(validatedStackData);
            }
            player.m_213846_((Component)Component.m_237115_((String)"magic.overclocked_watches.charge_consumed"));
        });
        return true;
    }

    public static void applyCooldowns(Player player, int lengthInTicks) {
        player.m_36335_().m_41524_((Item)ModItemsForge.NETHERITE_WATCH.get(), lengthInTicks);
        player.m_36335_().m_41524_((Item)ModItemsForge.DIAMOND_WATCH.get(), lengthInTicks);
        player.m_36335_().m_41524_((Item)ModItemsForge.GOLDEN_WATCH.get(), lengthInTicks);
    }
}

