/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.overclocked_watches;

import forge.com.cursee.overclocked_watches.OverclockedWatchesClient;
import forge.com.cursee.overclocked_watches.client.ArmRenderHandler;
import forge.com.cursee.overclocked_watches.client.KeyInputHandlerForge;
import forge.com.cursee.overclocked_watches.client.item.RendererLayers;
import forge.com.cursee.overclocked_watches.client.item.RendererUtil;
import forge.com.cursee.overclocked_watches.client.item.model.ArmsModel;
import forge.com.cursee.overclocked_watches.client.item.renderer.WatchRenderer;
import forge.com.cursee.overclocked_watches.core.particle.custom.WatchGrowthParticle;
import forge.com.cursee.overclocked_watches.core.registry.ModItemsForge;
import forge.com.cursee.overclocked_watches.core.registry.ModParticlesForge;
import forge.com.cursee.overclocked_watches.mixin.LivingEntityRendererAccessor;
import forge.com.cursee.overclocked_watches.platform.Services;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import top.theillusivec4.curios.client.render.CuriosLayer;

public class OverclockedWatchesClientForge {
    public OverclockedWatchesClientForge(IEventBus modEventBus) {
        modEventBus.addListener(this::onRegisterEntityLayerDefinitions);
        modEventBus.addListener(this::onClientSetup);
        modEventBus.addListener(this::onAddEntityRendererLayers);
        modEventBus.addListener(this::onRegisterParticleProviders);
        modEventBus.addListener(this::onRegisterKeyMappings);
        ArmRenderHandler.setup();
    }

    public void onRegisterEntityLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(RendererLayers.GOLDEN_WATCH_WIDE, RendererLayers.layer(() -> RendererUtil.createWatchModel(false), 32, 32));
        event.registerLayerDefinition(RendererLayers.GOLDEN_WATCH_SLIM, RendererLayers.layer(() -> RendererUtil.createWatchModel(true), 32, 32));
        event.registerLayerDefinition(RendererLayers.DIAMOND_WATCH_WIDE, RendererLayers.layer(() -> RendererUtil.createWatchModel(false), 32, 32));
        event.registerLayerDefinition(RendererLayers.DIAMOND_WATCH_SLIM, RendererLayers.layer(() -> RendererUtil.createWatchModel(true), 32, 32));
        event.registerLayerDefinition(RendererLayers.NETHERITE_WATCH_WIDE, RendererLayers.layer(() -> RendererUtil.createWatchModel(false), 32, 32));
        event.registerLayerDefinition(RendererLayers.NETHERITE_WATCH_SLIM, RendererLayers.layer(() -> RendererUtil.createWatchModel(true), 32, 32));
    }

    public void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            Services.PLATFORM.registerWatchRenderer((Item)ModItemsForge.GOLDEN_WATCH.get(), () -> new WatchRenderer("golden_watch", ArmsModel::bakeGoldenWatchTextureOnModel));
            Services.PLATFORM.registerWatchRenderer((Item)ModItemsForge.DIAMOND_WATCH.get(), () -> new WatchRenderer("diamond_watch", ArmsModel::bakeDiamondWatchTextureOnModel));
            Services.PLATFORM.registerWatchRenderer((Item)ModItemsForge.NETHERITE_WATCH.get(), () -> new WatchRenderer("netherite_watch", ArmsModel::bakeNetheriteWatchTextureOnModel));
        });
    }

    public void onAddEntityRendererLayers(EntityRenderersEvent.AddLayers event) {
        Set<EntityType> entities = Set.of(EntityType.f_20501_, EntityType.f_20458_, EntityType.f_20562_, EntityType.f_20524_, EntityType.f_20481_, EntityType.f_20497_, EntityType.f_20511_, EntityType.f_20512_, EntityType.f_20531_);
        block0: for (EntityType entity : entities) {
            EntityRenderer renderer = (EntityRenderer)Minecraft.m_91087_().m_91290_().f_114362_.get(entity);
            if (renderer == null) continue;
            LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)renderer;
            for (RenderLayer layer : ((LivingEntityRendererAccessor)livingEntityRenderer).getLayers()) {
                if (!(layer instanceof CuriosLayer)) continue;
                continue block0;
            }
            livingEntityRenderer.m_115326_((RenderLayer)new CuriosLayer((RenderLayerParent)livingEntityRenderer));
        }
    }

    public void onRegisterParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ModParticlesForge.GOLDEN_WATCH_GROWTH.get(), WatchGrowthParticle.HappyVillagerParticleCopiedProvider::new);
        event.registerSpriteSet((ParticleType)ModParticlesForge.DIAMOND_WATCH_GROWTH.get(), WatchGrowthParticle.HappyVillagerParticleCopiedProvider::new);
        event.registerSpriteSet((ParticleType)ModParticlesForge.NETHERITE_WATCH_GROWTH.get(), WatchGrowthParticle.HappyVillagerParticleCopiedProvider::new);
    }

    public void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(KeyInputHandlerForge.dayNightKey);
    }

    @Mod.EventBusSubscriber(modid="overclocked_watches", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModBusEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> OverclockedWatchesClient.init());
        }
    }
}

