/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.cursee.overclocked_watches.platform;

import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.client.TrinketRenderer;
import dev.emi.trinkets.api.client.TrinketRendererRegistry;
import fabric.com.cursee.overclocked_watches.OverclockedWatchesUtil;
import fabric.com.cursee.overclocked_watches.client.item.renderer.IWatchRenderer;
import fabric.com.cursee.overclocked_watches.core.registry.ModItemsFabric;
import fabric.com.cursee.overclocked_watches.core.registry.ModParticlesFabric;
import fabric.com.cursee.overclocked_watches.platform.services.IPlatformHelper;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2400;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_583;

public class FabricPlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Fabric";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public String getGameDirectory() {
        return FabricLoader.getInstance().getGameDir().toString();
    }

    @Override
    public <T extends class_1792> void registerWatchRenderer(T item, Supplier<IWatchRenderer> rendererSupplier) {
        TrinketRendererRegistry.registerRenderer(item, (TrinketRenderer)new WatchTrinketRenderer(rendererSupplier.get()));
    }

    public IWatchRenderer getWatchRenderer(class_1792 item) {
        Object t;
        Optional renderer = TrinketRendererRegistry.getRenderer((class_1792)item);
        if (renderer.isPresent() && (t = renderer.get()) instanceof WatchTrinketRenderer) {
            WatchTrinketRenderer artifactTrinketRenderer = (WatchTrinketRenderer)t;
            return artifactTrinketRenderer.renderer();
        }
        return null;
    }

    @Override
    public Supplier<class_1792> getRegisteredGoldenWatchItem() {
        return () -> ModItemsFabric.GOLDEN_WATCH;
    }

    @Override
    public Supplier<class_1792> getRegisteredDiamondWatchItem() {
        return () -> ModItemsFabric.DIAMOND_WATCH;
    }

    @Override
    public Supplier<class_1792> getRegisteredNetheriteWatchItem() {
        return () -> ModItemsFabric.NETHERITE_WATCH;
    }

    @Override
    public boolean playerHasGoldenWatchEquipped(class_1657 player) {
        AtomicBoolean foundWatch = new AtomicBoolean(false);
        TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(trinketComponent -> {
            if (trinketComponent.isEquipped(itemStack -> itemStack.method_7909() == ModItemsFabric.GOLDEN_WATCH)) {
                foundWatch.set(true);
            }
        });
        return foundWatch.get();
    }

    @Override
    public boolean playerHasDiamondWatchEquipped(class_1657 player) {
        AtomicBoolean foundWatch = new AtomicBoolean(false);
        TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(trinketComponent -> {
            if (trinketComponent.isEquipped(itemStack -> itemStack.method_7909() == ModItemsFabric.DIAMOND_WATCH)) {
                foundWatch.set(true);
            }
        });
        return foundWatch.get();
    }

    @Override
    public boolean playerHasNetheriteWatchEquipped(class_1657 player) {
        AtomicBoolean foundWatch = new AtomicBoolean(false);
        TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(trinketComponent -> {
            if (trinketComponent.isEquipped(itemStack -> itemStack.method_7909() == ModItemsFabric.NETHERITE_WATCH)) {
                foundWatch.set(true);
            }
        });
        return foundWatch.get();
    }

    @Override
    public class_1799 getEquippedGoldenWatch(class_1657 player) {
        AtomicReference<class_1799> itemStackReference = new AtomicReference<class_1799>(class_1799.field_8037);
        TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(trinketComponent -> trinketComponent.getEquipped(ModItemsFabric.GOLDEN_WATCH).forEach(slotReferenceItemStackTuple -> itemStackReference.set((class_1799)slotReferenceItemStackTuple.method_15441())));
        return itemStackReference.get();
    }

    @Override
    public class_1799 getEquippedDiamondWatch(class_1657 player) {
        AtomicReference<class_1799> itemStackReference = new AtomicReference<class_1799>(class_1799.field_8037);
        TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(trinketComponent -> trinketComponent.getEquipped(ModItemsFabric.DIAMOND_WATCH).forEach(slotReferenceItemStackTuple -> itemStackReference.set((class_1799)slotReferenceItemStackTuple.method_15441())));
        return itemStackReference.get();
    }

    @Override
    public class_1799 getEquippedNetheriteWatch(class_1657 player) {
        AtomicReference<class_1799> itemStackReference = new AtomicReference<class_1799>(class_1799.field_8037);
        TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(trinketComponent -> trinketComponent.getEquipped(ModItemsFabric.NETHERITE_WATCH).forEach(slotReferenceItemStackTuple -> itemStackReference.set((class_1799)slotReferenceItemStackTuple.method_15441())));
        return itemStackReference.get();
    }

    @Override
    public class_2400 getGoldenWatchGrowthParticle() {
        return ModParticlesFabric.GOLDEN_WATCH_GROWTH;
    }

    @Override
    public class_2400 getDiamondWatchGrowthParticle() {
        return ModParticlesFabric.DIAMOND_WATCH_GROWTH;
    }

    @Override
    public class_2400 getNetheriteWatchGrowthParticle() {
        return ModParticlesFabric.NETHERITE_WATCH_GROWTH;
    }

    @Override
    public boolean consumeWatchCharge(class_1657 player) {
        AtomicBoolean CHARGE_CONSUMED = new AtomicBoolean(false);
        TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(component -> {
            if (component.isEquipped(ModItemsFabric.NETHERITE_WATCH)) {
                component.getEquipped(ModItemsFabric.NETHERITE_WATCH).forEach(slotStackPair -> {
                    if (OverclockedWatchesUtil.handleNetheriteWatchTag((class_1799)slotStackPair.method_15441())) {
                        CHARGE_CONSUMED.set(true);
                    }
                });
            } else if (component.isEquipped(ModItemsFabric.DIAMOND_WATCH)) {
                component.getEquipped(ModItemsFabric.DIAMOND_WATCH).forEach(slotStackPair -> {
                    if (OverclockedWatchesUtil.handleDiamondWatchTag((class_1799)slotStackPair.method_15441())) {
                        CHARGE_CONSUMED.set(true);
                    }
                });
            } else if (component.isEquipped(ModItemsFabric.GOLDEN_WATCH)) {
                component.getEquipped(ModItemsFabric.GOLDEN_WATCH).forEach(slotStackPair -> {
                    if (OverclockedWatchesUtil.handleGoldenWatchTag((class_1799)slotStackPair.method_15441())) {
                        CHARGE_CONSUMED.set(true);
                    }
                });
            }
        });
        return CHARGE_CONSUMED.get();
    }

    private record WatchTrinketRenderer(IWatchRenderer renderer) implements TrinketRenderer
    {
        public void render(class_1799 stack, SlotReference slotReference, class_583<? extends class_1309> entityModel, class_4587 poseStack, class_4597 multiBufferSource, int light, class_1309 entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            int index = slotReference.index() + (slotReference.inventory().getSlotType().getGroup().equals("hand") ? 0 : 1);
            this.renderer.render(stack, entity, index, poseStack, multiBufferSource, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

