/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.overclocked_watches.core.item.custom;

import common.com.cursee.overclocked_watches.core.ConfiguredValues;
import common.com.cursee.overclocked_watches.platform.Services;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class WatchItem
extends Item {
    public static final String CHARGES = "charges";
    private static final int GOLDEN_CHARGES = (int)ConfiguredValues.GOLDEN_WATCH_CHARGES.get();
    private static final int DIAMOND_CHARGES = (int)ConfiguredValues.DIAMOND_WATCH_CHARGES.get();
    private static final int NETHERITE_CHARGES = (int)ConfiguredValues.NETHERITE_WATCH_CHARGES.get();
    private final Tier tier;

    public WatchItem(Tier tier) {
        super(new Item.Properties().durability(tier.getItemDurability()));
        this.tier = tier;
    }

    public ItemStack getDefaultInstance() {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        CompoundTag stackData = itemStack.getOrCreateTag();
        if (stackData.contains(CHARGES, 3)) {
            return itemStack;
        }
        switch (this.getTier()) {
            case GOLDEN: {
                stackData.putInt(CHARGES, GOLDEN_CHARGES);
            }
            case DIAMOND: {
                stackData.putInt(CHARGES, DIAMOND_CHARGES);
            }
            case NETHERITE: {
                stackData.putInt(CHARGES, NETHERITE_CHARGES);
            }
        }
        itemStack.save(stackData);
        return itemStack.copy();
    }

    public void appendHoverText(ItemStack itemStack, @Nullable Level level, List<Component> tooltip, TooltipFlag tooltipFlag) {
        CompoundTag stackData = itemStack.getOrCreateTag();
        if (!stackData.contains(CHARGES, 3)) {
            switch (((WatchItem)itemStack.getItem()).getTier()) {
                case GOLDEN: {
                    tooltip.add((Component)Component.translatable((String)"text.overclocked_watches.default_charges", (Object[])new Object[]{GOLDEN_CHARGES}));
                    break;
                }
                case DIAMOND: {
                    tooltip.add((Component)Component.translatable((String)"text.overclocked_watches.default_charges", (Object[])new Object[]{DIAMOND_CHARGES}));
                    break;
                }
                case NETHERITE: {
                    tooltip.add((Component)Component.translatable((String)"text.overclocked_watches.default_charges", (Object[])new Object[]{NETHERITE_CHARGES}));
                }
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"text.overclocked_watches.charges", (Object[])new Object[]{stackData.getInt(CHARGES)}));
        }
    }

    public void inventoryTick(ItemStack itemStack, Level level, Entity entity, int slotIndex, boolean slotSelected) {
        CompoundTag stackData = itemStack.getOrCreateTag();
        if (stackData.contains(CHARGES, 3)) {
            return;
        }
        switch (((WatchItem)itemStack.getItem()).getTier()) {
            case GOLDEN: {
                stackData.putInt(CHARGES, GOLDEN_CHARGES);
                break;
            }
            case DIAMOND: {
                stackData.putInt(CHARGES, DIAMOND_CHARGES);
                break;
            }
            case NETHERITE: {
                stackData.putInt(CHARGES, NETHERITE_CHARGES);
            }
        }
    }

    public static void applyCooldowns(Player player, int lengthInTicks) {
        player.getCooldowns().addCooldown(Services.PLATFORM.getRegisteredNetheriteWatchItem().get(), lengthInTicks);
        player.getCooldowns().addCooldown(Services.PLATFORM.getRegisteredDiamondWatchItem().get(), lengthInTicks);
        player.getCooldowns().addCooldown(Services.PLATFORM.getRegisteredGoldenWatchItem().get(), lengthInTicks);
    }

    public static ItemStack initializeTag(ItemStack itemStack) {
        CompoundTag stackData = itemStack.getOrCreateTag();
        if (stackData.contains(CHARGES, 3)) {
            return itemStack;
        }
        switch (((WatchItem)itemStack.getItem()).getTier()) {
            case GOLDEN: {
                stackData.putInt(CHARGES, GOLDEN_CHARGES);
                break;
            }
            case DIAMOND: {
                stackData.putInt(CHARGES, DIAMOND_CHARGES);
                break;
            }
            case NETHERITE: {
                stackData.putInt(CHARGES, NETHERITE_CHARGES);
            }
        }
        itemStack.save(stackData);
        return itemStack.copy();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ServerLevel serverLevel;
        ItemStack itemInHand;
        block17: {
            block16: {
                itemInHand = player.getItemInHand(hand);
                if (!(level instanceof ServerLevel)) break block16;
                serverLevel = (ServerLevel)level;
                if (player instanceof ServerPlayer) break block17;
            }
            return InteractionResultHolder.pass((Object)itemInHand);
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        CompoundTag unvalidatedStackData = itemInHand.getOrCreateTag();
        if (!unvalidatedStackData.contains(CHARGES, 3)) {
            itemInHand = WatchItem.initializeTag(itemInHand);
        } else if (unvalidatedStackData.getInt(CHARGES) == 0) {
            return InteractionResultHolder.pass((Object)itemInHand);
        }
        switch (this.getTier()) {
            case GOLDEN: {
                serverLevel.setDayTime((serverLevel.getDayTime() + ConfiguredValues.GOLDEN_TIME_ADVANCEMENT_TICKS.get()) % 24000L);
                break;
            }
            case DIAMOND: {
                serverLevel.setDayTime((serverLevel.getDayTime() + ConfiguredValues.DIAMOND_TIME_ADVANCEMENT_TICKS.get()) % 24000L);
                break;
            }
            case NETHERITE: {
                serverLevel.setDayTime((serverLevel.getDayTime() + ConfiguredValues.NETHERITE_TIME_ADVANCEMENT_TICKS.get()) % 24000L);
            }
        }
        CompoundTag validatedStackData = itemInHand.getOrCreateTag();
        int newChargeCount = validatedStackData.getInt(CHARGES) - 1;
        validatedStackData.remove(CHARGES);
        validatedStackData.putInt(CHARGES, newChargeCount);
        itemInHand.save(validatedStackData);
        switch (this.getTier()) {
            case GOLDEN: {
                WatchItem.applyCooldowns((Player)serverPlayer, 1200 * (int)ConfiguredValues.GOLDEN_WATCH_COOLDOWN_MINUTES.get());
                break;
            }
            case DIAMOND: {
                WatchItem.applyCooldowns((Player)serverPlayer, 1200 * (int)ConfiguredValues.DIAMOND_WATCH_COOLDOWN_MINUTES.get());
                break;
            }
            case NETHERITE: {
                WatchItem.applyCooldowns((Player)serverPlayer, 1200 * (int)ConfiguredValues.NETHERITE_WATCH_COOLDOWN_MINUTES.get());
            }
        }
        return InteractionResultHolder.success((Object)itemInHand);
    }

    public Tier getTier() {
        return this.tier;
    }

    public static enum Tier {
        GOLDEN(ConfiguredValues.GOLDEN_WATCH_DURABILITY.get()),
        DIAMOND(ConfiguredValues.DIAMOND_WATCH_DURABILITY.get()),
        NETHERITE(ConfiguredValues.NETHERITE_WATCH_DURABILITY.get());

        private final long itemDurability;

        private Tier(long itemDurability) {
            this.itemDurability = itemDurability;
        }

        public int getItemDurability() {
            return (int)this.itemDurability;
        }
    }
}

