/*
 * Decompiled with CFR 0.152.
 */
package fuzs.horseexpert.world.inventory.tooltip;

import fuzs.horseexpert.HorseExpert;
import fuzs.horseexpert.config.ClientConfig;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.function.DoubleUnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public record HorseAttributeTooltip(@Nullable Item item, @Nullable MobEffect icon, Component line1, @Nullable Component line2) implements TooltipComponent
{
    private static final DecimalFormat ATTRIBUTE_VALUE_FORMAT = (DecimalFormat)Util.m_137469_((Object)new DecimalFormat("#.##"), p_41704_ -> p_41704_.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));

    private HorseAttributeTooltip(MobEffect icon, double value, double min, double max, String translationKey) {
        this(null, icon, value, min, max, translationKey, DoubleUnaryOperator.identity());
    }

    private HorseAttributeTooltip(MobEffect icon, double value, double min, double max, String translationKey, DoubleUnaryOperator valueConverter) {
        this(null, icon, value, min, max, translationKey, valueConverter);
    }

    private HorseAttributeTooltip(Item item, double value, double min, double max, String translationKey, DoubleUnaryOperator valueConverter) {
        this(item, null, value, min, max, translationKey, valueConverter);
    }

    private HorseAttributeTooltip(@Nullable Item item, @Nullable MobEffect icon, double value, double min, double max, String translationKey, DoubleUnaryOperator valueConverter) {
        this(item, icon, HorseAttributeTooltip.line1(value, HorseAttributeTooltip.categorizeValue(value, min, max), translationKey, valueConverter), HorseAttributeTooltip.line2(min, max, valueConverter));
    }

    private HorseAttributeTooltip(MobEffect icon, double value, String translationKey) {
        this(null, icon, value, translationKey, DoubleUnaryOperator.identity());
    }

    private HorseAttributeTooltip(MobEffect icon, double value, String translationKey, DoubleUnaryOperator valueConverter) {
        this(null, icon, value, translationKey, valueConverter);
    }

    private HorseAttributeTooltip(Item item, double value, String translationKey, DoubleUnaryOperator valueConverter) {
        this(item, null, value, translationKey, valueConverter);
    }

    private HorseAttributeTooltip(@Nullable Item item, @Nullable MobEffect icon, double value, String translationKey, DoubleUnaryOperator valueConverter) {
        this(item, icon, HorseAttributeTooltip.line1(value, null, translationKey, valueConverter), null);
    }

    private static Component line1(double value, @Nullable ChatFormatting color, String translationKey, DoubleUnaryOperator valueConverter) {
        MutableComponent component1 = Component.m_237113_((String)ATTRIBUTE_VALUE_FORMAT.format(valueConverter.applyAsDouble(value)));
        if (color != null) {
            component1 = component1.m_130940_(color);
        }
        MutableComponent component2 = Component.m_237110_((String)translationKey.concat(".unit"), (Object[])new Object[]{component1}).m_130940_(ChatFormatting.GRAY);
        return Component.m_237110_((String)translationKey, (Object[])new Object[]{component2}).m_130940_(ChatFormatting.WHITE);
    }

    private static Component line2(double min, double max, DoubleUnaryOperator valueConverter) {
        MutableComponent minComponent = Component.m_237110_((String)"horse.tooltip.min", (Object[])new Object[]{Component.m_237113_((String)ATTRIBUTE_VALUE_FORMAT.format(valueConverter.applyAsDouble(min))).m_130940_(ChatFormatting.GRAY)}).m_130940_(((ClientConfig)HorseExpert.CONFIG.get(ClientConfig.class)).lowValueColor);
        MutableComponent maxComponent = Component.m_237110_((String)"horse.tooltip.max", (Object[])new Object[]{Component.m_237113_((String)ATTRIBUTE_VALUE_FORMAT.format(valueConverter.applyAsDouble(max))).m_130940_(ChatFormatting.GRAY)}).m_130940_(((ClientConfig)HorseExpert.CONFIG.get(ClientConfig.class)).highValueColor);
        MutableComponent separatorComponent = Component.m_237113_((String)"   ").m_130940_(ChatFormatting.GRAY);
        return minComponent.m_7220_((Component)separatorComponent).m_7220_((Component)maxComponent);
    }

    private static ChatFormatting categorizeValue(double value, double min, double max) {
        if (value < min + (max - min) * ((ClientConfig)HorseExpert.CONFIG.get(ClientConfig.class)).lowValuePercentage) {
            return ((ClientConfig)HorseExpert.CONFIG.get(ClientConfig.class)).lowValueColor;
        }
        if (value >= min + (max - min) * ((ClientConfig)HorseExpert.CONFIG.get(ClientConfig.class)).highValuePercentage) {
            return ((ClientConfig)HorseExpert.CONFIG.get(ClientConfig.class)).highValueColor;
        }
        return ((ClientConfig)HorseExpert.CONFIG.get(ClientConfig.class)).mediumValueColor;
    }

    public static HorseAttributeTooltip healthTooltip(double value, boolean minMax) {
        if (minMax) {
            return new HorseAttributeTooltip(MobEffects.f_19616_, value / 2.0, 7.5, 15.0, "horse.tooltip.health");
        }
        return new HorseAttributeTooltip(MobEffects.f_19616_, value / 2.0, "horse.tooltip.health");
    }

    public static HorseAttributeTooltip speedTooltip(double value, boolean minMax) {
        if (minMax) {
            return new HorseAttributeTooltip(MobEffects.f_19596_, value, 0.1125, 0.3375, "horse.tooltip.speed", d -> d * 43.17);
        }
        return new HorseAttributeTooltip(MobEffects.f_19596_, value, "horse.tooltip.speed", d -> d * 43.17);
    }

    public static HorseAttributeTooltip jumpHeightTooltip(double value, boolean minMax) {
        if (minMax) {
            return new HorseAttributeTooltip(MobEffects.f_19603_, value, 0.4, 1.0, "horse.tooltip.jump_height", d -> Math.pow(d, 1.7) * 5.293);
        }
        return new HorseAttributeTooltip(MobEffects.f_19603_, value, "horse.tooltip.jump_height", d -> Math.pow(d, 1.7) * 5.293);
    }

    public static HorseAttributeTooltip strengthTooltip(double value) {
        return new HorseAttributeTooltip(Items.f_42009_, value, 1.0, 5.0, "horse.tooltip.strength", d -> d * 3.0);
    }
}

