/*
 * Decompiled with CFR 0.152.
 */
package fuzs.horseexpert.client.handler;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.horseexpert.HorseExpert;
import fuzs.horseexpert.config.ClientConfig;
import fuzs.horseexpert.core.CommonAbstractions;
import fuzs.horseexpert.init.ModRegistry;
import fuzs.horseexpert.world.inventory.tooltip.HorseAttributeTooltip;
import fuzs.puzzleslib.api.client.screen.v2.TooltipRenderHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.level.GameType;

public class AttributeOverlayHandler {
    public static void renderAttributeOverlay(Minecraft minecraft, GuiGraphics guiGraphics, float tickDelta, int screenWidth, int screenHeight) {
        AttributeOverlayHandler.isRenderingTooltipsAllowed(minecraft).ifPresent(abstractHorse -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.disableDepthTest();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            AttributeOverlayHandler.actuallyRenderAttributeOverlay(guiGraphics, screenWidth, screenHeight, abstractHorse, minecraft.f_91062_, minecraft.m_91291_());
        });
    }

    private static Optional<LivingEntity> isRenderingTooltipsAllowed(Minecraft minecraft) {
        block4: {
            LivingEntity entity;
            block5: {
                Player player;
                Entity entity2;
                Entity entity3;
                if (minecraft.f_91066_.f_92062_) {
                    return Optional.empty();
                }
                if (!minecraft.f_91066_.m_92176_().m_90612_() || !((entity3 = minecraft.f_91076_) instanceof LivingEntity)) break block4;
                entity = (LivingEntity)entity3;
                if (!minecraft.f_91076_.m_6095_().m_204039_(ModRegistry.INSPECTABLE_ENTITY_TYPE_TAG) || minecraft.f_91072_.m_105295_() == GameType.SPECTATOR || !((entity2 = minecraft.f_91075_) instanceof Player) || !CommonAbstractions.INSTANCE.findEquippedItem((LivingEntity)(player = (Player)entity2), ModRegistry.INSPECTION_EQUIPMENT_ITEM_TAG).isPresent() || ((ClientConfig)HorseExpert.CONFIG.get(ClientConfig.class)).requiresSneaking && !player.m_6144_() || player.m_20202_() == entity) break block4;
                if (!(entity instanceof AbstractHorse)) break block5;
                AbstractHorse abstractHorse = (AbstractHorse)entity;
                if (((ClientConfig)HorseExpert.CONFIG.get(ClientConfig.class)).mustBeTamed && !abstractHorse.m_30614_()) break block4;
            }
            return Optional.of(entity);
        }
        return Optional.empty();
    }

    private static void actuallyRenderAttributeOverlay(GuiGraphics guiGraphics, int screenWidth, int screenHeight, LivingEntity entity, Font font, ItemRenderer itemRenderer) {
        List<HorseAttributeTooltip> tooltipComponents = AttributeOverlayHandler.buildTooltipComponents(entity);
        int posX = screenWidth / 2 - 12 + 22 + ((ClientConfig)HorseExpert.CONFIG.get(ClientConfig.class)).offsetX;
        int posY = screenHeight / 2 + 15 - (tooltipComponents.size() * 29 - 3) / 2 + ((ClientConfig)HorseExpert.CONFIG.get(ClientConfig.class)).offsetY;
        for (int i = 0; i < tooltipComponents.size(); ++i) {
            TooltipRenderHelper.renderTooltip((GuiGraphics)guiGraphics, (int)posX, (int)(posY + 29 * i), (Component)Component.m_237119_(), (TooltipComponent)tooltipComponents.get(i));
        }
    }

    private static List<HorseAttributeTooltip> buildTooltipComponents(LivingEntity entity) {
        ArrayList tooltipComponents = Lists.newArrayList();
        if (entity.m_21204_().m_22171_(Attributes.f_22276_)) {
            tooltipComponents.add(HorseAttributeTooltip.healthTooltip(entity.m_21133_(Attributes.f_22276_), entity instanceof AbstractHorse));
        }
        if (!(entity instanceof Llama) || ((ClientConfig)HorseExpert.CONFIG.get(ClientConfig.class)).allLlamaAttributes) {
            if (entity.m_21204_().m_22171_(Attributes.f_22279_)) {
                tooltipComponents.add(HorseAttributeTooltip.speedTooltip(entity.m_21133_(Attributes.f_22279_), entity instanceof AbstractHorse));
            }
            if (entity.m_21204_().m_22171_(Attributes.f_22288_)) {
                tooltipComponents.add(HorseAttributeTooltip.jumpHeightTooltip(entity.m_21133_(Attributes.f_22288_), entity instanceof AbstractHorse));
            }
        }
        if (entity instanceof Llama) {
            Llama llama = (Llama)entity;
            tooltipComponents.add(HorseAttributeTooltip.strengthTooltip(llama.m_30823_()));
        }
        return tooltipComponents;
    }
}

