/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.utils;

import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.valhelsia.valhelsia_core.api.common.registry.helper.TemplatePoolRegistryHelper;
import net.valhelsia.valhelsia_core.api.common.world.structure.jigsaw.JigsawBuilder;
import org.jetbrains.annotations.Nullable;

public interface StartPoolKeySet {
    public static final String FURNISHED_PREFIX = "furnished";

    public static Simple simple(TemplatePoolRegistryHelper helper, String key) {
        return new Simple((ResourceKey<StructureTemplatePool>)helper.createKey(key));
    }

    public static WithFurnished withFurnishedVariant(TemplatePoolRegistryHelper helper, String key) {
        return new WithFurnished((ResourceKey<StructureTemplatePool>)helper.createKey(key), (ResourceKey<StructureTemplatePool>)helper.createKey("furnished/" + key));
    }

    public void forEachKey(BiConsumer<ResourceKey<StructureTemplatePool>, Boolean> var1);

    default public void create(TemplatePoolRegistryHelper helper, BootstapContext<StructureTemplatePool> context, String folder, UnaryOperator<JigsawBuilder> builder) {
        this.forEachKey((key, furnished) -> helper.create(key, context, (String)(furnished != false ? "furnished/" + folder : folder), builder));
    }

    default public void create(TemplatePoolRegistryHelper helper, BootstapContext<StructureTemplatePool> context, UnaryOperator<JigsawBuilder> builder) {
        this.forEachKey((key, furnished) -> helper.create(key, context, furnished != false ? FURNISHED_PREFIX : null, builder));
    }

    default public void create(TemplatePoolRegistryHelper helper, BootstapContext<StructureTemplatePool> context, String folder, UnaryOperator<JigsawBuilder> builder, @Nullable TerrainAdjustment terrainAdjustment) {
        this.forEachKey((key, furnished) -> helper.create(key, context, (String)(furnished != false ? "furnished/" + folder : folder), builder, terrainAdjustment));
    }

    default public void create(TemplatePoolRegistryHelper helper, BootstapContext<StructureTemplatePool> context, UnaryOperator<JigsawBuilder> builder, @Nullable TerrainAdjustment terrainAdjustment) {
        this.forEachKey((key, furnished) -> helper.create(key, context, furnished != false ? FURNISHED_PREFIX : null, builder, terrainAdjustment));
    }

    public record Simple(ResourceKey<StructureTemplatePool> key) implements StartPoolKeySet
    {
        @Override
        public void forEachKey(BiConsumer<ResourceKey<StructureTemplatePool>, Boolean> consumer) {
            consumer.accept(this.key(), false);
        }
    }

    public record WithFurnished(ResourceKey<StructureTemplatePool> defaultKey, ResourceKey<StructureTemplatePool> furnishedKey) implements StartPoolKeySet
    {
        @Override
        public void forEachKey(BiConsumer<ResourceKey<StructureTemplatePool>, Boolean> consumer) {
            consumer.accept(this.defaultKey(), false);
            consumer.accept(this.furnishedKey(), true);
        }
    }
}

