/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.core.init;

import com.stal111.valhelsia_structures.common.block.BigJarBlock;
import com.stal111.valhelsia_structures.common.block.BigJarTopBlock;
import com.stal111.valhelsia_structures.common.block.BonePileBlock;
import com.stal111.valhelsia_structures.common.block.BrazierBlock;
import com.stal111.valhelsia_structures.common.block.CutPostBlock;
import com.stal111.valhelsia_structures.common.block.DousedTorchBlock;
import com.stal111.valhelsia_structures.common.block.DousedWallTorchBlock;
import com.stal111.valhelsia_structures.common.block.DungeonDoorBlock;
import com.stal111.valhelsia_structures.common.block.DungeonDoorLeafBlock;
import com.stal111.valhelsia_structures.common.block.ExplorersTentBlock;
import com.stal111.valhelsia_structures.common.block.GiantFernBlock;
import com.stal111.valhelsia_structures.common.block.HangingVinesBlock;
import com.stal111.valhelsia_structures.common.block.HangingVinesBodyBlock;
import com.stal111.valhelsia_structures.common.block.JarBlock;
import com.stal111.valhelsia_structures.common.block.PostBlock;
import com.stal111.valhelsia_structures.common.block.SleepingBagBlock;
import com.stal111.valhelsia_structures.common.block.SpecialSpawnerBlock;
import com.stal111.valhelsia_structures.common.block.UnlitLanternBlock;
import com.stal111.valhelsia_structures.common.block.ValhelsiaGrassBlock;
import com.stal111.valhelsia_structures.common.block.ValhelsiaStoneBlock;
import com.stal111.valhelsia_structures.common.block.properties.BlockProperties;
import com.stal111.valhelsia_structures.common.item.BigJarBlockItem;
import com.stal111.valhelsia_structures.common.item.DyeableBlockItem;
import com.stal111.valhelsia_structures.core.ValhelsiaStructures;
import com.stal111.valhelsia_structures.core.init.other.ModWoodTypes;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.BedItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.common.Mod;
import net.valhelsia.valhelsia_core.api.client.ValhelsiaRenderType;
import net.valhelsia.valhelsia_core.api.common.block.StrippableRotatedPillarBlock;
import net.valhelsia.valhelsia_core.api.common.block.entity.ValhelsiaBlockProperties;
import net.valhelsia.valhelsia_core.api.common.registry.RegistryClass;
import net.valhelsia.valhelsia_core.api.common.registry.helper.block.BlockEntrySet;
import net.valhelsia.valhelsia_core.api.common.registry.helper.block.BlockRegistryEntry;
import net.valhelsia.valhelsia_core.api.common.registry.helper.block.BlockRegistryHelper;
import net.valhelsia.valhelsia_core.api.common.registry.helper.block.ToolType;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBlocks
implements RegistryClass {
    public static final BlockRegistryHelper HELPER = ValhelsiaStructures.REGISTRY_MANAGER.getBlockHelper();
    private static final BlockBehaviour.OffsetFunction BONE_PILE_OFFSET = (state, level, pos) -> new Vec3(0.0, -0.46875, 0.0);
    private static final MapColorProvider AXIS_COLOR_PROVIDER = (state, topColor, barkColor) -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? topColor : barkColor;
    private static final MapColorProvider FACING_COLOR_PROVIDER = (state, topColor, barkColor) -> ((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122434_() == Direction.Axis.Y ? topColor : barkColor;
    public static final BlockSetType LAPIDIFIED_JUNGLE = new BlockSetType("lapidified_jungle");
    public static final BlockRegistryEntry<SpecialSpawnerBlock> SPECIAL_SPAWNER = HELPER.register("special_spawner", () -> new SpecialSpawnerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50085_).m_60913_(-1.0f, 3600000.0f).m_222994_())).withItem().renderType(ValhelsiaRenderType.CUTOUT);
    public static final BlockRegistryEntry<BrazierBlock> BRAZIER = HELPER.register("brazier", () -> new BrazierBlock(true, 1, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50183_).m_60955_().m_60953_(state -> (Boolean)state.m_61143_((Property)BrazierBlock.LIT) != false ? 15 : 0))).withItem().toolType(ToolType.PICKAXE).renderType(ValhelsiaRenderType.CUTOUT);
    public static final BlockRegistryEntry<BrazierBlock> SOUL_BRAZIER = HELPER.register("soul_brazier", () -> new BrazierBlock(false, 2, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50183_).m_60955_().m_60953_(state -> (Boolean)state.m_61143_((Property)BrazierBlock.LIT) != false ? 11 : 0))).withItem().toolType(ToolType.PICKAXE).renderType(ValhelsiaRenderType.CUTOUT);
    public static final BlockEntrySet<PostBlock, WoodType> WOODEN_POSTS = HELPER.registerEntrySet(WoodType.class, "post", type -> new PostBlock(type.buildProperties(false, AXIS_COLOR_PROVIDER).m_60955_()), registryObject -> registryObject.withItem().toolType(ToolType.AXE));
    public static final BlockEntrySet<PostBlock, WoodType> STRIPPED_WOODEN_POSTS = HELPER.registerEntrySet(WoodType.class, s -> "stripped_" + s + "_post", type -> new PostBlock(type.buildProperties(true, AXIS_COLOR_PROVIDER).m_60955_()), registryObject -> registryObject.withItem().toolType(ToolType.AXE));
    public static final BlockEntrySet<CutPostBlock, WoodType> CUT_WOODEN_POSTS = HELPER.registerEntrySet(WoodType.class, s -> "cut_" + s + "_post", type -> new CutPostBlock(type.buildProperties(false, FACING_COLOR_PROVIDER).m_284180_(type.getBarkColor()).m_60955_()), registryObject -> registryObject.withItem().toolType(ToolType.AXE));
    public static final BlockEntrySet<CutPostBlock, WoodType> CUT_STRIPPED_WOODEN_POSTS = HELPER.registerEntrySet(WoodType.class, s -> "cut_stripped_" + s + "_post", type -> new CutPostBlock(type.buildProperties(true, FACING_COLOR_PROVIDER).m_284180_(type.getBarkColor()).m_60955_()), registryObject -> registryObject.withItem().toolType(ToolType.AXE));
    public static final BlockEntrySet<RotatedPillarBlock, WoodType> BUNDLED_STRIPPED_POSTS = HELPER.registerEntrySet(WoodType.class, s -> "bundled_stripped_" + s + "_posts", type -> new RotatedPillarBlock(type.buildProperties(true, AXIS_COLOR_PROVIDER)), registryObject -> registryObject.withItem().toolType(ToolType.AXE));
    public static final BlockEntrySet<RotatedPillarBlock, WoodType> BUNDLED_POSTS = HELPER.registerEntrySet(WoodType.class, s -> "bundled_" + s + "_posts", type -> new StrippableRotatedPillarBlock((Supplier)BUNDLED_STRIPPED_POSTS.get((Object)type), type.buildProperties(false, AXIS_COLOR_PROVIDER)), registryObject -> registryObject.withItem().toolType(ToolType.AXE));
    public static final BlockRegistryEntry<GlassBlock> METAL_FRAMED_GLASS = HELPER.register("metal_framed_glass", () -> new GlassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_))).withItem().renderType(ValhelsiaRenderType.CUTOUT);
    public static final BlockRegistryEntry<IronBarsBlock> METAL_FRAMED_GLASS_PANE = HELPER.register("metal_framed_glass_pane", () -> new IronBarsBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50185_))).withItem().renderType(ValhelsiaRenderType.CUTOUT);
    public static final BlockEntrySet<StainedGlassBlock, DyeColor> COLORED_METAL_FRAMED_GLASS = HELPER.registerColorEntrySet("metal_framed_glass", color -> new StainedGlassBlock(color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50214_)), entry -> entry.withItem().renderType(ValhelsiaRenderType.TRANSLUCENT));
    public static final BlockEntrySet<StainedGlassPaneBlock, DyeColor> COLORED_METAL_FRAMED_GLASS_PANES = HELPER.registerColorEntrySet("metal_framed_glass_pane", color -> new StainedGlassPaneBlock(color, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50370_)), entry -> entry.withItem().renderType(ValhelsiaRenderType.TRANSLUCENT));
    public static final BlockRegistryEntry<IronBarsBlock> PAPER_WALL = HELPER.register("paper_wall", () -> new IronBarsBlock(BlockBehaviour.Properties.m_284310_().m_60978_(0.3f).m_60918_(SoundType.f_56745_).m_60955_())).withItem();
    public static final BlockRegistryEntry<HangingVinesBodyBlock> HANGING_VINES_BODY = HELPER.register("hanging_vines_body", () -> new HangingVinesBodyBlock(BlockBehaviour.Properties.m_284310_().m_60910_().m_60978_(0.2f).m_60918_(SoundType.f_56760_))).renderType(ValhelsiaRenderType.CUTOUT);
    public static final BlockRegistryEntry<HangingVinesBlock> HANGING_VINES = HELPER.register("hanging_vines", () -> new HangingVinesBlock(BlockBehaviour.Properties.m_284310_().m_60977_().m_60910_().m_60978_(0.2f).m_60918_(SoundType.f_56760_))).withItem().renderType(ValhelsiaRenderType.CUTOUT);
    public static final BlockRegistryEntry<JarBlock> GLAZED_JAR = HELPER.register("glazed_jar", () -> new JarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_60999_().m_60978_(1.4f).m_60955_())).withItem();
    public static final BlockRegistryEntry<JarBlock> CRACKED_GLAZED_JAR = HELPER.register("cracked_glazed_jar", () -> new JarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_60999_().m_60978_(1.0f).m_60955_())).withItem();
    public static final BlockEntrySet<JarBlock, DyeColor> COLORED_GLAZED_JARS = HELPER.registerColorEntrySet("glazed_jar", color -> new JarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60978_(1.4f).m_60955_()), BlockRegistryEntry::withItem);
    public static final BlockRegistryEntry<BigJarBlock> BIG_GLAZED_JAR = HELPER.register("big_glazed_jar", () -> new BigJarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_60999_().m_60978_(1.4f).m_60955_())).withItem(registryObject -> new BigJarBlockItem((Block)registryObject.get(), new Item.Properties())).renderType(ValhelsiaRenderType.CUTOUT);
    public static final BlockRegistryEntry<BigJarTopBlock> BIG_GLAZED_JAR_TOP = HELPER.register("big_glazed_jar_top", () -> new BigJarTopBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_60999_().m_60978_(1.4f).m_60955_()));
    public static final BlockRegistryEntry<BigJarBlock> CRACKED_BIG_GLAZED_JAR = HELPER.register("cracked_big_glazed_jar", () -> new BigJarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_60999_().m_60978_(1.4f).m_60955_())).withItem(registryObject -> new BigJarBlockItem((Block)registryObject.get(), new Item.Properties())).renderType(ValhelsiaRenderType.CUTOUT);
    public static final BlockRegistryEntry<BigJarTopBlock> CRACKED_BIG_GLAZED_JAR_TOP = HELPER.register("cracked_big_glazed_jar_top", () -> new BigJarTopBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_60999_().m_60978_(1.4f).m_60955_()));
    public static final BlockEntrySet<BigJarBlock, DyeColor> BIG_COLORED_GLAZED_JARS = HELPER.registerColorEntrySet(color -> "big_" + color + "_glazed_jar", color -> new BigJarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60999_().m_60978_(1.4f).m_60955_()), entry -> entry.withItem(registryObject -> new BigJarBlockItem((Block)registryObject.get(), new Item.Properties())).renderType(ValhelsiaRenderType.CUTOUT));
    public static final BlockRegistryEntry<RotatedPillarBlock> LAPIDIFIED_JUNGLE_LOG = HELPER.register("lapidified_jungle_log", () -> new RotatedPillarBlock(BlockProperties.LAPIDIFIED_JUNGLE_LOG)).withItem();
    public static final BlockRegistryEntry<RotatedPillarBlock> LAPIDIFIED_JUNGLE_WOOD = HELPER.register("lapidified_jungle_wood", () -> new RotatedPillarBlock(BlockProperties.LAPIDIFIED_JUNGLE_LOG)).withItem();
    public static final BlockRegistryEntry<Block> LAPIDIFIED_JUNGLE_PLANKS = HELPER.register("lapidified_jungle_planks", () -> new Block(BlockProperties.LAPIDIFIED_JUNGLE_PLANKS)).withItem();
    public static final BlockRegistryEntry<StairBlock> LAPIDIFIED_JUNGLE_STAIRS = HELPER.register("lapidified_jungle_stairs", () -> new StairBlock(() -> ((Block)LAPIDIFIED_JUNGLE_PLANKS.get()).m_49966_(), BlockProperties.LAPIDIFIED_JUNGLE_PLANKS)).withItem();
    public static final BlockRegistryEntry<SlabBlock> LAPIDIFIED_JUNGLE_SLAB = HELPER.register("lapidified_jungle_slab", () -> new SlabBlock(BlockProperties.LAPIDIFIED_JUNGLE_PLANKS)).withItem();
    public static final BlockRegistryEntry<PressurePlateBlock> LAPIDIFIED_JUNGLE_PRESSURE_PLATE = HELPER.register("lapidified_jungle_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockProperties.LAPIDIFIED_JUNGLE_PLANKS.m_60978_(0.5f), LAPIDIFIED_JUNGLE)).withItem();
    public static final BlockRegistryEntry<ButtonBlock> LAPIDIFIED_JUNGLE_BUTTON = HELPER.register("lapidified_jungle_button", () -> new ButtonBlock(BlockProperties.LAPIDIFIED_JUNGLE_PLANKS.m_60978_(0.5f), LAPIDIFIED_JUNGLE, 30, true)).withItem();
    public static final BlockRegistryEntry<FenceBlock> LAPIDIFIED_JUNGLE_FENCE = HELPER.register("lapidified_jungle_fence", () -> new FenceBlock(BlockProperties.LAPIDIFIED_JUNGLE_PLANKS)).withItem();
    public static final BlockRegistryEntry<FenceGateBlock> LAPIDIFIED_JUNGLE_FENCE_GATE = HELPER.register("lapidified_jungle_fence_gate", () -> new FenceGateBlock(BlockProperties.LAPIDIFIED_JUNGLE_PLANKS.m_280606_(), ModWoodTypes.LAPIDIFIED_JUNGLE)).withItem();
    public static final BlockRegistryEntry<ExplorersTentBlock> EXPLORERS_TENT = HELPER.register("explorers_tent", () -> new ExplorersTentBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50106_).m_60955_())).withItem(registryObject -> new DyeableBlockItem((Block)registryObject.get(), new Item.Properties()));
    public static final BlockRegistryEntry<BushBlock> HIBISCUS = HELPER.register("hibiscus", () -> new BushBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50112_))).withItem().renderType(ValhelsiaRenderType.CUTOUT);
    public static final BlockRegistryEntry<GiantFernBlock> GIANT_FERN = HELPER.register("giant_fern", () -> new GiantFernBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50112_))).withItem();
    public static final BlockRegistryEntry<DousedTorchBlock> DOUSED_TORCH = HELPER.register("doused_torch", () -> new DousedTorchBlock((TorchBlock)Blocks.f_50081_, BlockBehaviour.Properties.m_284310_().m_60910_().m_60966_().m_60918_(SoundType.f_56736_))).renderType(ValhelsiaRenderType.CUTOUT);
    public static final BlockRegistryEntry<DousedWallTorchBlock> DOUSED_WALL_TORCH = HELPER.register("doused_wall_torch", () -> new DousedWallTorchBlock((TorchBlock)Blocks.f_50082_, BlockBehaviour.Properties.m_284310_().m_60910_().m_60966_().m_60918_(SoundType.f_56736_))).renderType(ValhelsiaRenderType.CUTOUT);
    public static final BlockRegistryEntry<DousedTorchBlock> DOUSED_SOUL_TORCH = HELPER.register("doused_soul_torch", () -> new DousedTorchBlock((TorchBlock)Blocks.f_50139_, BlockBehaviour.Properties.m_284310_().m_60910_().m_60966_().m_60918_(SoundType.f_56736_))).renderType(ValhelsiaRenderType.CUTOUT);
    public static final BlockRegistryEntry<DousedWallTorchBlock> DOUSED_SOUL_WALL_TORCH = HELPER.register("doused_soul_wall_torch", () -> new DousedWallTorchBlock((TorchBlock)Blocks.f_50140_, BlockBehaviour.Properties.m_284310_().m_60910_().m_60966_().m_60918_(SoundType.f_56736_))).renderType(ValhelsiaRenderType.CUTOUT);
    public static final BlockRegistryEntry<DungeonDoorBlock> DUNGEON_DOOR = HELPER.register("dungeon_door", () -> new DungeonDoorBlock(BlockBehaviour.Properties.m_284310_().m_60913_(50.0f, 100.0f).m_60999_().m_60955_())).withItem();
    public static final BlockRegistryEntry<DungeonDoorLeafBlock> DUNGEON_DOOR_LEAF = HELPER.register("dungeon_door_leaf", () -> new DungeonDoorLeafBlock(BlockBehaviour.Properties.m_284310_().m_60913_(50.0f, 100.0f).m_60999_().m_60955_().lootFrom(DUNGEON_DOOR)));
    public static final BlockRegistryEntry<BonePileBlock> BONE_PILE = HELPER.register("bone_pile", () -> new BonePileBlock(ValhelsiaBlockProperties.of().offsetType(BONE_PILE_OFFSET).m_284180_(MapColor.f_283761_).m_60999_().m_60978_(2.0f).m_60918_(SoundType.f_56724_).m_60955_().m_60988_())).withItem().renderType(ValhelsiaRenderType.CUTOUT);
    public static final BlockRegistryEntry<Block> BONE_PILE_BLOCK = HELPER.register("bone_pile_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50453_))).withItem();
    public static final BlockRegistryEntry<UnlitLanternBlock> UNLIT_LANTERN = HELPER.register("unlit_lantern", () -> new UnlitLanternBlock(() -> Blocks.f_50681_, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50681_).m_60953_(value -> 0))).withItem().toolType(ToolType.PICKAXE).renderType(ValhelsiaRenderType.CUTOUT);
    public static final BlockRegistryEntry<UnlitLanternBlock> UNLIT_SOUL_LANTERN = HELPER.register("unlit_soul_lantern", () -> new UnlitLanternBlock(() -> Blocks.f_50682_, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50682_).m_60953_(value -> 0))).withItem().toolType(ToolType.PICKAXE).renderType(ValhelsiaRenderType.CUTOUT);
    public static final BlockEntrySet<SleepingBagBlock, DyeColor> SLEEPING_BAGS = HELPER.registerColorEntrySet("sleeping_bag", color -> new SleepingBagBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color.m_284406_()).m_60978_(0.2f).m_60955_().m_60918_(SoundType.f_56745_)), blockRegistryObject -> blockRegistryObject.withItem(registryObject -> new BedItem((Block)registryObject.get(), new Item.Properties())));
    public static final BlockRegistryEntry<Block> STONE = HELPER.register("stone", () -> new ValhelsiaStoneBlock(() -> Blocks.f_50069_, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).lootFrom(() -> Blocks.f_50069_)));
    public static final BlockRegistryEntry<Block> GRANITE = HELPER.register("granite", () -> new ValhelsiaStoneBlock(() -> Blocks.f_50122_, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50122_).lootFrom(() -> Blocks.f_50122_)));
    public static final BlockRegistryEntry<Block> DIORITE = HELPER.register("diorite", () -> new ValhelsiaStoneBlock(() -> Blocks.f_50228_, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50228_).lootFrom(() -> Blocks.f_50228_)));
    public static final BlockRegistryEntry<Block> ANDESITE = HELPER.register("andesite", () -> new ValhelsiaStoneBlock(() -> Blocks.f_50334_, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50334_).lootFrom(() -> Blocks.f_50334_)));
    public static final BlockRegistryEntry<ValhelsiaGrassBlock> GRASS_BLOCK = HELPER.register("grass_block", () -> new ValhelsiaGrassBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50440_).lootFrom(() -> Blocks.f_50440_))).renderType(ValhelsiaRenderType.CUTOUT);
    public static final BlockRegistryEntry<Block> DIRT = HELPER.register("dirt", () -> new ValhelsiaStoneBlock(() -> Blocks.f_50493_, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50493_).lootFrom(() -> Blocks.f_50493_)));
    public static final BlockRegistryEntry<Block> COARSE_DIRT = HELPER.register("coarse_dirt", () -> new ValhelsiaStoneBlock(() -> Blocks.f_50546_, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50546_).lootFrom(() -> Blocks.f_50546_)));

    public static interface MapColorProvider {
        public MapColor getMapColor(BlockState var1, MapColor var2, MapColor var3);
    }

    public static enum WoodType implements StringRepresentable
    {
        OAK("oak", true, MapColor.f_283825_, MapColor.f_283819_),
        SPRUCE("spruce", true, MapColor.f_283819_, MapColor.f_283748_),
        BIRCH("birch", true, MapColor.f_283761_, MapColor.f_283942_),
        JUNGLE("jungle", true, MapColor.f_283762_, MapColor.f_283819_),
        ACACIA("acacia", true, MapColor.f_283750_, MapColor.f_283947_),
        DARK_OAK("dark_oak", true, MapColor.f_283748_, MapColor.f_283748_),
        MANGROVE("mangrove", true, MapColor.f_283913_, MapColor.f_283819_),
        CRIMSON("crimson", false, MapColor.f_283804_, MapColor.f_283804_),
        WARPED("warped", false, MapColor.f_283749_, MapColor.f_283749_),
        LAPIDIFIED_JUNGLE("lapidified_jungle", false, MapColor.f_283762_, MapColor.f_283762_);

        private final String name;
        private final boolean flammable;
        private final MapColor topColor;
        private final MapColor barkColor;

        private WoodType(String name, boolean flammable, MapColor topColor, MapColor barkColor) {
            this.name = name;
            this.flammable = flammable;
            this.topColor = topColor;
            this.barkColor = barkColor;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public BlockBehaviour.Properties buildProperties(boolean stripped, MapColorProvider colorProvider) {
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_284495_(state -> colorProvider.getMapColor((BlockState)state, this.topColor, stripped ? this.topColor : this.barkColor));
            if (this.isFlammable()) {
                properties = properties.m_278183_();
            }
            return properties;
        }

        public boolean isFlammable() {
            return this.flammable;
        }

        public MapColor getTopColor() {
            return this.topColor;
        }

        public MapColor getBarkColor() {
            return this.barkColor;
        }
    }
}

