/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.stal111.valhelsia_structures.core.init.ModRecipes;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class AxeCraftingRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final Ingredient input;
    private final Item result;
    private final int count;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();

    public AxeCraftingRecipeBuilder(RecipeCategory category, Ingredient input, ItemLike result, int count) {
        this.category = category;
        this.input = input;
        this.result = result.m_5456_();
        this.count = count;
    }

    public void m_176498_(@Nonnull Consumer<FinishedRecipe> consumer) {
        this.m_126140_(consumer, ForgeRegistries.ITEMS.getKey((Object)this.result));
    }

    public void m_176500_(@Nonnull Consumer<FinishedRecipe> consumer, @Nonnull String save) {
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((Object)this.result);
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Axe Crafting Recipe " + save + " should remove its 'save' argument");
        }
        this.m_126140_(consumer, new ResourceLocation(save));
    }

    @Nonnull
    public RecipeBuilder m_126132_(@Nonnull String criterionName, @Nonnull CriterionTriggerInstance criterionTrigger) {
        this.advancement.m_138386_(criterionName, criterionTrigger);
        return this;
    }

    @Nonnull
    public RecipeBuilder m_126145_(@Nullable String groupName) {
        return this;
    }

    @Nonnull
    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        this.ensureValid(id);
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(new Result(id, this.result, this.count, this.input, this.advancement, new ResourceLocation(id.m_135827_(), "recipes/" + this.category.m_247710_() + "/" + id.m_135815_())));
    }

    private void ensureValid(ResourceLocation pId) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + pId);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item output;
        private final int count;
        private final Ingredient input;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, Item output, int count, Ingredient input, Advancement.Builder advancementBuilder, ResourceLocation advancementId) {
            this.id = id;
            this.output = output;
            this.count = count;
            this.input = input;
            this.advancementBuilder = advancementBuilder;
            this.advancementId = advancementId;
        }

        public void m_7917_(@Nonnull JsonObject json) {
            json.add("input", this.input.m_43942_());
            JsonObject output = new JsonObject();
            output.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.output)).toString());
            if (this.count > 1) {
                output.addProperty("count", (Number)this.count);
            }
            json.add("output", (JsonElement)output);
        }

        @Nonnull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipes.AXE_CRAFTING_SERIALIZER.get();
        }

        @Nonnull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancementBuilder.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

