/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.client.renderer.entity.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.stal111.valhelsia_structures.client.model.block.ExplorersTentModel;
import com.stal111.valhelsia_structures.common.block.ExplorersTentBlock;
import com.stal111.valhelsia_structures.common.block.SleepingBagBlock;
import com.stal111.valhelsia_structures.common.block.entity.ExplorersTentBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;

public class ExplorersTentRenderer
implements BlockEntityRenderer<ExplorersTentBlockEntity> {
    private static final ResourceLocation TENT_TEXTURE = new ResourceLocation("valhelsia_structures", "textures/block/explorers_tent.png");
    private static final ResourceLocation TENT_STICKS_TEXTURE = new ResourceLocation("valhelsia_structures", "textures/block/explorers_tent_sticks.png");
    private final ExplorersTentModel model;

    public ExplorersTentRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new ExplorersTentModel(context.m_173582_(ExplorersTentModel.EXPLORERS_TENT));
    }

    public void render(@Nonnull ExplorersTentBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Direction direction = ((Direction)blockEntity.m_58900_().m_61143_((Property)ExplorersTentBlock.FACING)).m_122427_();
        float rotation = -direction.m_122435_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.8, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        int i = blockEntity.getColor();
        float red = (float)(i >> 16 & 0xFF) / 255.0f;
        float green = (float)(i >> 8 & 0xFF) / 255.0f;
        float blue = (float)(i & 0xFF) / 255.0f;
        this.model.m_7695_(poseStack, buffer.m_6299_(this.model.m_103119_(TENT_TEXTURE)), combinedLight, combinedOverlay, red, green, blue, 1.0f);
        poseStack.m_85837_(0.0, 0.3, 0.0);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        this.model.renderSticksToBuffer(poseStack, buffer.m_6299_(this.model.m_103119_(TENT_STICKS_TEXTURE)), combinedLight, combinedOverlay);
        poseStack.m_85849_();
        if (!blockEntity.getSleepingBag().m_41619_()) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.0, 0.5);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation + 180.0f));
            poseStack.m_85837_(-1.0, 0.0, -0.5);
            Direction bagDirection = switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.DOWN, Direction.UP, Direction.NORTH -> direction;
                case Direction.SOUTH -> direction.m_122424_();
                case Direction.WEST -> direction.m_122427_();
                case Direction.EAST -> direction.m_122428_();
            };
            BlockState block = (BlockState)Block.m_49814_((Item)blockEntity.getSleepingBag().m_41720_()).m_49966_().m_61124_((Property)SleepingBagBlock.f_54117_, (Comparable)bagDirection.m_122427_());
            Minecraft.m_91087_().m_91289_().m_110912_(block, poseStack, buffer, combinedLight, OverlayTexture.f_118083_);
            poseStack.m_85837_(1.0, 0.0, 0.0);
            Minecraft.m_91087_().m_91289_().m_110912_((BlockState)block.m_61124_(SleepingBagBlock.PART, (Comparable)BedPart.HEAD), poseStack, buffer, combinedLight, OverlayTexture.f_118083_);
            poseStack.m_85849_();
        }
    }

    public boolean shouldRenderOffScreen(@Nonnull ExplorersTentBlockEntity blockEntity) {
        return true;
    }
}

