/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.ender_pack.client.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import forge.com.cursee.ender_pack.EnderPackClient;
import forge.com.cursee.ender_pack.client.model.EnderPackModel;
import forge.com.cursee.ender_pack.core.ClientConfiguredValues;
import forge.com.cursee.ender_pack.core.registry.ModItems;
import forge.com.cursee.ender_pack.platform.Services;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class EnderPackLayer<T extends Player, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private final EnderPackModel model = new EnderPackModel(Minecraft.m_91087_().m_167973_().m_171103_(EnderPackClient.ENDER_PACK_PLAYER_MODEL_LAYER_LOCATION));

    public EnderPackLayer(RenderLayerParent<T, M> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int i, @NotNull Player entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        AtomicBoolean SHOULD_RENDER_BAG = new AtomicBoolean(false);
        entity.m_150109_().f_35975_.forEach(stack -> {
            if (stack.m_150930_(ModItems.ENDER_PACK)) {
                SHOULD_RENDER_BAG.set(ClientConfiguredValues.RENDERS_IN_ARMOR_SLOT);
            }
        });
        if ((Services.PLATFORM.isModLoaded("curios") || Services.PLATFORM.isModLoaded("trinkets")) && Services.PLATFORM.checkCompatibleSlots(entity)) {
            SHOULD_RENDER_BAG.set(ClientConfiguredValues.RENDERS_IN_EXTRA_SLOT);
        }
        if (!SHOULD_RENDER_BAG.get()) {
            return;
        }
        poseStack.m_85836_();
        boolean crouching = entity.m_6047_();
        if (crouching) {
            poseStack.m_252931_(new Matrix4f().setRotationXYZ(0.5235988f, 0.0f, 0.0f));
        } else {
            poseStack.m_252931_(new Matrix4f().setRotationXYZ(0.0f, 0.0f, 0.0f));
        }
        float xOffset = -0.0625f;
        float yOffset = crouching ? 0.25f : 0.0625f;
        float zOffset = crouching ? 0.83f : 0.9375f;
        poseStack.m_252880_(-0.0625f, yOffset, zOffset);
        RenderLayer.m_117376_((EntityModel)this.model, (ResourceLocation)EnderPackClient.ENDER_PACK_TEXTURE_LOCATION, (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (int)i, (LivingEntity)entity, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }
}

