/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.entity;

import com.mrcrayfish.goblintraders.Config;
import com.mrcrayfish.goblintraders.core.ModEntities;
import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import com.mrcrayfish.goblintraders.entity.TraderCreatureEntity;
import com.mrcrayfish.goblintraders.trades.EntityTrades;
import com.mrcrayfish.goblintraders.trades.IRaritySettings;
import com.mrcrayfish.goblintraders.trades.TradeManager;
import com.mrcrayfish.goblintraders.trades.TradeRarity;
import com.mrcrayfish.goblintraders.util.Utils;
import java.util.List;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class VeinGoblinTrader
extends AbstractGoblinEntity {
    private static final ResourceLocation TEXTURE = Utils.resource("textures/entity/vein_goblin_trader.png");

    public VeinGoblinTrader(Level level) {
        super((EntityType<? extends TraderCreatureEntity>)((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get()), level);
    }

    @Override
    public ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    protected void populateTradeData() {
        MerchantOffers offers = this.m_6616_();
        EntityTrades entityTrades = TradeManager.instance().getTrades((EntityType<? extends TraderCreatureEntity>)((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get()));
        if (entityTrades != null) {
            Map<TradeRarity, List<VillagerTrades.ItemListing>> tradeMap = entityTrades.getTradeMap();
            for (TradeRarity rarity : TradeRarity.values()) {
                IRaritySettings settings = Config.ENTITIES.veinGoblinTrader.trades.getSettings(rarity);
                if (settings.includeChance() <= 0.0 || settings.includeChance() < 1.0 && this.m_217043_().m_188500_() > settings.includeChance()) continue;
                List<VillagerTrades.ItemListing> trades = tradeMap.get((Object)rarity);
                int min = Math.min(settings.getMinValue(), settings.getMaxValue());
                int max = Math.max(settings.getMinValue(), settings.getMaxValue());
                int count = min + this.m_217043_().m_188503_(max - min + 1);
                this.addTrades(offers, trades, count, rarity.shouldShuffle());
            }
        }
    }

    @Override
    public ItemStack getFavouriteFood() {
        return new ItemStack((ItemLike)Items.f_42619_);
    }

    public void m_8107_() {
        if (this.m_183595_() && this.f_19797_ % 2 == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() - 0.5 + this.m_217043_().m_188500_(), this.m_20186_() + 0.5 - 0.5 + this.m_217043_().m_188500_(), this.m_20189_() - 0.5 + this.m_217043_().m_188500_(), 0.0, 0.0, 0.0);
        }
        super.m_8107_();
    }

    public boolean m_5825_() {
        return true;
    }

    @Override
    protected int getMaxRestockDelay() {
        return (Integer)Config.ENTITIES.veinGoblinTrader.restockDelay.get();
    }

    @Override
    public boolean canAttackBack() {
        return (Boolean)Config.ENTITIES.veinGoblinTrader.canAttackBack.get();
    }

    public int m_8100_() {
        return (Integer)Config.ENTITIES.veinGoblinTrader.gruntNoiseInterval.get();
    }
}

