/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure.function;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import xiroc.dungeoncrawl.dungeon.treasure.Loot;
import xiroc.dungeoncrawl.theme.SecondaryTheme;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.Range;

public class MaterialBlocks
extends LootItemConditionalFunction {
    private static final Range AMOUNT = new Range(16, 64);

    public MaterialBlocks(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    public ItemStack m_7372_(ItemStack stack, LootContext context) {
        if (context.m_78936_(LootContextParams.f_81460_)) {
            Vec3 origin = (Vec3)context.m_165124_(LootContextParams.f_81460_);
            BlockPos chestPosition = new BlockPos((int)(origin.f_82479_ - 0.5), (int)(origin.f_82480_ - 0.5), (int)(origin.f_82481_ - 0.5));
            BlockEntity chest = context.m_78952_().m_7702_(chestPosition);
            if (chest != null && chest.getPersistentData().m_128425_("dungeoncrawl", 10)) {
                Tuple<Theme, SecondaryTheme> themes = Loot.getLootInformation(chest.getPersistentData());
                return new ItemStack((ItemLike)MaterialBlocks.getMaterial((Theme)themes.m_14418_(), (SecondaryTheme)themes.m_14419_(), (LevelAccessor)context.m_78952_(), chestPosition, context.m_230907_()), AMOUNT.nextInt(context.m_230907_()));
            }
        }
        return new ItemStack((ItemLike)Blocks.f_50222_, AMOUNT.nextInt(context.m_230907_()));
    }

    private static Block getMaterial(Theme theme, SecondaryTheme secondaryTheme, LevelAccessor world, BlockPos pos, RandomSource rand) {
        if (rand.m_188499_()) {
            return theme.material.get(world, pos, rand).m_60734_();
        }
        return secondaryTheme.material.get(world, pos, rand).m_60734_();
    }

    public static LootItemConditionalFunction.Builder<?> materialBlocks() {
        return MaterialBlocks.m_80683_(MaterialBlocks::new);
    }

    public LootItemFunctionType m_7162_() {
        return Loot.MATERIAL_BLOCKS;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<MaterialBlocks> {
        public MaterialBlocks deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootItemCondition[] conditionsIn) {
            return new MaterialBlocks(conditionsIn);
        }
    }
}

