/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.datafixers.util.Pair;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;

public class RecipeHelper {
    private static final int MAX_FOLLOW_UP_COMPACTING_RECIPES = 30;
    @Nullable
    private static RecipeCache clientCache = null;
    @Nullable
    private static RecipeCache serverCache = null;

    private RecipeHelper() {
    }

    public static void setLevel(Level l) {
        RecipeHelper.getCache().setLevel(l);
    }

    public static void clearListeners() {
        RecipeHelper.runOnCache(cache -> cache.recipeChangeListeners.list.clear());
    }

    private static void runOnCache(Consumer<RecipeCache> consumer) {
        consumer.accept(RecipeHelper.getCache());
    }

    private static RecipeCache getCache() {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            if (serverCache == null) {
                serverCache = new RecipeCache();
            }
            return serverCache;
        }
        if (clientCache == null) {
            clientCache = new RecipeCache();
        }
        return clientCache;
    }

    private static <T> T getFromCache(Function<RecipeCache, T> getter, T defaultValue) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            return serverCache == null ? defaultValue : getter.apply(serverCache);
        }
        return clientCache == null ? defaultValue : getter.apply(clientCache);
    }

    public static void addRecipeChangeListener(Runnable runnable) {
        RecipeHelper.runOnCache(cache -> cache.addRecipeChangeListener(runnable));
    }

    public static void onRecipesUpdated(RecipesUpdatedEvent event) {
        RecipeHelper.runOnCache(cache -> {
            cache.clearCache();
            cache.recipeChangeListeners.notifyAllListeners();
        });
    }

    public static void onDataPackSync(OnDatapackSyncEvent event) {
        RecipeHelper.runOnCache(cache -> {
            cache.clearCache();
            cache.recipeChangeListeners.notifyAllListeners();
        });
    }

    private static Optional<Level> getLevel() {
        return RecipeHelper.getFromCache(cache -> Optional.ofNullable(cache.level == null ? null : (Level)cache.level.get()), Optional.empty());
    }

    private static Set<CompactingShape> getCompactingShapes(ItemStack stack) {
        return RecipeHelper.getLevel().map(w -> {
            HashSet<CompactingShape> compactingShapes = new HashSet<CompactingShape>();
            RecipeHelper.getCompactingShape(stack, w, 2, 2, CompactingShape.TWO_BY_TWO_UNCRAFTABLE, CompactingShape.TWO_BY_TWO).ifPresent(compactingShapes::add);
            RecipeHelper.getCompactingShape(stack, w, 3, 3, CompactingShape.THREE_BY_THREE_UNCRAFTABLE, CompactingShape.THREE_BY_THREE).ifPresent(compactingShapes::add);
            if (compactingShapes.isEmpty()) {
                compactingShapes.add(CompactingShape.NONE);
            }
            return compactingShapes;
        }).orElse(Collections.emptySet());
    }

    private static Optional<CompactingShape> getCompactingShape(ItemStack stack, Level w, int width, int height, CompactingShape uncraftableShape, CompactingShape shape) {
        CompactingResult compactingResult = RecipeHelper.getCompactingResult(stack, w, width, height);
        if (!compactingResult.getResult().m_41619_()) {
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)compactingResult.getResult())) {
                return Optional.empty();
            }
            if (RecipeHelper.isPartOfCompactingLoop(stack, compactingResult.getResult(), w)) {
                return Optional.empty();
            }
            if (RecipeHelper.uncompactMatchesItem(compactingResult.getResult(), w, stack, width * height)) {
                return Optional.of(uncraftableShape);
            }
            return Optional.of(shape);
        }
        return Optional.empty();
    }

    private static boolean isPartOfCompactingLoop(ItemStack firstCompacted, ItemStack firstCompactResult, Level w) {
        int iterations = 0;
        HashSet<Integer> compactedItemHashes = new HashSet<Integer>();
        LinkedList<ItemStack> itemsToCompact = new LinkedList<ItemStack>();
        itemsToCompact.add(firstCompactResult);
        while (!itemsToCompact.isEmpty()) {
            ItemStack itemToCompact = (ItemStack)itemsToCompact.poll();
            ItemStack compactingResultStack = RecipeHelper.getCompactingResult(itemToCompact, w, 2, 2).getResult();
            if (!compactingResultStack.m_41619_()) {
                if (ItemHandlerHelper.canItemStacksStack((ItemStack)compactingResultStack, (ItemStack)firstCompacted)) {
                    return true;
                }
                if (compactedItemHashes.contains(ItemStackKey.getHashCode(compactingResultStack))) {
                    return false;
                }
                itemsToCompact.add(compactingResultStack);
            }
            if (!(compactingResultStack = RecipeHelper.getCompactingResult(itemToCompact, w, 3, 3).getResult()).m_41619_()) {
                if (ItemHandlerHelper.canItemStacksStack((ItemStack)compactingResultStack, (ItemStack)firstCompacted)) {
                    return true;
                }
                if (compactedItemHashes.contains(ItemStackKey.getHashCode(compactingResultStack))) {
                    return false;
                }
                itemsToCompact.add(compactingResultStack);
            }
            compactedItemHashes.add(ItemStackKey.getHashCode(itemToCompact));
            if (++iterations <= 30) continue;
            return true;
        }
        return false;
    }

    private static boolean uncompactMatchesItem(ItemStack itemToUncompact, Level w, ItemStack itemToMatch, int count) {
        for (ItemStack uncompactResult : RecipeHelper.getUncompactResultItems(w, itemToUncompact)) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)uncompactResult, (ItemStack)itemToMatch) || uncompactResult.m_41613_() != count) continue;
            return true;
        }
        return false;
    }

    public static UncompactingResult getUncompactingResult(ItemStack uncompactedItem) {
        return RecipeHelper.getFromCache(cache -> cache.getUncompactingResults().computeIfAbsent(ItemStackKey.getHashCode(uncompactedItem), k -> RecipeHelper.getLevel().map(w -> {
            for (ItemStack uncompactResultItem : RecipeHelper.getUncompactResultItems(w, uncompactedItem)) {
                if (uncompactResultItem.m_41613_() == 9) {
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)RecipeHelper.getCompactingResult(uncompactResultItem, 3, 3).getResult(), (ItemStack)uncompactedItem)) continue;
                    return new UncompactingResult(uncompactResultItem, CompactingShape.THREE_BY_THREE_UNCRAFTABLE);
                }
                if (uncompactResultItem.m_41613_() != 4 || !ItemHandlerHelper.canItemStacksStack((ItemStack)RecipeHelper.getCompactingResult(uncompactResultItem, 2, 2).getResult(), (ItemStack)uncompactedItem)) continue;
                return new UncompactingResult(uncompactResultItem, CompactingShape.TWO_BY_TWO_UNCRAFTABLE);
            }
            return UncompactingResult.EMPTY;
        }).orElse(UncompactingResult.EMPTY)), UncompactingResult.EMPTY);
    }

    private static List<ItemStack> getUncompactResultItems(Level w, ItemStack itemToUncompact) {
        CraftingContainer craftingInventory = RecipeHelper.getFilledCraftingInventory(itemToUncompact, 1, 1);
        return RecipeHelper.safeGetRecipesFor(RecipeType.f_44107_, craftingInventory, w).stream().map(r -> r.m_5874_((Container)craftingInventory, w.m_9598_())).toList();
    }

    public static CompactingResult getCompactingResult(ItemStack stack, CompactingShape shape) {
        if (shape == CompactingShape.TWO_BY_TWO_UNCRAFTABLE || shape == CompactingShape.TWO_BY_TWO) {
            return RecipeHelper.getCompactingResult(stack, 2, 2);
        }
        if (shape == CompactingShape.THREE_BY_THREE_UNCRAFTABLE || shape == CompactingShape.THREE_BY_THREE) {
            return RecipeHelper.getCompactingResult(stack, 3, 3);
        }
        return CompactingResult.EMPTY;
    }

    public static CompactingResult getCompactingResult(ItemStack stack, int width, int height) {
        return RecipeHelper.getLevel().map(w -> RecipeHelper.getCompactingResult(stack, w, width, height)).orElse(CompactingResult.EMPTY);
    }

    private static CompactingResult getCompactingResult(ItemStack stack, Level level, int width, int height) {
        return RecipeHelper.getFromCache(cache -> RecipeHelper.getCompactingResult(stack, level, width, height, cache.getCompactingResults()), CompactingResult.EMPTY);
    }

    private static CompactingResult getCompactingResult(ItemStack stack, Level level, int width, int height, Map<CompactedItem, CompactingResult> cachedCompactingResults) {
        CompactedItem compactedItem = new CompactedItem(stack, width, height);
        if (cachedCompactingResults.containsKey(compactedItem)) {
            return cachedCompactingResults.get(compactedItem);
        }
        CraftingContainer craftingInventory = RecipeHelper.getFilledCraftingInventory(stack, width, height);
        List<CraftingRecipe> compactingRecipes = RecipeHelper.safeGetRecipesFor(RecipeType.f_44107_, craftingInventory, level);
        if (compactingRecipes.isEmpty()) {
            cachedCompactingResults.put(compactedItem, CompactingResult.EMPTY);
            return CompactingResult.EMPTY;
        }
        if (compactingRecipes.size() == 1) {
            return RecipeHelper.cacheAndGetCompactingResult(compactedItem, compactingRecipes.get(0), craftingInventory);
        }
        for (CraftingRecipe recipe : compactingRecipes) {
            ItemStack result = recipe.m_5874_((Container)craftingInventory, level.m_9598_());
            if (!RecipeHelper.uncompactMatchesItem(result, level, stack, width * height)) continue;
            return RecipeHelper.cacheAndGetCompactingResult(compactedItem, recipe, craftingInventory, result);
        }
        return RecipeHelper.cacheAndGetCompactingResult(compactedItem, compactingRecipes.get(0), craftingInventory);
    }

    private static CompactingResult cacheAndGetCompactingResult(CompactedItem compactedItem, CraftingRecipe recipe, CraftingContainer craftingInventory) {
        return RecipeHelper.getLevel().map(level -> RecipeHelper.cacheAndGetCompactingResult(compactedItem, recipe, craftingInventory, recipe.m_5874_((Container)craftingInventory, level.m_9598_()))).orElse(CompactingResult.EMPTY);
    }

    private static CompactingResult cacheAndGetCompactingResult(CompactedItem compactedItem, CraftingRecipe recipe, CraftingContainer craftingInventory, ItemStack result) {
        ArrayList<ItemStack> remainingItems = new ArrayList<ItemStack>();
        recipe.m_7457_((Container)craftingInventory).forEach(stack -> {
            if (!stack.m_41619_()) {
                remainingItems.add((ItemStack)stack);
            }
        });
        CompactingResult compactingResult = new CompactingResult(result, remainingItems);
        return RecipeHelper.getFromCache(cache -> {
            if (!result.m_41619_()) {
                cache.getCompactingResults().put(compactedItem, compactingResult);
            }
            return compactingResult;
        }, compactingResult);
    }

    private static CraftingContainer getFilledCraftingInventory(ItemStack stack, int width, int height) {
        TransientCraftingContainer craftinginventory = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

            public ItemStack m_7648_(Player pPlayer, int pIndex) {
                return ItemStack.f_41583_;
            }

            public boolean m_6875_(Player playerIn) {
                return false;
            }
        }, width, height);
        for (int i = 0; i < craftinginventory.m_6643_(); ++i) {
            craftinginventory.m_6836_(i, stack.m_255036_(1));
        }
        return craftinginventory;
    }

    public static <T extends AbstractCookingRecipe> Optional<T> getCookingRecipe(ItemStack stack, RecipeType<T> recipeType) {
        return RecipeHelper.getLevel().flatMap(w -> RecipeHelper.safeGetRecipeFor(recipeType, new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{stack}))), w, null));
    }

    public static Set<CompactingShape> getItemCompactingShapes(ItemStack stack) {
        return RecipeHelper.getFromCache(cache -> cache.getItemCompactingShapes(stack), Collections.emptySet());
    }

    public static <T extends Recipe<Container>> List<T> getRecipesOfType(RecipeType<T> recipeType, Container inventory) {
        return RecipeHelper.getLevel().map(w -> w.m_7465_().m_44056_(recipeType, inventory, w)).orElse(Collections.emptyList());
    }

    public static <C extends Container, T extends Recipe<C>> Optional<T> safeGetRecipeFor(RecipeType<T> recipeType, C inventory, @Nullable ResourceLocation recipeId) {
        return RecipeHelper.getLevel().flatMap(w -> RecipeHelper.safeGetRecipeFor(recipeType, inventory, w, recipeId));
    }

    public static <C extends Container, T extends Recipe<C>> Optional<T> safeGetRecipeFor(RecipeType<T> recipeType, C inventory, Level level, @Nullable ResourceLocation recipeId) {
        try {
            return level.m_7465_().m_220248_(recipeType, inventory, level, recipeId).map(Pair::getSecond);
        }
        catch (Exception e) {
            SophisticatedCore.LOGGER.error("Error while getting recipe ", (Throwable)e);
            return Optional.empty();
        }
    }

    public static <C extends Container, T extends Recipe<C>> List<T> safeGetRecipesFor(RecipeType<T> recipeType, C inventory, Level level) {
        try {
            return level.m_7465_().m_44056_(recipeType, inventory, level);
        }
        catch (Exception e) {
            SophisticatedCore.LOGGER.error("Error while getting recipe ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static class RecipeCache {
        private final Cache<Integer, Set<CompactingShape>> itemCompactingShapes = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
        private final Map<CompactedItem, CompactingResult> compactingResults = new HashMap<CompactedItem, CompactingResult>();
        private final Map<Integer, UncompactingResult> uncompactingResults = new HashMap<Integer, UncompactingResult>();
        private final RecipeChangeListenerList recipeChangeListeners = new RecipeChangeListenerList();
        private WeakReference<Level> level;

        private RecipeCache() {
        }

        public void addRecipeChangeListener(Runnable runnable) {
            this.recipeChangeListeners.add(runnable);
        }

        public Map<Integer, UncompactingResult> getUncompactingResults() {
            return this.uncompactingResults;
        }

        public Map<CompactedItem, CompactingResult> getCompactingResults() {
            return this.compactingResults;
        }

        public Set<CompactingShape> getItemCompactingShapes(ItemStack stack) {
            int hash = ItemStackKey.getHashCode(stack);
            Set<CompactingShape> compactingShapes = (Set<CompactingShape>)this.itemCompactingShapes.getIfPresent((Object)hash);
            if (compactingShapes == null) {
                SophisticatedCore.LOGGER.debug("Compacting shapes not found in cache for \"{}\" - querying recipes to get these", (Object)ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()));
                compactingShapes = RecipeHelper.getCompactingShapes(stack);
                this.itemCompactingShapes.put((Object)hash, compactingShapes);
            }
            return compactingShapes;
        }

        private void clearCache() {
            this.compactingResults.clear();
            this.uncompactingResults.clear();
            this.itemCompactingShapes.invalidateAll();
        }

        public void setLevel(Level l) {
            this.level = new WeakReference<Level>(l);
        }
    }

    public static class CompactingResult {
        public static final CompactingResult EMPTY = new CompactingResult(ItemStack.f_41583_, Collections.emptyList());
        private final ItemStack result;
        private final List<ItemStack> remainingItems;

        public CompactingResult(ItemStack result, List<ItemStack> remainingItems) {
            this.result = result;
            this.remainingItems = remainingItems;
        }

        public ItemStack getResult() {
            return this.result;
        }

        public List<ItemStack> getRemainingItems() {
            return this.remainingItems;
        }
    }

    public static class UncompactingResult {
        public static final UncompactingResult EMPTY = new UncompactingResult(ItemStack.f_41583_, CompactingShape.NONE);
        private final ItemStack result;
        private final CompactingShape compactUsingShape;

        public UncompactingResult(ItemStack result, CompactingShape compactUsingShape) {
            this.result = result.m_255036_(1);
            this.compactUsingShape = compactUsingShape;
        }

        public ItemStack getResult() {
            return this.result;
        }

        public CompactingShape getCompactUsingShape() {
            return this.compactUsingShape;
        }
    }

    public static enum CompactingShape {
        NONE(false, 0),
        THREE_BY_THREE(false, 9),
        TWO_BY_TWO(false, 4),
        THREE_BY_THREE_UNCRAFTABLE(true, 9),
        TWO_BY_TWO_UNCRAFTABLE(true, 4);

        private final int numberOfIngredients;
        private final boolean uncraftable;

        private CompactingShape(boolean uncraftable, int numberOfIngredients) {
            this.uncraftable = uncraftable;
            this.numberOfIngredients = numberOfIngredients;
        }

        public boolean isUncraftable() {
            return this.uncraftable;
        }

        public int getNumberOfIngredients() {
            return this.numberOfIngredients;
        }
    }

    private static class CompactedItem {
        private final ItemStack item;
        private final int itemHash;
        private final int width;
        private final int height;

        private CompactedItem(ItemStack item, int width, int height) {
            this.item = item.m_255036_(1);
            this.width = width;
            this.height = height;
            this.itemHash = ItemStackKey.getHashCode(item);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompactedItem that = (CompactedItem)o;
            return this.width == that.width && this.height == that.height && ItemHandlerHelper.canItemStacksStack((ItemStack)this.item, (ItemStack)that.item);
        }

        public int hashCode() {
            return Objects.hash(this.itemHash, this.width, this.height);
        }
    }

    private static class RecipeChangeListenerList {
        private final List<WeakReference<Runnable>> list = new CopyOnWriteArrayList<WeakReference<Runnable>>();

        private RecipeChangeListenerList() {
        }

        public void add(Runnable runnable) {
            this.list.add(new WeakReference<Runnable>(runnable));
        }

        public void notifyAllListeners() {
            this.list.removeIf(ref -> {
                Runnable runnable = (Runnable)ref.get();
                if (runnable != null) {
                    runnable.run();
                    return false;
                }
                return true;
            });
        }
    }
}

