/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.IInsertBlockOverride;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandlerSlotTracker;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryPartitioner;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IInsertResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IOverflowResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stack.StackUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.MathHelper;
import net.p3pp3rf1y.sophisticatedcore.util.SlotValueMap;
import org.apache.commons.lang3.function.TriFunction;

public abstract class InventoryHandler
extends ItemStackHandler
implements ITrackedContentsItemHandler,
IInsertBlockOverride {
    public static final String INVENTORY_TAG = "inventory";
    private static final String PARTITIONER_TAG = "partitioner";
    private static final String REAL_COUNT_TAG = "realCount";
    protected final IStorageWrapper storageWrapper;
    private final CompoundTag contentsNbt;
    private final Runnable saveHandler;
    private final List<IntConsumer> onContentsChangedListeners = new ArrayList<IntConsumer>();
    private boolean persistent = true;
    private final Map<Integer, CompoundTag> stackNbts = new LinkedHashMap<Integer, CompoundTag>();
    private ISlotTracker slotTracker = new ISlotTracker.Noop();
    private int baseSlotLimit;
    private double maxStackSizeMultiplier;
    private boolean isInitializing;
    private final StackUpgradeConfig stackUpgradeConfig;
    private final InventoryPartitioner inventoryPartitioner;
    private Consumer<Set<Item>> filterItemsChangeListener = s -> {};
    private final SlotValueMap<Item> filterItemSlots = new SlotValueMap();
    private BooleanSupplier shouldInsertIntoEmpty = () -> true;
    private boolean voidUpgradeInfoInitialized = false;
    private boolean hasVoidUpgrade = false;

    protected InventoryHandler(int numberOfInventorySlots, IStorageWrapper storageWrapper, CompoundTag contentsNbt, Runnable saveHandler, int baseSlotLimit, StackUpgradeConfig stackUpgradeConfig) {
        super(numberOfInventorySlots);
        this.stackUpgradeConfig = stackUpgradeConfig;
        this.isInitializing = true;
        this.storageWrapper = storageWrapper;
        this.contentsNbt = contentsNbt;
        this.saveHandler = saveHandler;
        this.setBaseSlotLimit(baseSlotLimit);
        this.deserializeNBT(contentsNbt.m_128469_(INVENTORY_TAG));
        this.inventoryPartitioner = new InventoryPartitioner(contentsNbt.m_128469_(PARTITIONER_TAG), this, () -> storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class));
        this.initStackNbts();
        this.getSlotTracker().refreshSlotIndexesFrom(this);
        this.isInitializing = false;
    }

    public ISlotTracker getSlotTracker() {
        this.initSlotTracker();
        return this.slotTracker;
    }

    public void setSize(int size) {
        super.setSize(this.stacks.size());
    }

    private void initStackNbts() {
        this.stackNbts.clear();
        for (int slot = 0; slot < this.stacks.size(); ++slot) {
            ItemStack slotStack = (ItemStack)this.stacks.get(slot);
            if (slotStack.m_41619_()) continue;
            this.stackNbts.put(slot, this.getSlotsStackNbt(slot, slotStack));
        }
    }

    public void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.inventoryPartitioner.getPartBySlot(slot).onContentsChanged(slot, (x$0, x$1) -> super.setStackInSlot(x$0, x$1));
        if (this.persistent && this.updateSlotNbt(slot)) {
            this.saveInventory();
            this.triggerOnChangeListeners(slot);
        }
    }

    public void triggerOnChangeListeners(int slot) {
        for (IntConsumer onContentsChangedListener : this.onContentsChangedListeners) {
            onContentsChangedListener.accept(slot);
        }
    }

    private boolean updateSlotNbt(int slot) {
        ItemStack slotStack = this.getSlotStack(slot);
        if (slotStack.m_41619_()) {
            if (this.stackNbts.containsKey(slot)) {
                this.stackNbts.remove(slot);
                return true;
            }
        } else {
            CompoundTag itemTag = this.getSlotsStackNbt(slot, slotStack);
            if (!this.stackNbts.containsKey(slot) || !this.stackNbts.get(slot).equals((Object)itemTag)) {
                this.stackNbts.put(slot, itemTag);
                return true;
            }
        }
        return false;
    }

    private CompoundTag getSlotsStackNbt(int slot, ItemStack slotStack) {
        CompoundTag itemTag = new CompoundTag();
        itemTag.m_128405_("Slot", slot);
        itemTag.m_128405_(REAL_COUNT_TAG, slotStack.m_41613_());
        slotStack.m_41739_(itemTag);
        return itemTag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.slotTracker.clear();
        this.setSize(nbt.m_128425_("Size", 3) ? nbt.m_128451_("Size") : this.stacks.size());
        ListTag tagList = nbt.m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            ItemStack slotStack = ItemStack.m_41712_((CompoundTag)itemTags);
            if (itemTags.m_128441_(REAL_COUNT_TAG)) {
                slotStack.m_41764_(itemTags.m_128451_(REAL_COUNT_TAG));
            }
            this.stacks.set(slot, (Object)slotStack);
        }
        this.slotTracker.refreshSlotIndexesFrom(this);
        this.onLoad();
    }

    public int getBaseSlotLimit() {
        return this.baseSlotLimit;
    }

    public int getSlotLimit(int slot) {
        return this.inventoryPartitioner.getPartBySlot(slot).getSlotLimit(slot);
    }

    public int getBaseStackLimit(ItemStack stack) {
        int maxStackSize;
        if (!this.stackUpgradeConfig.canStackItem(stack.m_41720_())) {
            return stack.m_41741_();
        }
        int n = maxStackSize = stack.m_41619_() ? this.getBaseSlotLimit() : stack.m_41741_();
        if (this.baseSlotLimit < 64) {
            return (int)Math.max(1.0, (double)maxStackSize * (double)this.baseSlotLimit / 64.0);
        }
        int limit = MathHelper.intMaxCappedMultiply(maxStackSize, this.baseSlotLimit / 64);
        int remainder = this.baseSlotLimit % 64;
        if (remainder > 0) {
            limit = MathHelper.intMaxCappedAddition(limit, remainder * stack.m_41741_() / 64);
        }
        return limit;
    }

    public int getStackLimit(int slot, ItemStack stack) {
        return this.inventoryPartitioner.getPartBySlot(slot).getStackLimit(slot, stack);
    }

    public Item getFilterItem(int slot) {
        return this.inventoryPartitioner.getPartBySlot(slot).getFilterItem(slot);
    }

    public boolean isFilterItem(Item item) {
        return this.inventoryPartitioner.isFilterItem(item);
    }

    public void setBaseSlotLimit(int baseSlotLimit) {
        this.voidUpgradeInfoInitialized = false;
        this.baseSlotLimit = baseSlotLimit;
        this.maxStackSizeMultiplier = (float)baseSlotLimit / 64.0f;
        if (this.inventoryPartitioner != null) {
            this.inventoryPartitioner.onSlotLimitChange();
        }
        if (!this.isInitializing) {
            this.slotTracker.refreshSlotIndexesFrom(this);
        }
    }

    public ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.getSlotStack(slot);
        if (existing.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int toExtract = amount;
        if (existing.m_41613_() <= toExtract) {
            if (!simulate) {
                this.setSlotStack(slot, ItemStack.f_41583_);
                return existing;
            }
            return existing.m_41777_();
        }
        if (!simulate) {
            this.setSlotStack(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.m_41613_() - toExtract)));
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.inventoryPartitioner.getPartBySlot(slot).extractItem(slot, amount, simulate);
    }

    public void validateSlotIndex(int slot) {
        super.validateSlotIndex(slot);
    }

    public ItemStack getSlotStack(int slot) {
        return (ItemStack)this.stacks.get(slot);
    }

    public void setSlotStack(int slot, ItemStack stack) {
        this.stacks.set(slot, (Object)stack);
        this.getSlotTracker().removeAndSetSlotIndexes(this, slot, stack);
        this.onContentsChanged(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.getSlotTracker().insertItemIntoHandler(this, this::insertItemInternal, this::triggerOverflowUpgrades, slot, stack, simulate);
    }

    @Nonnull
    public ItemStack insertItemOnlyToSlot(int slot, ItemStack stack, boolean simulate) {
        this.initSlotTracker();
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)this.getStackInSlot(slot), (ItemStack)stack)) {
            return this.triggerOverflowUpgrades(this.insertItemInternal(slot, stack, simulate));
        }
        return this.insertItemInternal(slot, stack, simulate);
    }

    private void initSlotTracker() {
        if (!(this.slotTracker instanceof InventoryHandlerSlotTracker)) {
            this.slotTracker = new InventoryHandlerSlotTracker(this.storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class), this.filterItemSlots);
            this.slotTracker.refreshSlotIndexesFrom(this);
            this.slotTracker.setShouldInsertIntoEmpty(this.shouldInsertIntoEmpty);
        }
    }

    private ItemStack insertItemInternal(int slot, ItemStack stack, boolean simulate) {
        ItemStack ret = this.runOnBeforeInsert(slot, stack, simulate, this, this.storageWrapper);
        if (ret.m_41619_()) {
            return ret;
        }
        ret = this.inventoryPartitioner.getPartBySlot(slot).insertItem(slot, ret, simulate, (TriFunction<Integer, ItemStack, Boolean, ItemStack>)((TriFunction)(x$0, x$1, x$2) -> super.insertItem(x$0, x$1, x$2)));
        if (!simulate) {
            this.getSlotTracker().removeAndSetSlotIndexes(this, slot, this.getStackInSlot(slot));
        }
        if (ret == stack) {
            return ret;
        }
        this.runOnAfterInsert(slot, simulate, this, this.storageWrapper);
        return ret;
    }

    private ItemStack triggerOverflowUpgrades(ItemStack ret) {
        IOverflowResponseUpgrade overflowUpgrade;
        Iterator<IOverflowResponseUpgrade> iterator = this.storageWrapper.getUpgradeHandler().getWrappersThatImplement(IOverflowResponseUpgrade.class).iterator();
        while (iterator.hasNext() && !(ret = (overflowUpgrade = iterator.next()).onOverflow(ret)).m_41619_()) {
        }
        return ret;
    }

    private void runOnAfterInsert(int slot, boolean simulate, IItemHandlerSimpleInserter handler, IStorageWrapper storageWrapper) {
        if (!simulate) {
            storageWrapper.getUpgradeHandler().getWrappersThatImplementFromMainStorage(IInsertResponseUpgrade.class).forEach(u -> u.onAfterInsert(handler, slot));
        }
    }

    private ItemStack runOnBeforeInsert(int slot, ItemStack stack, boolean simulate, IItemHandlerSimpleInserter handler, IStorageWrapper storageWrapper) {
        List<IInsertResponseUpgrade> wrappers = storageWrapper.getUpgradeHandler().getWrappersThatImplementFromMainStorage(IInsertResponseUpgrade.class);
        ItemStack remaining = stack;
        for (IInsertResponseUpgrade upgrade : wrappers) {
            remaining = upgrade.onBeforeInsert(handler, slot, remaining, simulate);
            if (!remaining.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return remaining;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.inventoryPartitioner.getPartBySlot(slot).setStackInSlot(slot, stack, (x$0, x$1) -> super.setStackInSlot(x$0, x$1));
        this.getSlotTracker().removeAndSetSlotIndexes(this, slot, stack);
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isItemValid(int slot, ItemStack stack, @Nullable Player player) {
        return this.inventoryPartitioner.getPartBySlot(slot).isItemValid(slot, stack, player, (x$0, x$1) -> super.isItemValid(x$0, x$1)) && this.isAllowed(stack) && this.storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class).matchesFilter(slot, stack);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.isItemValid(slot, stack, null);
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.inventoryPartitioner.getPartBySlot(slot).getStackInSlot(slot, x$0 -> super.getStackInSlot(x$0));
    }

    protected abstract boolean isAllowed(ItemStack var1);

    public void saveInventory() {
        this.contentsNbt.m_128365_(INVENTORY_TAG, (Tag)this.serializeNBT());
        if (this.inventoryPartitioner != null) {
            this.contentsNbt.m_128365_(PARTITIONER_TAG, (Tag)this.inventoryPartitioner.serializeNBT());
        }
        this.saveHandler.run();
    }

    @Nullable
    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon(int slotIndex) {
        return this.inventoryPartitioner.getNoItemIcon(slotIndex);
    }

    public void copyStacksTo(InventoryHandler otherHandler) {
        InventoryHelper.copyTo(this, otherHandler);
    }

    public void addListener(IntConsumer onContentsChanged) {
        this.onContentsChangedListeners.add(onContentsChanged);
    }

    public void clearListeners() {
        this.onContentsChangedListeners.clear();
    }

    public CompoundTag serializeNBT() {
        ListTag nbtTagList = new ListTag();
        nbtTagList.addAll(this.stackNbts.values());
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Items", (Tag)nbtTagList);
        nbt.m_128405_("Size", this.getSlots());
        return nbt;
    }

    public double getStackSizeMultiplier() {
        return this.maxStackSizeMultiplier;
    }

    @Override
    public ItemStack insertItem(ItemStack stack, boolean simulate) {
        return this.getSlotTracker().insertItemIntoHandler(this, this::insertItemInternal, this::triggerOverflowUpgrades, stack, simulate);
    }

    @Override
    public ItemStack extractItem(ItemStack stack, boolean simulate) {
        return this.getSlotTracker().extractItemFromHandler(this, this::extractItemInternal, stack, simulate);
    }

    public void changeSlots(int diff) {
        NonNullList previousStacks = this.stacks;
        this.stacks = NonNullList.m_122780_((int)(previousStacks.size() + diff), (Object)ItemStack.f_41583_);
        for (int slot = 0; slot < previousStacks.size() && slot < this.stacks.size(); ++slot) {
            this.stacks.set(slot, (Object)((ItemStack)previousStacks.get(slot)));
        }
        this.initStackNbts();
        this.saveInventory();
        this.getSlotTracker().refreshSlotIndexesFrom(this);
    }

    @Override
    public Set<ItemStackKey> getTrackedStacks() {
        this.initSlotTracker();
        HashSet<ItemStackKey> ret = new HashSet<ItemStackKey>(this.slotTracker.getFullStacks());
        ret.addAll(this.slotTracker.getPartialStacks());
        return ret;
    }

    @Override
    public void registerTrackingListeners(Consumer<ItemStackKey> onAddStackKey, Consumer<ItemStackKey> onRemoveStackKey, Runnable onAddFirstEmptySlot, Runnable onRemoveLastEmptySlot) {
        this.getSlotTracker().registerListeners(onAddStackKey, onRemoveStackKey, onAddFirstEmptySlot, onRemoveLastEmptySlot);
    }

    @Override
    public void unregisterStackKeyListeners() {
        this.slotTracker.unregisterStackKeyListeners();
    }

    @Override
    public boolean hasEmptySlots() {
        return this.slotTracker.hasEmptySlots();
    }

    public InventoryPartitioner getInventoryPartitioner() {
        return this.inventoryPartitioner;
    }

    public boolean isSlotAccessible(int slot) {
        return this.inventoryPartitioner.getPartBySlot(slot).isSlotAccessible(slot);
    }

    public Set<Integer> getNoSortSlots() {
        return this.inventoryPartitioner.getNoSortSlots();
    }

    public void onSlotFilterChanged(int slot) {
        this.inventoryPartitioner.getPartBySlot(slot).onSlotFilterChanged(slot);
    }

    public void registerFilterItemsChangeListener(Consumer<Set<Item>> listener) {
        this.filterItemsChangeListener = listener;
    }

    public void unregisterFilterItemsChangeListener() {
        this.filterItemsChangeListener = s -> {};
    }

    public void initFilterItems() {
        this.inventoryPartitioner.getFilterItems().forEach((item, slots) -> slots.forEach(slot -> this.filterItemSlots.add((int)slot, (Item)item)));
    }

    public void onFilterItemsChanged() {
        this.slotTracker.refreshSlotIndexesFrom(this);
        if (this.inventoryPartitioner == null) {
            return;
        }
        this.filterItemSlots.clear();
        this.inventoryPartitioner.getFilterItems().forEach((item, slots) -> slots.forEach(slot -> this.filterItemSlots.add((int)slot, (Item)item)));
        this.filterItemsChangeListener.accept(this.filterItemSlots.keySet());
    }

    public Set<Item> getFilterItems() {
        return this.filterItemSlots.keySet();
    }

    public void onInit() {
        if (this.inventoryPartitioner == null) {
            return;
        }
        this.inventoryPartitioner.onInit();
        this.slotTracker = new ISlotTracker.Noop();
    }

    public void setShouldInsertIntoEmpty(BooleanSupplier shouldInsertIntoEmpty) {
        this.shouldInsertIntoEmpty = shouldInsertIntoEmpty;
        this.getSlotTracker().setShouldInsertIntoEmpty(shouldInsertIntoEmpty);
    }

    public boolean isInfinite(int slot) {
        return this.inventoryPartitioner.isInfinite(slot);
    }

    private boolean hasVoidUpgrade() {
        if (!this.voidUpgradeInfoInitialized) {
            this.hasVoidUpgrade = !this.storageWrapper.getUpgradeHandler().getTypeWrappers(VoidUpgradeItem.TYPE).isEmpty();
            this.voidUpgradeInfoInitialized = true;
        }
        return this.hasVoidUpgrade;
    }

    @Override
    public boolean isInsertBlocked() {
        if (this.hasVoidUpgrade()) {
            return false;
        }
        for (int slot = 0; slot < this.stacks.size(); ++slot) {
            ItemStack stack = (ItemStack)this.stacks.get(slot);
            if (stack.m_41613_() >= this.getStackLimit(slot, stack)) continue;
            return false;
        }
        return true;
    }
}

