/*
 * Decompiled with CFR 0.152.
 */
package fuzs.echochest.world.level.block.entity;

import fuzs.echochest.world.inventory.EchoChestMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

class EchoChestOpenersCounter {
    private final Container container;
    private int openCount;

    public EchoChestOpenersCounter(Container container) {
        this.container = container;
    }

    protected void onOpen(Level level, BlockPos pos, BlockState state) {
        level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11749_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    protected void onClose(Level level, BlockPos pos, BlockState state) {
        level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11747_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int count, int openCount) {
        level.m_7696_(pos, state.m_60734_(), 1, openCount);
    }

    protected boolean isOwnContainer(Player player) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof EchoChestMenu) {
            EchoChestMenu menu = (EchoChestMenu)abstractContainerMenu;
            Container container = menu.getContainer();
            return container == this.container;
        }
        return false;
    }

    public void incrementOpeners(@Nullable Player player, Level level, BlockPos pos, BlockState state) {
        int i;
        if ((i = this.openCount++) == 0) {
            if (player != null) {
                this.onOpen(level, pos, state);
            }
            level.m_142346_((Entity)player, GameEvent.f_157803_, pos);
            EchoChestOpenersCounter.scheduleRecheck(level, pos, state, player == null);
        }
        this.openerCountChanged(level, pos, state, i, this.openCount);
    }

    public void decrementOpeners(Player player, Level level, BlockPos pos, BlockState state) {
        int i = this.openCount--;
        if (this.openCount == 0) {
            this.onClose(level, pos, state);
            level.m_142346_((Entity)player, GameEvent.f_157802_, pos);
        }
        this.openerCountChanged(level, pos, state, i, this.openCount);
    }

    private int getOpenCount(Level level, BlockPos pos) {
        int i = pos.m_123341_();
        int j = pos.m_123342_();
        int k = pos.m_123343_();
        float f = 5.0f;
        AABB aABB = new AABB((double)((float)i - 5.0f), (double)((float)j - 5.0f), (double)((float)k - 5.0f), (double)((float)(i + 1) + 5.0f), (double)((float)(j + 1) + 5.0f), (double)((float)(k + 1) + 5.0f));
        return level.m_142425_(EntityTypeTest.m_156916_(Player.class), aABB, this::isOwnContainer).size();
    }

    public void recheckOpeners(Level level, BlockPos pos, BlockState state) {
        int j = this.openCount;
        int i = this.getOpenCount(level, pos);
        if (j != i) {
            boolean bl2;
            boolean bl = i != 0;
            boolean bl3 = bl2 = j != 0;
            if (bl && !bl2) {
                level.m_142346_(null, GameEvent.f_157803_, pos);
            } else if (!bl) {
                level.m_142346_(null, GameEvent.f_157802_, pos);
            }
            this.openCount = i;
        }
        this.openerCountChanged(level, pos, state, j, i);
        if (i > 0) {
            EchoChestOpenersCounter.scheduleRecheck(level, pos, state, false);
        }
    }

    public int getOpenerCount() {
        return this.openCount;
    }

    private static void scheduleRecheck(Level level, BlockPos pos, BlockState state, boolean quick) {
        level.m_186460_(pos, state.m_60734_(), quick ? 3 : 5);
    }
}

