/*
 * Decompiled with CFR 0.152.
 */
package fuzs.echochest.world.level.block.entity;

import fuzs.echochest.world.level.block.entity.EchoChestBlockEntity;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;

record EchoChestListener(EchoChestBlockEntity blockEntity) implements GameEventListener
{
    public PositionSource m_142460_() {
        return this.blockEntity.m_280445_().m_280010_();
    }

    public int m_142078_() {
        return this.blockEntity.m_280445_().m_280351_();
    }

    public boolean m_214068_(ServerLevel level, GameEvent gameEvent, GameEvent.Context context, Vec3 pos) {
        Optional optional;
        if (this.blockEntity.m_280445_().m_280612_(gameEvent, context) && (optional = this.m_142460_().m_142502_((Level)level)).isPresent()) {
            Vec3 destination = (Vec3)optional.get();
            if (!this.blockEntity.m_280445_().m_280080_(level, BlockPos.m_274446_((Position)pos), gameEvent, context)) {
                return false;
            }
            if (EchoChestBlockEntity.isOccluded((Level)level, pos, destination)) {
                return false;
            }
            if (this.onSignalReceive(level, gameEvent, context, pos, destination)) {
                EchoChestBlockEntity.animate((Level)level, this.blockEntity.m_58899_(), this.blockEntity.m_58900_(), this.blockEntity.openersCounter);
                int travelTimeInTicks = Mth.m_14107_((double)pos.m_82554_(destination));
                level.m_8767_((ParticleOptions)new VibrationParticleOption(this.m_142460_(), travelTimeInTicks), pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                return true;
            }
        }
        return false;
    }

    private boolean onSignalReceive(ServerLevel level, GameEvent event, GameEvent.Context context, Vec3 origin, Vec3 destination) {
        if (event == GameEvent.f_223707_) {
            Entity entity = context.f_223711_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (this.blockEntity.canAcceptExperience() && !livingEntity.m_217046_()) {
                    int experienceReward = livingEntity.m_213860_();
                    if (livingEntity.m_6149_() && experienceReward > 0) {
                        this.blockEntity.acceptExperience(experienceReward);
                    }
                    livingEntity.m_217045_();
                    return true;
                }
            }
        } else {
            ItemEntity item;
            Entity livingEntity = context.f_223711_();
            if (livingEntity instanceof ItemEntity && !(item = (ItemEntity)livingEntity).m_213877_()) {
                int lastCount = item.m_32055_().m_41613_();
                return HopperBlockEntity.m_59331_((Container)this.blockEntity, (ItemEntity)item) || lastCount != item.m_32055_().m_41613_();
            }
        }
        return false;
    }
}

