/*
 * Decompiled with CFR 0.152.
 */
package fuzs.echochest.world.level.block.entity;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import fuzs.echochest.EchoChest;
import fuzs.echochest.init.ModRegistry;
import fuzs.echochest.world.inventory.EchoChestMenu;
import fuzs.echochest.world.level.block.entity.EchoChestListener;
import fuzs.echochest.world.level.block.entity.EchoChestOpenersCounter;
import fuzs.echochest.world.level.block.entity.EchoChestVibrationUser;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class EchoChestBlockEntity
extends ChestBlockEntity
implements WorldlyContainer,
GameEventListener.Holder<EchoChestListener>,
VibrationSystem {
    public static final String TAG_EXPERIENCE = "Experience";
    public static final MutableComponent CONTAINER_TITLE = Component.m_237115_((String)"container.echo_chest");
    public static final int CONTAINER_SIZE = 25;
    public static final int MAX_EXPERIENCE = 3000;
    public static final int EXPERIENCE_PER_BOTTLE = 7;
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return index == 0 ? EchoChestBlockEntity.this.experience : 0;
        }

        public void m_8050_(int index, int value) {
            if (index == 0) {
                EchoChestBlockEntity.this.experience = value;
            }
        }

        public int m_6499_() {
            return 1;
        }
    };
    final EchoChestOpenersCounter openersCounter;
    private final int[] allSlots;
    private final int[] inventorySlots;
    private final EchoChestListener listener;
    private final VibrationSystem.User user;
    private VibrationSystem.Data vibrationData;
    private int experience;

    public EchoChestBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModRegistry.ECHO_CHEST_BLOCK_ENTITY_TYPE.get(), blockPos, blockState);
        this.m_6520_(NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_));
        this.allSlots = IntStream.range(0, this.m_6643_()).toArray();
        this.inventorySlots = IntStream.range(1, this.m_6643_()).toArray();
        this.openersCounter = new EchoChestOpenersCounter((Container)this);
        this.listener = new EchoChestListener(this);
        this.user = new EchoChestVibrationUser(this);
        this.vibrationData = new VibrationSystem.Data();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, EchoChestBlockEntity blockEntity) {
        if (blockEntity.experience >= 7 && EchoChestMenu.validBottleItem(blockEntity.m_8020_(0)) && HopperBlockEntity.m_59326_(null, (Container)blockEntity, (ItemStack)new ItemStack((ItemLike)Items.f_42612_), null).m_41619_()) {
            blockEntity.extractExperienceBottle();
            ItemStack stack = blockEntity.m_8020_(0).m_41777_();
            stack.m_41774_(1);
            blockEntity.m_6836_(0, stack);
        }
    }

    static void animate(Level level, BlockPos pos, BlockState state, EchoChestOpenersCounter openersCounter) {
        openersCounter.incrementOpeners(null, level, pos, state);
        if (!((Boolean)state.m_61143_((Property)EnderChestBlock.f_53116_)).booleanValue()) {
            level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_144103_, SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.2f + 0.8f);
        }
    }

    static boolean isOccluded(Level level, Vec3 from, Vec3 to) {
        from = new Vec3((double)Mth.m_14107_((double)from.f_82479_) + 0.5, (double)Mth.m_14107_((double)from.f_82480_) + 0.5, (double)Mth.m_14107_((double)from.f_82481_) + 0.5);
        to = new Vec3((double)Mth.m_14107_((double)to.f_82479_) + 0.5, (double)Mth.m_14107_((double)to.f_82480_) + 0.5, (double)Mth.m_14107_((double)to.f_82481_) + 0.5);
        for (Direction direction : Direction.values()) {
            Vec3 vec3 = from.m_231075_(direction, (double)1.0E-5f);
            if (level.m_151353_(new ClipBlockStateContext(vec3, to, blockState -> blockState.m_204336_(BlockTags.f_144272_))).m_6662_() == HitResult.Type.BLOCK) continue;
            return false;
        }
        return true;
    }

    public int m_6643_() {
        return 25;
    }

    protected Component m_6820_() {
        return CONTAINER_TITLE;
    }

    public boolean canAcceptExperience() {
        return this.experience < 3000;
    }

    public void acceptExperience(int amount) {
        int lastExperience = this.experience;
        this.experience = Mth.m_14045_((int)(this.experience + amount), (int)0, (int)3000);
        if (this.experience != lastExperience) {
            this.m_6596_();
        }
    }

    public void extractExperienceBottle() {
        this.acceptExperience(-7);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.m_6520_(NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_));
        if (!this.m_59631_(tag)) {
            ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)this.m_7086_());
        }
        this.experience = tag.m_128451_(TAG_EXPERIENCE);
        if (tag.m_128425_("listener", 10)) {
            VibrationSystem.Data.f_279637_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128469_("listener"))).resultOrPartial(arg_0 -> ((Logger)EchoChest.LOGGER).error(arg_0)).ifPresent(data -> {
                this.vibrationData = data;
            });
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128473_("Items");
        if (!this.m_59634_(tag)) {
            ContainerHelper.m_18976_((CompoundTag)tag, (NonNullList)this.m_7086_(), (boolean)true);
        }
        tag.m_128405_(TAG_EXPERIENCE, this.experience);
        VibrationSystem.Data.f_279637_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.vibrationData).resultOrPartial(arg_0 -> ((Logger)EchoChest.LOGGER).error(arg_0)).ifPresent(data -> tag.m_128365_("listener", data));
    }

    protected AbstractContainerMenu m_6555_(int containerId, Inventory inventory) {
        return new EchoChestMenu(containerId, inventory, (Container)this, this.dataAccess);
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.incrementOpeners(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.decrementOpeners(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_155350_() {
        if (!this.f_58859_) {
            this.openersCounter.recheckOpeners(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return index != 0 || EchoChestMenu.validBottleItem(stack);
    }

    public int[] m_7071_(Direction side) {
        return side.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL ? this.allSlots : this.inventorySlots;
    }

    public boolean m_7155_(int index, ItemStack itemStack, @Nullable Direction direction) {
        return (index != 0 || direction != null) && this.m_7013_(index, itemStack);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return index != 0;
    }

    public EchoChestListener getListener() {
        return this.listener;
    }

    public VibrationSystem.User m_280445_() {
        return this.user;
    }

    public VibrationSystem.Data m_280002_() {
        return this.vibrationData;
    }
}

