/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.registrars;

import com.communi.suggestu.scena.core.client.event.IClientEvents;
import com.communi.suggestu.scena.core.client.event.IClientTickStartedEvent;
import com.communi.suggestu.scena.core.client.event.IDrawHighlightEvent;
import com.communi.suggestu.scena.core.client.event.IHudRenderEvent;
import com.communi.suggestu.scena.core.client.event.IPostRenderWorldEvent;
import com.communi.suggestu.scena.core.client.event.IScrollEvent;
import com.communi.suggestu.scena.core.event.IChunkLoadEvent;
import com.communi.suggestu.scena.core.event.IEvent;
import com.communi.suggestu.scena.core.event.IGameEvents;
import com.communi.suggestu.scena.core.event.IGatherTooltipEvent;
import com.communi.suggestu.scena.core.event.IPlayerLoggedInEvent;
import mod.chiselsandbits.client.input.FrameBasedInputTracker;
import mod.chiselsandbits.client.logic.ChiseledBlockModelUpdateHandler;
import mod.chiselsandbits.client.logic.MeasurementTapeItemResetHandler;
import mod.chiselsandbits.client.logic.MeasurementsRenderHandler;
import mod.chiselsandbits.client.logic.MultiStateBlockPreviewRenderHandler;
import mod.chiselsandbits.client.logic.ScrollBasedModeChangeHandler;
import mod.chiselsandbits.client.logic.SelectedObjectHighlightHandler;
import mod.chiselsandbits.client.logic.SelectedObjectRenderHandler;
import mod.chiselsandbits.client.logic.SlotOverlayRenderHandler;
import mod.chiselsandbits.client.logic.ToolNameHighlightTickHandler;
import mod.chiselsandbits.client.time.TickHandler;
import mod.chiselsandbits.clipboard.CreativeClipboardManager;
import mod.chiselsandbits.keys.KeyBindingManager;
import mod.chiselsandbits.logic.MagnifyingGlassTooltipHandler;
import net.minecraft.world.level.chunk.LevelChunk;

public final class EventHandlers {
    private EventHandlers() {
        throw new IllegalStateException("Can not instantiate an instance of: EventHandlers. This is a utility class");
    }

    public static void onClientConstruction() {
        IGameEvents.getInstance().getChunkLoadEvent().register((IEvent)((IChunkLoadEvent)(levelAccessor, chunkAccess) -> {
            if (chunkAccess instanceof LevelChunk) {
                LevelChunk levelChunk = (LevelChunk)chunkAccess;
                ChiseledBlockModelUpdateHandler.updateAllModelDataInChunk(levelChunk);
            }
        }));
        IGameEvents.getInstance().getPlayerLoggedInEvent().register((IEvent)((IPlayerLoggedInEvent)player -> CreativeClipboardManager.getInstance().load()));
        IClientEvents.getInstance().getClientTickStartedEvent().register((IEvent)((IClientTickStartedEvent)() -> {
            ToolNameHighlightTickHandler.handleClientTickForMagnifyingGlass();
            KeyBindingManager.getInstance().handleKeyPresses();
            TickHandler.onClientTick();
            MeasurementTapeItemResetHandler.checkAndDoReset();
        }));
        IClientEvents.getInstance().getDrawHighlightEvent().register((IEvent)((IDrawHighlightEvent)SelectedObjectHighlightHandler::onDrawHighlight));
        IClientEvents.getInstance().getScrollEvent().register((IEvent)((IScrollEvent)ScrollBasedModeChangeHandler::onScroll));
        IClientEvents.getInstance().getHUDRenderEvent().register((IEvent)((IHudRenderEvent)SlotOverlayRenderHandler::renderSlotOverlays));
        IClientEvents.getInstance().getPostRenderWorldEvent().register((IEvent)((IPostRenderWorldEvent)(levelRenderer, poseStack, partialTickTime) -> {
            SelectedObjectRenderHandler.renderCustomWorldHighlight(levelRenderer, poseStack, partialTickTime);
            MeasurementsRenderHandler.renderMeasurements(poseStack);
            MultiStateBlockPreviewRenderHandler.renderMultiStateBlockPreview(poseStack);
            FrameBasedInputTracker.getInstance().onRenderFrame();
        }));
        IClientEvents.getInstance().getGatherTooltipEvent().register((IEvent)((IGatherTooltipEvent)MagnifyingGlassTooltipHandler::onItemTooltip));
    }
}

