/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ability;

import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieAnimationController;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoPlayer;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class PlayerAbility
extends Ability<Player> {
    protected RawAnimation activeFirstPersonAnimation;
    protected ItemStack heldItemMainHandVisualOverride;
    protected ItemStack heldItemOffHandVisualOverride;
    protected HandDisplay firstPersonMainHandDisplay;
    protected HandDisplay firstPersonOffHandDisplay;
    private static RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("idle");

    public PlayerAbility(AbilityType<Player, ? extends Ability> abilityType, Player user, AbilitySection[] sectionTrack, int cooldownMax) {
        super(abilityType, user, sectionTrack, cooldownMax);
        if (user.m_9236_().f_46443_) {
            this.activeAnimation = IDLE_ANIM;
            this.heldItemMainHandVisualOverride = null;
            this.heldItemOffHandVisualOverride = null;
            this.firstPersonMainHandDisplay = HandDisplay.DEFAULT;
            this.firstPersonOffHandDisplay = HandDisplay.DEFAULT;
        }
    }

    public PlayerAbility(AbilityType<Player, ? extends Ability> abilityType, Player user, AbilitySection[] sectionTrack) {
        this(abilityType, user, sectionTrack, 0);
    }

    public void playAnimation(RawAnimation animation, GeckoPlayer.Perspective perspective) {
        if (this.getUser() != null && ((Player)this.getUser()).m_9236_().m_5776_()) {
            if (perspective == GeckoPlayer.Perspective.FIRST_PERSON) {
                this.activeFirstPersonAnimation = animation;
            } else {
                this.activeAnimation = animation;
            }
            MowzieAnimationController<GeckoPlayer> controller = GeckoPlayer.getAnimationController((Player)this.getUser(), perspective);
            GeckoPlayer geckoPlayer = GeckoPlayer.getGeckoPlayer((Player)this.getUser(), perspective);
            if (controller != null && geckoPlayer != null) {
                controller.playAnimation(geckoPlayer, animation);
            }
        }
    }

    public void playAnimation(String animationName, GeckoPlayer.Perspective perspective, Animation.LoopType loopType) {
        this.playAnimation(RawAnimation.begin().then(animationName, loopType), perspective);
    }

    @Override
    public void playAnimation(RawAnimation animation) {
        this.playAnimation(animation, GeckoPlayer.Perspective.FIRST_PERSON);
        this.playAnimation(animation, GeckoPlayer.Perspective.THIRD_PERSON);
    }

    public void playAnimation3rdPerson(RawAnimation animation) {
        this.playAnimation(animation, GeckoPlayer.Perspective.THIRD_PERSON);
    }

    public InteractionHand getActiveHand() {
        return ((Player)this.getUser()).m_7655_();
    }

    public void playAnimation(String animationName, Animation.LoopType loopType, boolean separateLeftAndRight1stPerson, boolean separateLeftAndRight3rdPerson) {
        boolean isRightHanded;
        boolean usingMainHand = this.getActiveHand() == InteractionHand.MAIN_HAND;
        boolean bl = isRightHanded = ((Player)this.getUser()).m_5737_() == HumanoidArm.RIGHT;
        if (separateLeftAndRight1stPerson) {
            this.playAnimation(animationName + (usingMainHand ? "_right" : "_left"), GeckoPlayer.Perspective.FIRST_PERSON, loopType);
        } else {
            this.playAnimation(animationName, GeckoPlayer.Perspective.FIRST_PERSON, loopType);
        }
        if (separateLeftAndRight3rdPerson) {
            this.playAnimation(animationName + "_" + (usingMainHand == isRightHanded ? "right" : "left"), GeckoPlayer.Perspective.THIRD_PERSON, loopType);
        } else {
            this.playAnimation(RawAnimation.begin().then(animationName, loopType), GeckoPlayer.Perspective.THIRD_PERSON);
        }
    }

    @Override
    public void end() {
        super.end();
        if (((Player)this.getUser()).m_9236_().f_46443_) {
            this.heldItemMainHandVisualOverride = null;
            this.heldItemOffHandVisualOverride = null;
            this.firstPersonMainHandDisplay = HandDisplay.DEFAULT;
            this.firstPersonOffHandDisplay = HandDisplay.DEFAULT;
        }
    }

    @Override
    public boolean canUse() {
        return super.canUse() && !((Player)this.getUser()).m_5833_();
    }

    @Override
    protected boolean canContinueUsing() {
        return super.canContinueUsing() && !((Player)this.getUser()).m_5833_();
    }

    @Override
    public <E extends GeoEntity> PlayState animationPredicate(AnimationState<E> e, GeckoPlayer.Perspective perspective) {
        RawAnimation whichAnimation = perspective == GeckoPlayer.Perspective.FIRST_PERSON ? this.activeFirstPersonAnimation : this.activeAnimation;
        if (whichAnimation == null || whichAnimation.getAnimationStages().isEmpty()) {
            return PlayState.STOP;
        }
        e.getController().setAnimation(whichAnimation);
        return PlayState.CONTINUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack heldItemMainHandOverride() {
        return this.heldItemMainHandVisualOverride;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack heldItemOffHandOverride() {
        return this.heldItemOffHandVisualOverride;
    }

    @OnlyIn(value=Dist.CLIENT)
    public HandDisplay getFirstPersonMainHandDisplay() {
        return this.firstPersonMainHandDisplay;
    }

    @OnlyIn(value=Dist.CLIENT)
    public HandDisplay getFirstPersonOffHandDisplay() {
        return this.firstPersonOffHandDisplay;
    }

    public void onRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
    }

    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
    }

    public void onRightClickWithItem(PlayerInteractEvent.RightClickItem event) {
    }

    public void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
    }

    public void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
    }

    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
    }

    public void onLeftClickEntity(AttackEntityEvent event) {
    }

    @Override
    public void onTakeDamage(LivingHurtEvent event) {
    }

    public void onJump(LivingEvent.LivingJumpEvent event) {
    }

    public void onFall(LivingFallEvent event) {
    }

    public void onRightMouseDown(Player player) {
    }

    public void onLeftMouseDown(Player player) {
    }

    public void onRightMouseUp(Player player) {
    }

    public void onLeftMouseUp(Player player) {
    }

    public void onSneakDown(Player player) {
    }

    public void onSneakUp(Player player) {
    }

    public static enum HandDisplay {
        DEFAULT,
        DONT_RENDER,
        FORCE_RENDER;

    }
}

