/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.ParticleVanillaCloudExtended;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleData;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleRotation;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.advancement.AdvancementHandler;
import com.bobmowzie.mowziesmobs.server.ai.AvoidEntityIfNotTamedGoal;
import com.bobmowzie.mowziesmobs.server.block.BlockHandler;
import com.bobmowzie.mowziesmobs.server.capability.AbilityCapability;
import com.bobmowzie.mowziesmobs.server.capability.CapabilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.FrozenCapability;
import com.bobmowzie.mowziesmobs.server.capability.LivingCapability;
import com.bobmowzie.mowziesmobs.server.capability.PlayerCapability;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.LeaderSunstrikeImmune;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.MowzieGeckoEntity;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityBoulderProjectile;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityGeomancyBase;
import com.bobmowzie.mowziesmobs.server.entity.foliaath.EntityFoliaath;
import com.bobmowzie.mowziesmobs.server.entity.frostmaw.EntityFrostmaw;
import com.bobmowzie.mowziesmobs.server.entity.naga.EntityNaga;
import com.bobmowzie.mowziesmobs.server.entity.sculptor.EntitySculptor;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthana;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthanaCrane;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthanaFollowerToPlayer;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthanaMinion;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthi;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.MaskType;
import com.bobmowzie.mowziesmobs.server.entity.wroughtnaut.EntityWroughtnaut;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.item.ItemNagaFangDagger;
import com.bobmowzie.mowziesmobs.server.item.ItemSpear;
import com.bobmowzie.mowziesmobs.server.item.ItemUmvuthanaMask;
import com.bobmowzie.mowziesmobs.server.message.MessageFreezeEffect;
import com.bobmowzie.mowziesmobs.server.message.MessageSunblockEffect;
import com.bobmowzie.mowziesmobs.server.potion.EffectGeomancy;
import com.bobmowzie.mowziesmobs.server.potion.EffectHandler;
import com.bobmowzie.mowziesmobs.server.power.Power;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.bobmowzie.mowziesmobs.server.tag.TagHandler;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.StructureTypeHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.PacketDistributor;

public final class ServerEventHandler {
    private static final UUID DEFENSE_MODIFIER_BELT_UUID = UUID.fromString("970ecf8f-aba5-4f40-9092-a8cfaecfb32d");
    private static final AttributeModifier DEFENSE_MODIFIER_BELT = new AttributeModifier(DEFENSE_MODIFIER_BELT_UUID, "Geomancy Belt defense boost", 4.0, AttributeModifier.Operation.ADDITION);
    private static final UUID KNOCKBACK_MODIFIER_BELT_UUID = UUID.fromString("bfacc1ed-0cf1-4827-9012-4f8554c369f6");
    private static final AttributeModifier KNOCKBACK_MODIFIER_BELT = new AttributeModifier(KNOCKBACK_MODIFIER_BELT_UUID, "Geomancy Belt knockback resistance boost", 1.0, AttributeModifier.Operation.ADDITION);
    private static final UUID ATTACK_MODIFIER_BEADS_UUID = UUID.fromString("8320d16d-b0ef-4d42-a425-c619a4760eca");
    private static final AttributeModifier ATTACK_MODIFIER_BEADS = new AttributeModifier(ATTACK_MODIFIER_BEADS_UUID, "Geomancy Beads attack boost", 3.0, AttributeModifier.Operation.ADDITION);

    @SubscribeEvent
    public void onJoinWorld(EntityJoinLevelEvent event) {
        PlayerCapability.IPlayerCapability playerCapability;
        AbilityCapability.IAbilityCapability abilityCapability;
        if ((event.getEntity() instanceof Player || event.getEntity() instanceof MowzieGeckoEntity) && (abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)event.getEntity())) != null) {
            abilityCapability.instanceAbilities((LivingEntity)event.getEntity());
        }
        if (event.getEntity() instanceof Player && (playerCapability = CapabilityHandler.getCapability((Entity)((Player)event.getEntity()), CapabilityHandler.PLAYER_CAPABILITY)) != null) {
            playerCapability.addedToWorld(event);
        }
        if (event.getLevel().f_46443_) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Zombie && !(entity instanceof ZombifiedPiglin)) {
            ((PathfinderMob)entity).f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)((PathfinderMob)entity), EntityFoliaath.class, 0, true, false, null));
            ((PathfinderMob)entity).f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)((PathfinderMob)entity), EntityUmvuthana.class, 0, true, false, null));
            ((PathfinderMob)entity).f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)((PathfinderMob)entity), EntityUmvuthi.class, 0, true, false, null));
        }
        if (entity instanceof AbstractSkeleton) {
            ((PathfinderMob)entity).f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)((PathfinderMob)entity), EntityUmvuthana.class, 0, true, false, null));
            ((PathfinderMob)entity).f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)((PathfinderMob)entity), EntityUmvuthi.class, 0, true, false, null));
        }
        if (entity instanceof Parrot) {
            ((PathfinderMob)entity).f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)entity, EntityFoliaath.class, 6.0f, 1.0, 1.2));
        }
        if (entity instanceof Animal) {
            ((PathfinderMob)entity).f_21345_.m_25352_(3, new AvoidEntityIfNotTamedGoal((PathfinderMob)entity, EntityFoliaath.class, 6.0f, 1.0, 1.2));
            ((PathfinderMob)entity).f_21345_.m_25352_(3, new AvoidEntityIfNotTamedGoal((PathfinderMob)entity, EntityUmvuthana.class, 6.0f, 1.0, 1.2));
            ((PathfinderMob)entity).f_21345_.m_25352_(3, new AvoidEntityIfNotTamedGoal((PathfinderMob)entity, EntityUmvuthi.class, 6.0f, 1.0, 1.2));
            ((PathfinderMob)entity).f_21345_.m_25352_(3, new AvoidEntityIfNotTamedGoal((PathfinderMob)entity, EntityNaga.class, 10.0f, 1.0, 1.2));
            ((PathfinderMob)entity).f_21345_.m_25352_(3, new AvoidEntityIfNotTamedGoal((PathfinderMob)entity, EntityFrostmaw.class, 10.0f, 1.0, 1.2));
        }
        if (entity instanceof AbstractVillager) {
            ((PathfinderMob)entity).f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)entity, EntityUmvuthana.class, 6.0f, 1.0, 1.2));
            ((PathfinderMob)entity).f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)entity, EntityUmvuthi.class, 6.0f, 1.0, 1.2));
            ((PathfinderMob)entity).f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)entity, EntityNaga.class, 10.0f, 1.0, 1.2));
            ((PathfinderMob)entity).f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)entity, EntityFrostmaw.class, 10.0f, 1.0, 1.2));
        }
        if (entity instanceof Pillager) {
            ((PathfinderMob)entity).f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)((PathfinderMob)entity), EntitySculptor.class, 0, true, false, null));
        }
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingTickEvent event) {
        if (event.getEntity() != null) {
            AbilityCapability.IAbilityCapability abilityCapability;
            LivingCapability.ILivingCapability livingCapability;
            FrozenCapability.IFrozenCapability frozenCapability;
            Mob mob;
            Item headItemStack;
            LivingEntity entity = event.getEntity();
            if (entity.m_21124_((MobEffect)EffectHandler.POISON_RESIST.get()) != null && entity.m_21124_(MobEffects.f_19614_) != null) {
                entity.m_6234_(MobEffects.f_19614_);
            }
            if (!entity.m_9236_().f_46443_ && (headItemStack = entity.m_6844_(EquipmentSlot.HEAD).m_41720_()) instanceof ItemUmvuthanaMask) {
                ItemUmvuthanaMask mask = (ItemUmvuthanaMask)headItemStack;
                EffectHandler.addOrCombineEffect(entity, mask.getPotion(), 50, 0, true, false);
            }
            if (entity instanceof Mob && !(entity instanceof EntityUmvuthanaCrane) && (mob = (Mob)entity).m_5448_() instanceof EntityUmvuthi && mob.m_5448_().m_21023_((MobEffect)EffectHandler.SUNBLOCK.get())) {
                EntityUmvuthanaCrane sunblocker = (EntityUmvuthanaCrane)mob.m_9236_().m_45963_(EntityUmvuthanaCrane.class, TargetingConditions.f_26872_, (LivingEntity)mob, mob.m_20185_(), mob.m_20186_() + (double)mob.m_20192_(), mob.m_20189_(), mob.m_20191_().m_82377_(40.0, 15.0, 40.0));
                mob.m_6710_((LivingEntity)sunblocker);
            }
            if ((frozenCapability = CapabilityHandler.getCapability((Entity)entity, CapabilityHandler.FROZEN_CAPABILITY)) != null) {
                frozenCapability.tick(entity);
            }
            if ((livingCapability = CapabilityHandler.getCapability((Entity)entity, CapabilityHandler.LIVING_CAPABILITY)) != null) {
                livingCapability.tick(entity);
            }
            if ((abilityCapability = CapabilityHandler.getCapability((Entity)entity, CapabilityHandler.ABILITY_CAPABILITY)) != null) {
                abilityCapability.tick(entity);
            }
            AttributeInstance attributeInstanceArmor = entity.m_21051_(Attributes.f_22284_);
            AttributeInstance attributeInstanceKnockbackRes = entity.m_21051_(Attributes.f_22278_);
            if (entity.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)ItemHandler.GEOMANCER_BELT.get()) && entity.m_21023_(MobEffects.f_19597_)) {
                if (attributeInstanceArmor != null && !attributeInstanceArmor.m_22109_(DEFENSE_MODIFIER_BELT)) {
                    attributeInstanceArmor.m_22118_(DEFENSE_MODIFIER_BELT);
                }
                if (attributeInstanceKnockbackRes != null && !attributeInstanceKnockbackRes.m_22109_(KNOCKBACK_MODIFIER_BELT)) {
                    attributeInstanceKnockbackRes.m_22118_(KNOCKBACK_MODIFIER_BELT);
                }
            } else {
                if (attributeInstanceArmor != null && attributeInstanceArmor.m_22109_(DEFENSE_MODIFIER_BELT)) {
                    attributeInstanceArmor.m_22130_(DEFENSE_MODIFIER_BELT);
                }
                if (attributeInstanceKnockbackRes != null && attributeInstanceKnockbackRes.m_22109_(KNOCKBACK_MODIFIER_BELT)) {
                    attributeInstanceKnockbackRes.m_22130_(KNOCKBACK_MODIFIER_BELT);
                }
            }
        }
    }

    @SubscribeEvent
    public void onAddPotionEffect(MobEffectEvent.Added event) {
        if (event.getEffectInstance().m_19544_() == EffectHandler.SUNBLOCK.get()) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MowziesMobs.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> ((MobEffectEvent.Added)event).getEntity()), (Object)new MessageSunblockEffect(event.getEntity(), true));
            }
            MowziesMobs.PROXY.playSunblockSound(event.getEntity());
        }
        if (event.getEffectInstance().m_19544_() == EffectHandler.FROZEN.get() && !event.getEntity().m_9236_().m_5776_()) {
            MowziesMobs.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> ((MobEffectEvent.Added)event).getEntity()), (Object)new MessageFreezeEffect(event.getEntity(), true));
            FrozenCapability.IFrozenCapability frozenCapability = CapabilityHandler.getCapability((Entity)event.getEntity(), CapabilityHandler.FROZEN_CAPABILITY);
            if (frozenCapability != null) {
                frozenCapability.onFreeze(event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public void onRemovePotionEffect(MobEffectEvent.Remove event) {
        if (event.getEffectInstance() == null) {
            return;
        }
        if (!event.getEntity().m_9236_().m_5776_() && event.getEffectInstance().m_19544_() == EffectHandler.SUNBLOCK.get()) {
            MowziesMobs.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> ((MobEffectEvent.Remove)event).getEntity()), (Object)new MessageSunblockEffect(event.getEntity(), false));
        }
        if (!event.getEntity().m_9236_().m_5776_() && event.getEffectInstance().m_19544_() == EffectHandler.FROZEN.get()) {
            MowziesMobs.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> ((MobEffectEvent.Remove)event).getEntity()), (Object)new MessageFreezeEffect(event.getEntity(), false));
            FrozenCapability.IFrozenCapability frozenCapability = CapabilityHandler.getCapability((Entity)event.getEntity(), CapabilityHandler.FROZEN_CAPABILITY);
            if (frozenCapability != null) {
                frozenCapability.onUnfreeze(event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public void onPotionEffectExpire(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (!event.getEntity().m_9236_().m_5776_() && effectInstance != null && effectInstance.m_19544_() == EffectHandler.SUNBLOCK.get()) {
            MowziesMobs.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> ((MobEffectEvent.Expired)event).getEntity()), (Object)new MessageSunblockEffect(event.getEntity(), false));
        }
        if (!event.getEntity().m_9236_().m_5776_() && effectInstance != null && effectInstance.m_19544_() == EffectHandler.FROZEN.get()) {
            MowziesMobs.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> ((MobEffectEvent.Expired)event).getEntity()), (Object)new MessageFreezeEffect(event.getEntity(), false));
            FrozenCapability.IFrozenCapability frozenCapability = CapabilityHandler.getCapability((Entity)event.getEntity(), CapabilityHandler.FROZEN_CAPABILITY);
            if (frozenCapability != null) {
                frozenCapability.onUnfreeze(event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        LivingEntity living;
        LivingCapability.ILivingCapability capability;
        LivingEntity j2;
        int i;
        int j2;
        float f;
        float f1;
        float f2;
        DamageSource source = event.getSource();
        LivingEntity livingEntity = event.getEntity();
        if (source == null || livingEntity == null) {
            return;
        }
        float damage = event.getAmount();
        if (!source.m_269533_(DamageTypeTags.f_268630_) && livingEntity.m_21023_((MobEffect)EffectHandler.SUNBLOCK.get()) && !source.m_276093_(DamageTypes.f_268724_) && (f2 = (f1 = damage) - (damage = Math.max((f = damage * (float)(j2 = 25 - (i = (livingEntity.m_21124_((MobEffect)EffectHandler.SUNBLOCK.get()).m_19564_() + 2) * 5))) / 25.0f, 0.0f))) > 0.0f && f2 < 3.4028235E37f) {
            if (livingEntity instanceof ServerPlayer) {
                ((ServerPlayer)livingEntity).m_36222_(Stats.f_12934_, Math.round(f2 * 10.0f));
            } else if (source.m_7639_() instanceof ServerPlayer) {
                ((ServerPlayer)source.m_7639_()).m_36222_(Stats.f_12930_, Math.round(f2 * 10.0f));
            }
        }
        if (event.getSource().m_269533_(DamageTypeTags.f_268745_)) {
            event.getEntity().m_6234_((MobEffect)EffectHandler.FROZEN.get());
            MowziesMobs.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> ((LivingHurtEvent)event).getEntity()), (Object)new MessageFreezeEffect(event.getEntity(), false));
            FrozenCapability.IFrozenCapability frozenCapability = CapabilityHandler.getCapability((Entity)event.getEntity(), CapabilityHandler.FROZEN_CAPABILITY);
            if (frozenCapability != null) {
                frozenCapability.onUnfreeze(event.getEntity());
            }
        }
        if ((j2 = event.getEntity()) instanceof Player) {
            Player player = (Player)j2;
            PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)event.getEntity(), CapabilityHandler.PLAYER_CAPABILITY);
            if (playerCapability != null) {
                Power[] powers;
                for (Power power : powers = playerCapability.getPowers()) {
                    power.onTakeDamage(event);
                }
            }
            if (player.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ItemHandler.GEOMANCER_ROBE.get())) {
                this.spawnBoulderNearPlayer(player);
            }
        }
        if (event.getEntity() != null && (capability = CapabilityHandler.getCapability((Entity)(living = event.getEntity()), CapabilityHandler.LIVING_CAPABILITY)) != null) {
            capability.setLastDamage(event.getAmount());
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.player == null) {
            return;
        }
        Player player = event.player;
        PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)player, CapabilityHandler.PLAYER_CAPABILITY);
        if (playerCapability != null) {
            Power[] powers;
            playerCapability.tick(event);
            for (Power power : powers = playerCapability.getPowers()) {
                power.tick(event);
            }
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        if (event.getEntity().m_6844_(EquipmentSlot.FEET).m_150930_((Item)ItemHandler.GEOMANCER_SANDALS.get()) && event.getDistance() > 4.0f) {
            EffectHandler.addOrCombineEffect(event.getEntity(), MobEffects.f_19596_, 60, 0, false, false);
        }
    }

    @SubscribeEvent
    public void onUseItem(LivingEntityUseItemEvent event) {
        LivingEntity living = event.getEntity();
        if (event.isCancelable() && living.m_21023_((MobEffect)EffectHandler.FROZEN.get())) {
            event.setCanceled(true);
            return;
        }
        AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability(living);
        if (abilityCapability != null && event.isCancelable() && abilityCapability.itemUsePrevented(event.getItem())) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (event.isCancelable() && living.m_21023_((MobEffect)EffectHandler.FROZEN.get())) {
                event.setCanceled(true);
                return;
            }
            AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability(living);
            if (abilityCapability != null && event.isCancelable() && abilityCapability.blockBreakingBuildingPrevented()) {
                event.setCanceled(true);
                return;
            }
            if (entity instanceof Player) {
                this.cheatSculptor((Player)entity);
                BlockState block = event.getPlacedBlock();
                if (block.m_60734_() == Blocks.f_50083_ || block.m_60734_() == Blocks.f_50077_ || block.m_60734_() == Blocks.f_50724_ || block.m_60734_() == Blocks.f_50061_ || block.m_60734_() == Blocks.f_50128_) {
                    this.aggroUmvuthana((Player)entity);
                }
            }
        }
    }

    @SubscribeEvent
    public void onFillBucket(FillBucketEvent event) {
        Player living = event.getEntity();
        if (living != null) {
            if (event.isCancelable() && living.m_21023_((MobEffect)EffectHandler.FROZEN.get())) {
                event.setCanceled(true);
                return;
            }
            AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)event.getEntity());
            if (abilityCapability != null && event.isCancelable() && abilityCapability.interactingPrevented()) {
                event.setCanceled(true);
                return;
            }
            if (event.getEmptyBucket().m_41720_() == Items.f_42448_) {
                this.aggroUmvuthana(event.getEntity());
            }
            if (event.getEmptyBucket().m_41720_() == Items.f_42447_) {
                this.cheatSculptor(event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        if (event.isCancelable() && event.getPlayer().m_21023_((MobEffect)EffectHandler.FROZEN.get())) {
            event.setCanceled(true);
            return;
        }
        AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)event.getPlayer());
        if (abilityCapability != null && event.isCancelable() && abilityCapability.blockBreakingBuildingPrevented()) {
            event.setCanceled(true);
            return;
        }
        this.cheatSculptor(event.getPlayer());
        BlockState block = event.getState();
        if (block.m_60734_() == Blocks.f_50074_ || block.m_204336_(BlockTags.f_13090_) || block.m_204336_(BlockTags.f_13106_) || block.m_204336_(BlockTags.f_13035_) || block.m_60734_() == Blocks.f_50295_ || block.m_60734_() == Blocks.f_50301_ || block.m_60734_() == Blocks.f_50644_ || block.m_60734_() == Blocks.f_50473_ || block.m_60734_() == Blocks.f_50630_ || block.m_60734_() == Blocks.f_50683_ || block.m_60734_() == Blocks.f_50183_ || block.m_60734_() == Blocks.f_50310_ || block.m_60734_() == Blocks.f_50081_ || block.m_60734_() == Blocks.f_50087_) {
            this.aggroUmvuthana(event.getPlayer());
        }
    }

    public <T extends Entity> List<T> getEntitiesNearby(Entity startEntity, Class<T> entityClass, double r) {
        return startEntity.m_9236_().m_6443_(entityClass, startEntity.m_20191_().m_82377_(r, r, r), e -> e != startEntity && (double)startEntity.m_20270_(e) <= r);
    }

    private List<LivingEntity> getEntityBaseNearby(LivingEntity user, double distanceX, double distanceY, double distanceZ, double radius) {
        List list = user.m_9236_().m_45933_((Entity)user, user.m_20191_().m_82377_(distanceX, distanceY, distanceZ));
        ArrayList nearEntities = list.stream().filter(entityNeighbor -> entityNeighbor instanceof LivingEntity && (double)user.m_20270_(entityNeighbor) <= radius).map(entityNeighbor -> (LivingEntity)entityNeighbor).collect(Collectors.toCollection(ArrayList::new));
        return nearEntities;
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickEmpty event) {
        if (event.isCancelable() && event.getEntity().m_21023_((MobEffect)EffectHandler.FROZEN.get())) {
            event.setCanceled(true);
            return;
        }
        AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)event.getEntity());
        if (abilityCapability != null && event.isCancelable() && abilityCapability.interactingPrevented()) {
            event.setCanceled(true);
            return;
        }
        Player player = event.getEntity();
        PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)player, CapabilityHandler.PLAYER_CAPABILITY);
        if (playerCapability != null) {
            Power[] powers;
            if (event.getLevel().f_46443_ && player.m_150109_().m_36056_().m_41619_() && player.m_21023_((MobEffect)EffectHandler.SUNS_BLESSING.get())) {
                if (player.m_6144_()) {
                    AbilityHandler.INSTANCE.sendPlayerTryAbilityMessage(event.getEntity(), AbilityHandler.SOLAR_BEAM_ABILITY);
                } else {
                    AbilityHandler.INSTANCE.sendPlayerTryAbilityMessage(event.getEntity(), AbilityHandler.SUNSTRIKE_ABILITY);
                }
            }
            for (Power power : powers = playerCapability.getPowers()) {
                power.onRightClickEmpty(event);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.isCancelable() && event.getEntity().m_21023_((MobEffect)EffectHandler.FROZEN.get())) {
            event.setCanceled(true);
            return;
        }
        AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)event.getEntity());
        if (abilityCapability != null && event.isCancelable() && abilityCapability.interactingPrevented()) {
            event.setCanceled(true);
            return;
        }
        PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)event.getEntity(), CapabilityHandler.PLAYER_CAPABILITY);
        if (playerCapability != null) {
            Power[] powers;
            for (Power power : powers = playerCapability.getPowers()) {
                power.onRightClickEntity(event);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        PlayerCapability.IPlayerCapability playerCapability;
        if (event.isCancelable() && event.getEntity().m_21023_((MobEffect)EffectHandler.FROZEN.get())) {
            event.setCanceled(true);
            return;
        }
        AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)event.getEntity());
        if (abilityCapability != null && event.isCancelable() && abilityCapability.interactingPrevented()) {
            event.setCanceled(true);
            return;
        }
        Player player = event.getEntity();
        if (player.m_9236_().m_8055_(event.getPos()).m_60734_() instanceof ChestBlock) {
            this.aggroUmvuthana(player);
        }
        if ((playerCapability = CapabilityHandler.getCapability((Entity)player, CapabilityHandler.PLAYER_CAPABILITY)) != null) {
            Power[] powers;
            ItemStack item = event.getItemStack();
            if (item.m_41720_() == Items.f_42409_ || item.m_41720_() == Items.f_42693_) {
                this.aggroUmvuthana(player);
            }
            if (event.getSide() == LogicalSide.CLIENT && player.m_150109_().m_36056_().m_41619_() && player.m_21023_((MobEffect)EffectHandler.SUNS_BLESSING.get()) && player.m_9236_().m_8055_(event.getPos()).m_60750_(player.m_9236_(), event.getPos()) == null) {
                if (player.m_6144_()) {
                    AbilityHandler.INSTANCE.sendPlayerTryAbilityMessage(event.getEntity(), AbilityHandler.SOLAR_BEAM_ABILITY);
                } else {
                    AbilityHandler.INSTANCE.sendPlayerTryAbilityMessage(event.getEntity(), AbilityHandler.SUNSTRIKE_ABILITY);
                }
            }
            if (player.m_21205_().m_150930_((Item)ItemHandler.WROUGHT_AXE.get()) && player.m_9236_().m_8055_(event.getPos()).m_60750_(player.m_9236_(), event.getPos()) != null) {
                player.m_36334_();
                return;
            }
            for (Power power : powers = playerCapability.getPowers()) {
                power.onRightClickBlock(event);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        Player player = event.getEntity();
        PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)player, CapabilityHandler.PLAYER_CAPABILITY);
        if (playerCapability != null) {
            Power[] powers;
            for (Power power : powers = playerCapability.getPowers()) {
                power.onLeftClickEmpty(event);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent event) {
        Player player;
        Entity entity;
        LivingEntity entity2 = event.getEntity();
        if (entity2.m_21223_() <= event.getAmount() && entity2.m_21023_((MobEffect)EffectHandler.FROZEN.get())) {
            entity2.m_6234_((MobEffect)EffectHandler.FROZEN.get());
            FrozenCapability.IFrozenCapability frozenCapability = CapabilityHandler.getCapability((Entity)entity2, CapabilityHandler.FROZEN_CAPABILITY);
            MowziesMobs.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> ((LivingDamageEvent)event).getEntity()), (Object)new MessageFreezeEffect(event.getEntity(), false));
            if (frozenCapability != null) {
                frozenCapability.onUnfreeze(entity2);
            }
        }
        if ((double)event.getAmount() > 0.0 && (entity = event.getSource().m_7639_()) instanceof Player && (player = (Player)entity).m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ItemHandler.GEOMANCER_ROBE.get())) {
            this.spawnBoulderNearPlayer(player);
        }
        if (entity2 instanceof Player) {
            EntitySculptor sculptor;
            PlayerCapability.IPlayerCapability playerCapability;
            player = (Player)entity2;
            if (event.getSource() == player.m_269291_().m_268989_() && player.m_21223_() <= event.getAmount() && (playerCapability = CapabilityHandler.getCapability((Entity)player, CapabilityHandler.PLAYER_CAPABILITY)) != null && playerCapability.getTestingSculptor() != null && (sculptor = playerCapability.getTestingSculptor()).getTestingPlayer() == player && player instanceof ServerPlayer) {
                AdvancementHandler.SCULPTOR_FAILURE_TRIGGER.trigger((ServerPlayer)player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickItem event) {
        if (event.isCancelable() && event.getEntity().m_21023_((MobEffect)EffectHandler.FROZEN.get())) {
            event.setCanceled(true);
            return;
        }
        AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)event.getEntity());
        if (abilityCapability != null && event.isCancelable() && abilityCapability.itemUsePrevented(event.getItemStack())) {
            event.setCanceled(true);
            return;
        }
        PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)event.getEntity(), CapabilityHandler.PLAYER_CAPABILITY);
        if (playerCapability != null) {
            Power[] powers;
            for (Power power : powers = playerCapability.getPowers()) {
                power.onRightClickWithItem(event);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        if (event.isCancelable() && player.m_21023_((MobEffect)EffectHandler.FROZEN.get())) {
            event.setCanceled(true);
            return;
        }
        AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)event.getEntity());
        if (abilityCapability != null && event.isCancelable() && abilityCapability.blockBreakingBuildingPrevented()) {
            event.setCanceled(true);
            return;
        }
        PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)player, CapabilityHandler.PLAYER_CAPABILITY);
        if (playerCapability != null) {
            Power[] powers;
            for (Power power : powers = playerCapability.getPowers()) {
                power.onLeftClickBlock(event);
            }
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        PlayerCapability.IPlayerCapability playerCapability;
        LivingEntity entity;
        if (event.getEntity() instanceof LivingEntity && (entity = event.getEntity()).m_21023_((MobEffect)EffectHandler.FROZEN.get()) && entity.m_20096_()) {
            entity.m_20256_(entity.m_20184_().m_82542_(1.0, 0.0, 1.0));
        }
        if (event.getEntity() instanceof Player && (playerCapability = CapabilityHandler.getCapability((Entity)event.getEntity(), CapabilityHandler.PLAYER_CAPABILITY)) != null) {
            Power[] powers;
            for (Power power : powers = playerCapability.getPowers()) {
                power.onJump(event);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(AttackEntityEvent event) {
        if (event.isCancelable() && event.getEntity().m_21023_((MobEffect)EffectHandler.FROZEN.get())) {
            event.setCanceled(true);
            return;
        }
        if (event.getEntity() != null) {
            AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)event.getEntity());
            if (abilityCapability != null && event.isCancelable() && abilityCapability.attackingPrevented()) {
                event.setCanceled(true);
                return;
            }
            PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)event.getEntity(), CapabilityHandler.PLAYER_CAPABILITY);
            if (playerCapability != null) {
                ItemFrame itemFrame;
                Power[] powers;
                playerCapability.setPrevCooledAttackStrength(event.getEntity().m_36403_(0.5f));
                for (Power power : powers = playerCapability.getPowers()) {
                    power.onLeftClickEntity(event);
                }
                if (event.getTarget() instanceof ItemFrame && (itemFrame = (ItemFrame)event.getTarget()).m_31822_().m_41720_() instanceof ItemUmvuthanaMask) {
                    this.aggroUmvuthana(event.getEntity());
                }
                if (event.getTarget() instanceof LeaderSunstrikeImmune) {
                    this.aggroUmvuthana(event.getEntity());
                }
                if (!(event.getTarget() instanceof LivingEntity)) {
                    return;
                }
                if (event.getTarget() instanceof EntityUmvuthanaFollowerToPlayer) {
                    return;
                }
                if (!event.getEntity().m_9236_().m_5776_()) {
                    for (int i = 0; i < playerCapability.getPackSize(); ++i) {
                        EntityUmvuthanaFollowerToPlayer umvuthana = playerCapability.getUmvuthanaPack().get(i);
                        LivingEntity living = (LivingEntity)event.getTarget();
                        if (umvuthana.getMaskType() == MaskType.FAITH || living.m_20147_()) continue;
                        umvuthana.m_6710_(living);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void checkCritEvent(CriticalHitEvent event) {
        ItemStack weapon = event.getEntity().m_21205_();
        Player attacker = event.getEntity();
        PlayerCapability.IPlayerCapability playerCapability = CapabilityHandler.getCapability((Entity)event.getEntity(), CapabilityHandler.PLAYER_CAPABILITY);
        if (playerCapability != null && playerCapability.getPrevCooledAttackStrength() == 1.0f && !weapon.m_41619_() && event.getTarget() instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)event.getTarget();
            if (weapon.m_41720_() instanceof ItemNagaFangDagger) {
                Vec3 vecBetween;
                Vec3 lookDir = new Vec3(target.m_20154_().f_82479_, 0.0, target.m_20154_().f_82481_).m_82541_();
                double dot = lookDir.m_82526_(vecBetween = new Vec3(target.m_20185_() - event.getEntity().m_20185_(), 0.0, target.m_20189_() - event.getEntity().m_20189_()).m_82541_());
                if (dot > 0.7) {
                    event.setResult(Event.Result.ALLOW);
                    event.setDamageModifier(((Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.NAGA_FANG_DAGGER.backstabDamageMultiplier.get()).floatValue());
                    target.m_5496_((SoundEvent)MMSounds.ENTITY_NAGA_ACID_HIT.get(), 1.0f, 1.2f);
                    AbilityHandler.INSTANCE.sendAbilityMessage(attacker, AbilityHandler.BACKSTAB_ABILITY);
                    if (target.m_9236_().m_5776_() && target != null && attacker != null) {
                        double life;
                        double value;
                        Vec3 particlePos;
                        int i;
                        Vec3 ringOffset = attacker.m_20154_().m_82490_((double)(-target.m_20205_() / 2.0f));
                        ParticleRotation.OrientVector rotation = new ParticleRotation.OrientVector(ringOffset);
                        Vec3 pos = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0).m_82549_(ringOffset);
                        AdvancedParticleBase.spawnParticle(target.m_9236_(), (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING_SPARKS.get()), pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 0.0, 0.0, 0.0, rotation, 3.5, 0.83f, 1.0, 0.39f, 1.0, 1.0, 6.0, false, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, new ParticleComponent.KeyTrack(new float[]{1.0f, 1.0f, 0.0f}, new float[]{0.0f, 0.5f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(0.0f, 15.0f), false)});
                        RandomSource rand = attacker.m_9236_().m_213780_();
                        float explodeSpeed = 2.5f;
                        for (i = 0; i < 10; ++i) {
                            particlePos = new Vec3((double)rand.m_188501_() * 0.25, 0.0, 0.0);
                            particlePos = particlePos.m_82524_((float)((double)(rand.m_188501_() * 2.0f) * Math.PI));
                            particlePos = particlePos.m_82496_((float)((double)(rand.m_188501_() * 2.0f) * Math.PI));
                            value = rand.m_188501_() * 0.1f;
                            life = rand.m_188501_() * 8.0f + 15.0f;
                            ParticleVanillaCloudExtended.spawnVanillaCloud(target.m_9236_(), pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), particlePos.f_82479_ * (double)explodeSpeed, particlePos.f_82480_ * (double)explodeSpeed, particlePos.f_82481_ * (double)explodeSpeed, 1.0, 0.25 + value, 0.75 + value, 0.25 + value, 0.6, life);
                        }
                        for (i = 0; i < 10; ++i) {
                            particlePos = new Vec3((double)rand.m_188501_() * 0.25, 0.0, 0.0);
                            particlePos = particlePos.m_82524_((float)((double)(rand.m_188501_() * 2.0f) * Math.PI));
                            particlePos = particlePos.m_82496_((float)((double)(rand.m_188501_() * 2.0f) * Math.PI));
                            value = rand.m_188501_() * 0.1f;
                            life = rand.m_188501_() * 2.5f + 5.0f;
                            AdvancedParticleBase.spawnParticle(target.m_9236_(), (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.PIXEL.get()), pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), particlePos.f_82479_ * (double)explodeSpeed, particlePos.f_82480_ * (double)explodeSpeed, particlePos.f_82481_ * (double)explodeSpeed, true, 0.0, 0.0, 0.0, 0.0, 3.0, 0.07 + value, 0.25 + value, 0.07 + value, 1.0, 0.6, life * 0.95, false, true);
                        }
                        for (i = 0; i < 6; ++i) {
                            particlePos = new Vec3((double)rand.m_188501_() * 0.25, 0.0, 0.0);
                            particlePos = particlePos.m_82524_((float)((double)(rand.m_188501_() * 2.0f) * Math.PI));
                            particlePos = particlePos.m_82496_((float)((double)(rand.m_188501_() * 2.0f) * Math.PI));
                            value = rand.m_188501_() * 0.1f;
                            life = rand.m_188501_() * 5.0f + 10.0f;
                            AdvancedParticleBase.spawnParticle(target.m_9236_(), (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.BUBBLE.get()), pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), particlePos.f_82479_ * (double)explodeSpeed, particlePos.f_82480_ * (double)explodeSpeed, particlePos.f_82481_ * (double)explodeSpeed, true, 0.0, 0.0, 0.0, 0.0, 3.0, 0.25 + value, 0.75 + value, 0.25 + value, 1.0, 0.6, life * 0.95, false, true);
                        }
                    }
                }
            } else if (weapon.m_41720_() instanceof ItemSpear && target instanceof Animal && target.m_21233_() <= 30.0f && (double)attacker.m_9236_().m_213780_().m_188501_() <= 0.334) {
                event.setResult(Event.Result.ALLOW);
                event.setDamageModifier(400.0f);
            }
        }
    }

    @SubscribeEvent
    public void onEquipmentChanged(LivingEquipmentChangeEvent event) {
        LivingEntity equipper = event.getEntity();
        ItemStack weapon = equipper.m_6844_(EquipmentSlot.MAINHAND);
        AttributeInstance attributeinstance = equipper.m_21051_(Attributes.f_22281_);
        if (attributeinstance != null && (event.getSlot() == EquipmentSlot.HEAD || event.getSlot() == EquipmentSlot.MAINHAND)) {
            attributeinstance.m_22130_(ATTACK_MODIFIER_BEADS);
            if (equipper.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ItemHandler.GEOMANCER_BEADS.get()) && (weapon.m_204117_(TagHandler.HAND_WEAPONS) || weapon.m_41619_())) {
                attributeinstance.m_22118_(ATTACK_MODIFIER_BEADS);
            }
        }
    }

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(new ResourceLocation("mowziesmobs", "frozen"), (ICapabilityProvider)new FrozenCapability.FrozenProvider());
            event.addCapability(new ResourceLocation("mowziesmobs", "last_damage"), (ICapabilityProvider)new LivingCapability.LivingProvider());
            event.addCapability(new ResourceLocation("mowziesmobs", "ability"), (ICapabilityProvider)new AbilityCapability.AbilityProvider());
        }
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("mowziesmobs", "player"), (ICapabilityProvider)new PlayerCapability.PlayerProvider());
        }
    }

    @SubscribeEvent
    public void onRideEntity(EntityMountEvent event) {
        if (event.getEntityMounting() instanceof EntityUmvuthi || event.getEntityMounting() instanceof EntityFrostmaw || event.getEntityMounting() instanceof EntityWroughtnaut || event.getEntityMounting() instanceof EntitySculptor) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        List<MowzieEntity> mobs = this.getEntitiesNearby((Entity)event.getEntity(), MowzieEntity.class, 40.0);
        for (MowzieEntity mob : mobs) {
            if (!mob.resetHealthOnPlayerRespawn()) continue;
            mob.m_21153_(mob.m_21233_());
        }
    }

    @SubscribeEvent
    public void onSpawnPlacementCheck(MobSpawnEvent.SpawnPlacementCheck event) {
        StructureManager structureManager = event.getLevel().m_6018_().m_215010_();
        Structure structure = (Structure)structureManager.m_220521_().m_175515_(Registries.f_256944_).m_7745_(StructureTypeHandler.MONASTERY.getId());
        if (event.getEntityType().m_20674_() == MobCategory.MONSTER && structure != null && structureManager.m_220494_(event.getPos(), structure).m_73603_()) {
            BlockState ground = event.getLevel().m_8055_(event.getPos().m_7495_());
            if (event.getLevel().m_45527_(event.getPos()) && (ground.m_60713_(Blocks.f_50745_) || ground.m_60713_(Blocks.f_50403_) || ground.m_60713_(Blocks.f_50373_))) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void onFurnaceFuelBurnTimeEvent(FurnaceFuelBurnTimeEvent event) {
        if (event.getItemStack().m_150930_(((Block)BlockHandler.CLAWED_LOG.get()).m_5456_()) || event.getItemStack().m_150930_(((Block)BlockHandler.PAINTED_ACACIA.get()).m_5456_())) {
            event.setBurnTime(300);
        } else if (event.getItemStack().m_150930_(((Block)BlockHandler.PAINTED_ACACIA_SLAB.get()).m_5456_())) {
            event.setBurnTime(150);
        } else if (event.getItemStack().m_150930_(((Block)BlockHandler.THATCH.get()).m_5456_())) {
            event.setBurnTime(100);
        }
    }

    private void aggroUmvuthana(Player player) {
        List<EntityUmvuthi> barakos = this.getEntitiesNearby((Entity)player, EntityUmvuthi.class, 50.0);
        for (EntityUmvuthi barako : barakos) {
            if (barako.m_5448_() != null && barako.m_5448_() instanceof Player || player.m_7500_() || player.m_5833_() || !(player.m_20183_().m_123331_((Vec3i)barako.m_21534_()) < 900.0) || !barako.m_6779_((LivingEntity)player)) continue;
            barako.setMisbehavedPlayerId(player.m_20148_());
        }
        List<EntityUmvuthanaMinion> barakoas = this.getEntitiesNearby((Entity)player, EntityUmvuthanaMinion.class, 50.0);
        for (EntityUmvuthanaMinion barakoa : barakoas) {
            if (barakoa.m_5448_() != null && barakoa.m_5448_() instanceof Player || !(player.m_20183_().m_123331_((Vec3i)barakoa.m_21534_()) < 900.0) || !barakoa.m_6779_((LivingEntity)player)) continue;
            barakoa.setMisbehavedPlayerId(player.m_20148_());
        }
    }

    private void cheatSculptor(Player player) {
        List sculptors = player.m_9236_().m_6443_(EntitySculptor.class, player.m_20191_().m_82377_((double)(EntitySculptor.TEST_RADIUS + 3), (double)EntitySculptor.TEST_HEIGHT, (double)(EntitySculptor.TEST_RADIUS + 3)), EntitySculptor::isTesting);
        for (EntitySculptor sculptor : sculptors) {
            sculptor.playerCheated();
        }
    }

    private void spawnBoulderNearPlayer(Player player) {
        if ((double)player.m_217043_().m_188501_() > 0.5) {
            return;
        }
        int i = Mth.m_14107_((double)player.m_20185_());
        int j = Mth.m_14107_((double)player.m_20186_());
        int k = Mth.m_14107_((double)player.m_20189_());
        for (int l = 0; l < 10; ++l) {
            int searchDist;
            double radius = Math.pow(player.m_217043_().m_188501_(), 0.5) * 10.0 + 3.0;
            double angle = (double)player.m_217043_().m_188501_() * Math.PI * 2.0;
            int i1 = i + (int)(Math.cos(angle) * radius);
            int j1 = j + Mth.m_216271_((RandomSource)player.m_217043_(), (int)0, (int)15) * Mth.m_216271_((RandomSource)player.m_217043_(), (int)-1, (int)1);
            int k1 = k + (int)(Math.sin(angle) * radius);
            BlockPos spawnBoulderPos = new BlockPos(i1, j1, k1);
            BlockState state = player.m_9236_().m_8055_(spawnBoulderPos);
            int maxSearchDist = 10;
            for (searchDist = 0; state.m_247087_() && searchDist < maxSearchDist; ++searchDist) {
                spawnBoulderPos = spawnBoulderPos.m_7495_();
                state = player.m_9236_().m_8055_(spawnBoulderPos);
            }
            for (searchDist = 0; !state.m_247087_() && searchDist < maxSearchDist; ++searchDist) {
                spawnBoulderPos = spawnBoulderPos.m_7494_();
                state = player.m_9236_().m_8055_(spawnBoulderPos);
            }
            spawnBoulderPos = spawnBoulderPos.m_7495_();
            state = player.m_9236_().m_8055_(spawnBoulderPos);
            if (!EffectGeomancy.isBlockUseable(state)) continue;
            EntityBoulderProjectile boulder = new EntityBoulderProjectile((EntityType<? extends EntityBoulderProjectile>)((EntityType)EntityHandler.BOULDER_PROJECTILE.get()), player.m_9236_(), (LivingEntity)player, state, spawnBoulderPos, EntityGeomancyBase.GeomancyTier.SMALL);
            boulder.m_6034_((float)spawnBoulderPos.m_123341_() + 0.5f, spawnBoulderPos.m_123342_() + 2, (float)spawnBoulderPos.m_123343_() + 0.5f);
            if (player.m_9236_().f_46443_ || !boulder.checkCanSpawn()) continue;
            player.m_9236_().m_7967_((Entity)boulder);
            break;
        }
    }
}

