/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle;

import com.bobmowzie.mowziesmobs.client.render.MMRenderType;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ParticleCloud
extends TextureSheetParticle {
    private final float red;
    private final float green;
    private final float blue;
    private final float scale;
    private final EnumCloudBehavior behavior;
    private final float airDrag;

    public ParticleCloud(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, double r, double g, double b, double scale, int duration, EnumCloudBehavior behavior, double airDrag) {
        super(world, x, y, z);
        this.scale = (float)scale * 0.5f * 0.1f;
        this.f_107225_ = duration;
        this.f_107215_ = vx * 0.5;
        this.f_107216_ = vy * 0.5;
        this.f_107217_ = vz * 0.5;
        this.red = (float)r;
        this.green = (float)g;
        this.blue = (float)b;
        this.behavior = behavior;
        this.f_107231_ = this.f_107204_ = (float)((double)this.f_107223_.m_188503_(4) * Math.PI / 2.0);
        this.airDrag = (float)airDrag;
    }

    public ParticleRenderType m_7556_() {
        return MMRenderType.PARTICLE_SHEET_TRANSLUCENT_NO_DEPTH;
    }

    public void m_5989_() {
        super.m_5989_();
        this.f_107215_ *= (double)this.airDrag;
        this.f_107216_ *= (double)this.airDrag;
        this.f_107217_ *= (double)this.airDrag;
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        float var = ((float)this.f_107224_ + partialTicks) / (float)this.f_107225_;
        this.f_107230_ = 0.2f * (float)(1.0 - Math.exp(5.0f * (var - 1.0f)) - Math.pow(2000.0, -var));
        if ((double)this.f_107230_ < 0.01) {
            this.f_107230_ = 0.01f;
        }
        this.f_107663_ = this.behavior == EnumCloudBehavior.SHRINK ? this.scale * (1.0f - 0.7f * var + 0.3f) : (this.behavior == EnumCloudBehavior.GROW ? this.scale * (0.7f * var + 0.3f) : this.scale);
        super.m_5744_(buffer, renderInfo, partialTicks);
    }

    public static enum EnumCloudBehavior {
        SHRINK,
        GROW,
        CONSTANT;

    }

    public static class CloudData
    implements ParticleOptions {
        public static final ParticleOptions.Deserializer<CloudData> DESERIALIZER = new ParticleOptions.Deserializer<CloudData>(){

            public CloudData fromCommand(ParticleType<CloudData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                float r = (float)reader.readDouble();
                reader.expect(' ');
                float g = (float)reader.readDouble();
                reader.expect(' ');
                float b = (float)reader.readDouble();
                reader.expect(' ');
                float scale = (float)reader.readDouble();
                reader.expect(' ');
                int duration = reader.readInt();
                reader.expect(' ');
                float airDrag = (float)reader.readDouble();
                return new CloudData(particleTypeIn, r, g, b, scale, duration, EnumCloudBehavior.CONSTANT, airDrag);
            }

            public CloudData fromNetwork(ParticleType<CloudData> particleTypeIn, FriendlyByteBuf buffer) {
                return new CloudData(particleTypeIn, buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readInt(), EnumCloudBehavior.CONSTANT, buffer.readFloat());
            }
        };
        private final ParticleType<CloudData> type;
        private final float r;
        private final float g;
        private final float b;
        private final float scale;
        private final int duration;
        private final EnumCloudBehavior behavior;
        private final float airDrag;

        public CloudData(ParticleType<CloudData> type, float r, float g, float b, float scale, int duration, EnumCloudBehavior behavior, float airDrag) {
            this.type = type;
            this.r = r;
            this.g = g;
            this.b = b;
            this.scale = scale;
            this.behavior = behavior;
            this.airDrag = airDrag;
            this.duration = duration;
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.r);
            buffer.writeFloat(this.g);
            buffer.writeFloat(this.b);
            buffer.writeFloat(this.scale);
            buffer.writeInt(this.duration);
            buffer.writeFloat(this.airDrag);
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %d %.2f", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.scale), this.duration, Float.valueOf(this.airDrag));
        }

        public ParticleType<CloudData> m_6012_() {
            return this.type;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getR() {
            return this.r;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getG() {
            return this.g;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getB() {
            return this.b;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getScale() {
            return this.scale;
        }

        @OnlyIn(value=Dist.CLIENT)
        public EnumCloudBehavior getBehavior() {
            return this.behavior;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getDuration() {
            return this.duration;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getAirDrag() {
            return this.airDrag;
        }

        public static Codec<CloudData> CODEC(ParticleType<CloudData> particleType) {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.FLOAT.fieldOf("r").forGetter(CloudData::getR), (App)Codec.FLOAT.fieldOf("g").forGetter(CloudData::getG), (App)Codec.FLOAT.fieldOf("b").forGetter(CloudData::getB), (App)Codec.FLOAT.fieldOf("scale").forGetter(CloudData::getScale), (App)Codec.STRING.fieldOf("behavior").forGetter(cloudData -> cloudData.getBehavior().toString()), (App)Codec.INT.fieldOf("duration").forGetter(CloudData::getDuration), (App)Codec.FLOAT.fieldOf("airdrag").forGetter(CloudData::getAirDrag)).apply((Applicative)codecBuilder, (r, g, b, scale, behavior, duration, airdrag) -> new CloudData(particleType, r.floatValue(), g.floatValue(), b.floatValue(), scale.floatValue(), (int)duration, EnumCloudBehavior.valueOf(behavior), airdrag.floatValue())));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class CloudFactory
    implements ParticleProvider<CloudData> {
        private final SpriteSet spriteSet;

        public CloudFactory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(CloudData typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleCloud particleCloud = new ParticleCloud(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.getR(), typeIn.getG(), typeIn.getB(), typeIn.getScale(), typeIn.getDuration(), typeIn.getBehavior(), typeIn.getAirDrag());
            particleCloud.m_108339_(this.spriteSet);
            particleCloud.m_107253_(typeIn.getR(), typeIn.getG(), typeIn.getB());
            return particleCloud;
        }
    }
}

