/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.jason13.timeondisplay.display;

import fabric.net.jason13.timeondisplay.util.toml.Toml;
import fabric.net.jason13.timeondisplay.util.toml.TomlWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class FabricConfig {
    private static final String CONFIG_PATH = "config/timeondisplay-client.toml";
    public static final File CONFIG_FILE = new File("config/timeondisplay-client.toml");

    public static boolean configFound() {
        return CONFIG_FILE.isFile() && !CONFIG_FILE.isDirectory();
    }

    public static Toml readTomlFromFile() {
        return new Toml().read(CONFIG_FILE);
    }

    public static void initialize() {
        TomlWriter tomlWriter = new TomlWriter();
        ConfigObject dataObject = new ConfigObject();
        dataObject.setEnable(true);
        dataObject.setSystemTimeOnly(false);
        dataObject.setDisplayClockIcons(true);
        dataObject.setDisplay24Hour(true);
        dataObject.setDisplayLocation("lower-left");
        dataObject.setDisplayIcon("");
        try {
            FileWriter fileWriter = new FileWriter(CONFIG_PATH);
            tomlWriter.write((Object)dataObject, fileWriter);
            fileWriter.close();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    private static class ConfigObject {
        private boolean ENABLE;
        private boolean SYSTEM_TIME_ONLY;
        private boolean DISPLAY_CLOCK_ICONS;
        private boolean DISPLAY_24_HOUR;
        private String DISPLAY_LOCATION;
        private String DISPLAY_ICON;

        private ConfigObject() {
        }

        public void setEnable(boolean enable) {
            this.ENABLE = enable;
        }

        public void setSystemTimeOnly(boolean systemTimeOnly) {
            this.SYSTEM_TIME_ONLY = systemTimeOnly;
        }

        public void setDisplayClockIcons(boolean displayClockIcons) {
            this.DISPLAY_CLOCK_ICONS = displayClockIcons;
        }

        public void setDisplay24Hour(boolean display24Hour) {
            this.DISPLAY_24_HOUR = display24Hour;
        }

        public void setDisplayLocation(String displayLocation) {
            this.DISPLAY_LOCATION = displayLocation;
        }

        public void setDisplayIcon(String displayIcon) {
            this.DISPLAY_ICON = displayIcon;
        }

        public boolean getEnable() {
            return this.ENABLE;
        }

        public boolean getSystemTimeOnly() {
            return this.SYSTEM_TIME_ONLY;
        }

        public boolean getDisplayClockIcons() {
            return this.DISPLAY_CLOCK_ICONS;
        }

        public boolean getDisplay24Hour() {
            return this.DISPLAY_24_HOUR;
        }

        public String getDisplayLocation() {
            return this.DISPLAY_LOCATION;
        }

        public String getDisplayIcon() {
            return this.DISPLAY_ICON;
        }
    }
}

