/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item.building_tool.modes;

import com.legacy.structure_gel.core.item.building_tool.ActionHistory;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.legacy.structure_gel.core.util.SGText;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Style;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class FloodTool
extends BuildingToolMode {
    public FloodTool(String name, int modelIndex) {
        super(name, modelIndex);
    }

    @Override
    public void onLeftClick(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
        if (level.f_46443_) {
            return;
        }
        WeightedRandomList<WeightedEntry.Wrapper<BlockState>> pallete = BuildingToolItem.getPallete(stack);
        if (!pallete.m_146337_()) {
            int radius;
            boolean extendDown = BuildingToolItem.getProperty(stack, ToolModeProperty.EXTEND_DOWN).value();
            ToolModeProperty.Replace replace = BuildingToolItem.getProperty(stack, ToolModeProperty.REPLACE_AIR_LIQUID);
            Set<BlockPos> poses = FloodTool.getFloodPositions(level, clickedPos, clickedFace, replace, radius = BuildingToolItem.getProperty(stack, ToolModeProperty.LARGE_RADIUS).intValue());
            if (poses.isEmpty()) {
                return;
            }
            ActionHistory.ActionBuilder action = ActionHistory.newAction();
            int dist = extendDown ? 100 : 1;
            BlockState air = Blocks.f_50016_.m_49966_();
            int total = 0;
            for (BlockPos pos : poses) {
                BlockPos.MutableBlockPos mutPos = pos.m_122032_();
                while (replace.shouldReplace(level, air, (BlockPos)mutPos) && pos.m_123342_() - mutPos.m_123342_() < dist) {
                    Optional opState = pallete.m_216829_(level.f_46441_);
                    if (opState.isPresent() && this.setBlock(level, mutPos.m_7949_(), (BlockState)((WeightedEntry.Wrapper)opState.get()).m_146310_(), action)) {
                        ++total;
                    }
                    mutPos.m_122173_(Direction.DOWN);
                }
            }
            ActionHistory.get(player).add(level, action);
            FloodTool.sendPlaceMessage(player, replace, total, pallete);
        } else {
            BuildingToolMode.sendMessage(player, "info.structure_gel.building_tool.message.missing_state", Style.f_131099_.m_131140_(ChatFormatting.RED), new Object[0]);
        }
    }

    @Override
    public Object[] getDescArgs() {
        Options options = Minecraft.m_91087_().f_91066_;
        String middleClick = SGText.keybindString(options.f_92097_);
        String leftClick = SGText.keybindString(options.f_92096_);
        String rightClick = SGText.keybindString(options.f_92095_);
        return new Object[]{middleClick, leftClick, rightClick};
    }

    @Override
    public void addProperties(List<ToolModeProperty<?>> properties) {
        super.addProperties(properties);
        properties.add(ToolModeProperty.EXTEND_DOWN);
        properties.add(ToolModeProperty.LARGE_RADIUS);
        properties.add(ToolModeProperty.REPLACE_AIR_LIQUID);
    }

    @Override
    public boolean hasBlockPalette() {
        return true;
    }

    public static Set<BlockPos> getFloodPositions(Level level, BlockPos clickedPos, Direction clickedFace, ToolModeProperty.Replace replace, int radius) {
        BlockPos startPos = clickedPos.m_121945_(clickedFace);
        if (!replace.shouldReplace(level, level.m_8055_(startPos), startPos)) {
            return Collections.emptySet();
        }
        HashSet<BlockPos> allPositions = new HashSet<BlockPos>();
        HashSet<BlockPos> posesToSearch = new HashSet<BlockPos>();
        posesToSearch.add(startPos);
        Direction[] dirs = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
        while (!posesToSearch.isEmpty()) {
            HashSet<BlockPos> newPoses = new HashSet<BlockPos>();
            for (BlockPos pos : posesToSearch) {
                if (pos.m_123333_((Vec3i)startPos) > radius) continue;
                allPositions.add(pos);
                for (Direction dir : dirs) {
                    BlockPos offset = pos.m_121945_(dir);
                    if (allPositions.contains(offset) || !replace.shouldReplace(level, level.m_8055_(offset), offset)) continue;
                    newPoses.add(offset);
                }
            }
            posesToSearch = newPoses;
        }
        return allPositions;
    }
}

