/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl.movement;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.ParagliderAPI;
import tictim.paraglider.api.Serde;
import tictim.paraglider.api.item.Paraglider;
import tictim.paraglider.api.movement.ParagliderPlayerStates;
import tictim.paraglider.api.movement.PlayerState;
import tictim.paraglider.api.stamina.Stamina;
import tictim.paraglider.api.vessel.VesselContainer;
import tictim.paraglider.config.Cfg;
import tictim.paraglider.contents.ParagliderAdvancements;
import tictim.paraglider.impl.movement.PlayerMovement;
import tictim.paraglider.impl.movement.PlayerMovementValues;
import tictim.paraglider.impl.movement.StaminaReductionLogicHandler;
import tictim.paraglider.impl.vessel.SimpleVesselContainer;
import tictim.paraglider.network.ParagliderNetwork;

public class ServerPlayerMovement
extends PlayerMovement
implements Serde {
    private boolean resync;
    private boolean heartContainerChanged = true;
    private boolean staminaVesselChanged = true;
    private boolean movementChanged;
    private int panicParaglidingDelay = 10;
    private boolean panicParagliding = false;
    private double prevY;
    private double accumulatedFallDistance;
    private double prevStaminaReduction;

    public ServerPlayerMovement(@NotNull ServerPlayer player) {
        super((Player)player);
    }

    @NotNull
    public ServerPlayer player() {
        return (ServerPlayer)super.player();
    }

    @Override
    @NotNull
    protected Stamina createStamina() {
        return ParagliderAPI.staminaFactory().createServerInstance(this.player());
    }

    @Override
    @NotNull
    protected VesselContainer createVesselContainer() {
        return new SimpleVesselContainer((Player)this.player()){

            @Override
            protected void onChange(@NotNull SimpleVesselContainer.ActionType actionType, int change) {
                switch (actionType) {
                    case HEART_CONTAINER: {
                        ServerPlayerMovement.this.markHeartContainerChanged();
                        break;
                    }
                    case STAMINA_VESSEL: {
                        ServerPlayerMovement.this.markStaminaVesselChanged();
                    }
                }
            }
        };
    }

    @Override
    public void update() {
        boolean vesselsChanged;
        boolean resync = this.resync;
        this.resync = false;
        boolean bl = vesselsChanged = this.heartContainerChanged || this.staminaVesselChanged;
        if (this.heartContainerChanged) {
            double delta;
            double value = Cfg.get().additionalMaxHealth(this.vessels().heartContainer());
            AttributeInstance attrib = this.player().m_21051_(Attributes.f_22276_);
            if (attrib != null) {
                AttributeModifier prev = attrib.m_22111_(PlayerMovementValues.HEART_CONTAINER_UUID);
                if (prev != null) {
                    attrib.m_22130_(prev);
                }
                if (value != 0.0) {
                    attrib.m_22125_(new AttributeModifier(PlayerMovementValues.HEART_CONTAINER_UUID, "Heart Containers", value, AttributeModifier.Operation.ADDITION));
                }
                delta = value - (prev != null ? prev.m_22218_() : 0.0);
            } else {
                delta = 0.0;
            }
            this.player().m_21153_(Math.min(this.player().m_21233_(), this.player().m_21223_() + Math.max(0.0f, (float)delta)));
            this.heartContainerChanged = false;
        }
        if (this.staminaVesselChanged) {
            this.stamina().setStamina(Math.min(this.stamina().stamina(), this.stamina().maxStamina()));
            this.staminaVesselChanged = false;
        }
        this.accumulatedFallDistance = this.player().m_20096_() || this.player().m_20186_() > this.prevY ? 0.0 : (this.accumulatedFallDistance += this.prevY - this.player().m_20186_());
        PlayerState prevState = this.state();
        this.setState(ParagliderMod.instance().getPlayerConnectionMap().evaluate(ParagliderMod.instance().getLocalPlayerStateMap(), (Player)this.player(), this.state(), this.player().m_7500_() || !this.stamina().isDepleted() || this.canDoPanicParagliding(), this.accumulatedFallDistance));
        double d = this.staminaReductionRate = this.state().staminaDelta() != 0 ? StaminaReductionLogicHandler.getReductionRate((Player)this.player(), this.state()) : 0.0;
        if (this.prevStaminaReduction != this.staminaReductionRate) {
            this.markMovementChanged();
        }
        if (!prevState.equals(this.state())) {
            this.markMovementChanged();
        }
        this.stamina().update(this);
        if (!this.player().m_7500_() && this.stamina().isDepleted()) {
            ParagliderUtils.addExhaustion((LivingEntity)this.player());
        } else {
            ParagliderUtils.removeExhaustion((LivingEntity)this.player());
        }
        this.applyMovement();
        if (resync || this.movementChanged) {
            ParagliderNetwork.get().syncMovement(this.player(), this.state().id(), this.stamina().stamina(), this.stamina().isDepleted(), this.recoveryDelay(), this.staminaReductionRate());
            this.movementChanged = false;
        }
        if (resync || vesselsChanged) {
            ParagliderNetwork.get().syncVessels(this.player(), this.stamina().stamina(), this.vessels().heartContainer(), this.vessels().staminaVessel());
            if (vesselsChanged && Cfg.get().maxHeartContainers() <= this.vessels().heartContainer() && Cfg.get().maxStaminaVessels() <= this.vessels().staminaVessel()) {
                ParagliderUtils.giveAdvancement(this.player(), ParagliderAdvancements.ALL_VESSELS, "code_triggered");
            }
        }
        this.prevY = this.player().m_20186_();
        this.prevStaminaReduction = this.staminaReductionRate;
        for (int i = 0; i < this.player().m_150109_().m_6643_(); ++i) {
            ItemStack stack = this.player().m_150109_().m_8020_(i);
            Item item = stack.m_41720_();
            if (!(item instanceof Paraglider)) continue;
            Paraglider p = (Paraglider)item;
            p.setParagliding(stack, i == this.player().m_150109_().f_35977_ && this.state().has(ParagliderPlayerStates.Flags.FLAG_PARAGLIDING));
        }
    }

    @Override
    protected void applyMovement() {
        super.applyMovement();
        boolean paragliding = this.state().has(ParagliderPlayerStates.Flags.FLAG_PARAGLIDING);
        if (paragliding) {
            this.player().f_8906_.f_9737_ = 0;
            ItemStack stack = this.player().m_21205_();
            Item item = stack.m_41720_();
            if (item instanceof Paraglider) {
                Paraglider p = (Paraglider)item;
                p.damageParaglider((Player)this.player(), stack);
            }
        }
        if (!this.player().m_7500_() && this.stamina().isDepleted()) {
            if (this.panicParaglidingDelay > 0) {
                if (!this.player().m_20096_()) {
                    --this.panicParaglidingDelay;
                } else {
                    this.resetPanicParaglidingState();
                }
            } else if (this.panicParagliding) {
                this.panicParaglidingDelay = 30;
                this.panicParagliding = false;
            } else if (paragliding) {
                this.panicParaglidingDelay = 15;
                this.panicParagliding = true;
            }
        }
    }

    public boolean canDoPanicParagliding() {
        return this.panicParagliding || this.panicParaglidingDelay <= 0;
    }

    public void resetPanicParaglidingState() {
        this.panicParaglidingDelay = 10;
        this.panicParagliding = false;
    }

    public void markForSync() {
        this.resync = true;
    }

    public void markHeartContainerChanged() {
        this.heartContainerChanged = true;
    }

    public void markStaminaVesselChanged() {
        this.staminaVesselChanged = true;
    }

    public void markMovementChanged() {
        this.movementChanged = true;
    }

    @Override
    public void read(@NotNull CompoundTag tag) {
        if (tag.m_128425_("stamina", 3)) {
            VesselContainer tag2;
            Serde serde;
            Stamina stamina = this.stamina();
            if (stamina instanceof Serde) {
                serde = (Serde)((Object)stamina);
                tag2 = new CompoundTag();
                tag2.m_128405_("stamina", tag.m_128451_("stamina"));
                tag2.m_128379_("depleted", tag.m_128471_("depleted"));
                serde.read((CompoundTag)tag2);
            }
            if ((tag2 = this.vessels()) instanceof Serde) {
                serde = (Serde)((Object)tag2);
                tag2 = new CompoundTag();
                tag2.m_128405_("heartContainers", tag.m_128451_("heartContainers"));
                tag2.m_128405_("staminaVessels", tag.m_128451_("staminaVessels"));
                tag2.m_128405_("essences", tag.m_128451_("essence"));
                serde.read((CompoundTag)tag2);
            }
        } else {
            Serde serde;
            Object object = this.stamina();
            if (object instanceof Serde) {
                serde = (Serde)object;
                serde.read(tag.m_128469_("stamina"));
            }
            if ((object = this.vessels()) instanceof Serde) {
                serde = (Serde)object;
                serde.read(tag.m_128469_("vessels"));
            }
        }
        this.setRecoveryDelay(tag.m_128451_("recoveryDelay"));
        this.panicParaglidingDelay = tag.m_128451_("panicParaglidingDelay");
        this.panicParagliding = tag.m_128471_("panicParagliding");
        this.heartContainerChanged = true;
        this.staminaVesselChanged = true;
    }

    @Override
    @NotNull
    public CompoundTag write() {
        Serde serde;
        CompoundTag tag = new CompoundTag();
        Object object = this.stamina();
        if (object instanceof Serde) {
            serde = (Serde)object;
            tag.m_128365_("stamina", (Tag)Objects.requireNonNull(serde.write(), this.stamina() + "#write() returned null!"));
        }
        if ((object = this.vessels()) instanceof Serde) {
            serde = (Serde)object;
            tag.m_128365_("vessels", (Tag)Objects.requireNonNull(serde.write(), this.vessels() + "#write() returned null!"));
        }
        tag.m_128405_("recoveryDelay", this.recoveryDelay());
        tag.m_128405_("panicParaglidingDelay", this.panicParaglidingDelay);
        tag.m_128379_("panicParagliding", this.panicParagliding);
        return tag;
    }
}

