/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.bargain.preview;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.api.bargain.DemandPreview;

public record QuantifiedIngredient(@NotNull Ingredient ingredient, @Range(from=0L, to=0x7FFFFFFFL) int quantity) implements Predicate<ItemStack>,
DemandPreview
{
    public QuantifiedIngredient(@NotNull Ingredient ingredient, int quantity) {
        this.ingredient = Objects.requireNonNull(ingredient);
        this.quantity = Math.max(0, quantity);
    }

    public QuantifiedIngredient(@NotNull JsonObject obj) {
        this(Ingredient.m_43917_((JsonElement)obj.get("ingredient")), Math.max(1, GsonHelper.m_13824_((JsonObject)obj, (String)"quantity", (int)1)));
    }

    @NotNull
    public static QuantifiedIngredient read(@NotNull FriendlyByteBuf buffer) {
        return new QuantifiedIngredient(Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.m_130242_());
    }

    @Override
    public boolean test(ItemStack itemStack) {
        return this.ingredient.test(itemStack);
    }

    @Override
    @NotNull
    public @NotNull @Unmodifiable List<@NotNull ItemStack> preview() {
        return List.of(this.ingredient.m_43908_());
    }

    @Override
    public int count(@NotNull Player player) {
        int count = 0;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || !this.ingredient.test(stack)) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull Component> getTooltip(int previewIndex) {
        ItemStack[] items = this.ingredient.m_43908_();
        if (items.length == 0) {
            return List.of();
        }
        ItemStack stack = items[previewIndex < 0 || items.length <= previewIndex ? 0 : previewIndex];
        return Screen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)stack);
    }

    @NotNull
    public JsonElement serialize() {
        JsonObject obj = new JsonObject();
        obj.add("ingredient", this.ingredient.m_43942_());
        if (this.quantity != 1) {
            obj.addProperty("quantity", (Number)this.quantity);
        }
        return obj;
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        this.ingredient.m_43923_(buffer);
        buffer.m_130130_(this.quantity);
    }
}

