/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.entity;

import com.izofar.bygonenether.entity.IShieldedMob;
import com.izofar.bygonenether.entity.ai.goal.ShieldGoal;
import com.izofar.bygonenether.init.ModItems;
import java.util.UUID;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PiglinHunter
extends Piglin
implements IShieldedMob {
    private static final EntityDataAccessor<Boolean> DATA_IS_SHIELDED = SynchedEntityData.m_135353_(PiglinHunter.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_SHIELD_HAND = SynchedEntityData.m_135353_(PiglinHunter.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_SHIELD_COOLDOWN = SynchedEntityData.m_135353_(PiglinHunter.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("0B51435E-10B6-11EE-BE56-0242AC120002");
    private static final AttributeModifier SPEED_MODIFIER_BLOCKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Shielded speed penalty", -0.1, AttributeModifier.Operation.ADDITION);
    private static final float SHIELDED_BASE_PROBABILITY = 0.35f;
    private static final float GILDED_SHIELDED_BASE_PROBABILITY = 0.05f;
    private static final float CROSSBOW_PROBABILITY = 0.5f;

    public PiglinHunter(EntityType<? extends AbstractPiglin> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, new ShieldGoal<PiglinHunter>(this, Player.class));
        super.m_8099_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.decrementShieldCooldown();
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_SHIELDED, (Object)false);
        this.f_19804_.m_135372_(DATA_SHIELD_HAND, (Object)false);
        this.f_19804_.m_135372_(DATA_SHIELD_COOLDOWN, (Object)0);
    }

    public void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        super.m_213945_(random, difficulty);
        float f = 0.35f + 0.4f * difficulty.m_19056_() / 2.25f / 0.5f;
        if (!this.m_6844_(EquipmentSlot.MAINHAND).m_150930_(Items.f_42717_) && this.f_19796_.m_188501_() < f) {
            Item shield = this.f_19796_.m_188501_() < 0.05f * f ? (Item)ModItems.GILDED_NETHERITE_SHIELD.get() : Items.f_42740_;
            this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)shield));
        }
    }

    protected float m_21519_(EquipmentSlot slot) {
        if (slot == EquipmentSlot.OFFHAND) {
            return 0.0f;
        }
        return super.m_21519_(slot);
    }

    public void m_147240_(double strength, double x, double z) {
        if (!this.isUsingShield()) {
            super.m_147240_(strength, x, z);
        } else {
            this.m_5496_(SoundEvents.f_12346_, 1.0f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
        }
    }

    @Override
    public boolean isShieldDisabled() {
        return false;
    }

    @Override
    public void startUsingShield() {
        if (this.isUsingShield() || this.isShieldDisabled()) {
            return;
        }
        for (InteractionHand interactionhand : InteractionHand.values()) {
            if (!this.m_21120_(interactionhand).m_150930_((Item)ModItems.GILDED_NETHERITE_SHIELD.get())) continue;
            this.m_6672_(interactionhand);
            this.setUsingShield(true);
            this.setShieldMainhand(interactionhand == InteractionHand.MAIN_HAND);
            AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
            if (attributeinstance == null || attributeinstance.m_22109_(SPEED_MODIFIER_BLOCKING)) continue;
            attributeinstance.m_22118_(SPEED_MODIFIER_BLOCKING);
        }
    }

    @Override
    public void stopUsingShield() {
        if (!this.isUsingShield()) {
            return;
        }
        for (InteractionHand interactionhand : InteractionHand.values()) {
            if (!this.m_21120_(interactionhand).m_150930_((Item)ModItems.GILDED_NETHERITE_SHIELD.get())) continue;
            this.m_5810_();
            this.setUsingShield(false);
            AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
            if (attributeinstance == null) continue;
            attributeinstance.m_22130_(SPEED_MODIFIER_BLOCKING);
        }
    }

    public boolean isUsingShield() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_SHIELDED);
    }

    public void setUsingShield(boolean isShielded) {
        this.f_19804_.m_135381_(DATA_IS_SHIELDED, (Object)isShielded);
    }

    private boolean isShieldMainhand() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SHIELD_HAND);
    }

    private void setShieldMainhand(boolean isShieldedMainHand) {
        this.f_19804_.m_135381_(DATA_SHIELD_HAND, (Object)isShieldedMainHand);
    }

    private int getShieldCooldown() {
        return (Integer)this.f_19804_.m_135370_(DATA_SHIELD_COOLDOWN);
    }

    private void setShieldCooldown(int newShieldCooldown) {
        this.f_19804_.m_135381_(DATA_SHIELD_COOLDOWN, (Object)newShieldCooldown);
    }

    private void decrementShieldCooldown() {
        this.setShieldCooldown(Math.max(this.getShieldCooldown() - 1, 0));
    }

    public InteractionHand getShieldHand() {
        return this.isUsingShield() ? (this.isShieldMainhand() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND) : null;
    }
}

