/*
 * Decompiled with CFR 0.152.
 */
package fuzs.arcanelanterns.world.level.block.entity;

import fuzs.arcanelanterns.ArcaneLanterns;
import fuzs.arcanelanterns.config.ServerConfig;
import fuzs.arcanelanterns.init.ModRegistry;
import fuzs.arcanelanterns.world.level.block.entity.LanternBlockEntity;
import fuzs.arcanelanterns.world.level.block.entity.SparkBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class FeralLanternBlockEntity
extends LanternBlockEntity {
    private static final String TAG_FLARES = "PlacedFlares";
    private int placedFlares;

    public FeralLanternBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.FERAL_LANTERN_BLOCK_ENTITY.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FeralLanternBlockEntity blockEntity) {
        ServerConfig.FeralLanternConfig config = ((ServerConfig)ArcaneLanterns.CONFIG.get(ServerConfig.class)).feralLantern;
        if (++blockEntity.count > config.delay && !blockEntity.isDonePlacing()) {
            BlockPos.MutableBlockPos mutable = pos.m_122032_();
            mutable.m_122184_(-config.horizontalRange, -config.verticalRange, -config.horizontalRange);
            mutable.m_122184_(level.f_46441_.m_188503_(config.horizontalRange * 2), level.f_46441_.m_188503_(config.verticalRange * 2), level.f_46441_.m_188503_(config.horizontalRange * 2));
            int maxDistance = 5 * (config.horizontalRange + config.verticalRange) / 7;
            while (mutable.m_123314_((Vec3i)pos, (double)maxDistance) && !level.m_151570_((BlockPos)mutable) && level.m_8055_((BlockPos)mutable).m_60812_((BlockGetter)level, (BlockPos)mutable).m_83281_()) {
                mutable.m_122173_(Direction.DOWN);
            }
            while (mutable.m_123314_((Vec3i)pos, (double)maxDistance) && !level.m_151570_((BlockPos)mutable) && !level.m_8055_((BlockPos)mutable).m_60812_((BlockGetter)level, (BlockPos)mutable).m_83281_()) {
                mutable.m_122173_(Direction.UP);
            }
            if (level.m_46803_((BlockPos)mutable) < config.maxLightLevel && !level.m_8055_(mutable.m_7495_()).m_60812_((BlockGetter)level, mutable.m_7495_()).m_83281_()) {
                mutable.m_122175_(Direction.UP, 3);
                for (int i = 0; i < 3 && mutable.m_123314_((Vec3i)pos, (double)maxDistance) && !level.m_8055_((BlockPos)mutable).m_60795_(); ++i) {
                    mutable.m_122173_(Direction.DOWN);
                }
                if (level.m_8055_((BlockPos)mutable).m_60795_()) {
                    level.m_46597_((BlockPos)mutable, ((Block)ModRegistry.SPARK_BLOCK.get()).m_49966_());
                    BlockEntity blockEntity2 = level.m_7702_((BlockPos)mutable);
                    if (blockEntity2 instanceof SparkBlockEntity) {
                        SparkBlockEntity sparkBlockEntity = (SparkBlockEntity)blockEntity2;
                        sparkBlockEntity.pos = pos;
                    }
                    ++blockEntity.placedFlares;
                }
            }
            blockEntity.count = 0;
        }
    }

    public boolean isDonePlacing() {
        return this.placedFlares >= ((ServerConfig)ArcaneLanterns.CONFIG.get(ServerConfig.class)).feralLantern.maxPlacedFlares;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_(TAG_FLARES, this.placedFlares);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.placedFlares = tag.m_128451_(TAG_FLARES);
    }
}

