/*
 * Decompiled with CFR 0.152.
 */
package fuzs.arcanelanterns.integration.jei;

import fuzs.arcanelanterns.ArcaneLanterns;
import fuzs.arcanelanterns.init.ModRegistry;
import fuzs.arcanelanterns.integration.jei.ArcaneLanternsPlugin;
import fuzs.arcanelanterns.world.item.crafting.LanternMakingRecipe;
import fuzs.puzzleslib.api.core.v1.Proxy;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;

public class LanternMakingRecipeCategory
implements IRecipeCategory<LanternMakingRecipe> {
    private final Component title = Component.m_237115_((String)"recipe_type.arcanelanterns.lantern_making");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slotDrawable;
    private final ItemStack lanternMakerStack;
    private final List<ItemStack> lanternStacks;

    public LanternMakingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(ArcaneLanterns.id("textures/gui/lantern_making_background.png"), 0, 0, 161, 86);
        this.lanternMakerStack = new ItemStack((ItemLike)ModRegistry.LANTERN_MAKER_BLOCK.get());
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)this.lanternMakerStack);
        this.slotDrawable = guiHelper.getSlotDrawable();
        this.lanternStacks = List.of(new ItemStack((ItemLike)Items.f_42778_), new ItemStack((ItemLike)Items.f_42779_));
    }

    public static Vec2 rotatePointAbout(Vec2 in, Vec2 about, double degrees) {
        double rad = degrees * Math.PI / 180.0;
        double newX = Math.cos(rad) * (double)(in.f_82470_ - about.f_82470_) - Math.sin(rad) * (double)(in.f_82471_ - about.f_82471_) + (double)about.f_82470_;
        double newY = Math.sin(rad) * (double)(in.f_82470_ - about.f_82470_) + Math.cos(rad) * (double)(in.f_82471_ - about.f_82471_) + (double)about.f_82471_;
        return new Vec2((float)newX, (float)newY);
    }

    @NotNull
    public RecipeType<LanternMakingRecipe> getRecipeType() {
        return ArcaneLanternsPlugin.LANTERN_MAKING_RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull LanternMakingRecipe recipe, @NotNull IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 42, 35).addItemStack(this.lanternMakerStack);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 131, 14).addItemStacks(this.lanternStacks)).setBackground(this.slotDrawable, -1, -1);
        double angleBetweenEach = 360.0 / (double)recipe.m_7527_().size();
        Vec2 point = new Vec2(42.0f, 3.0f);
        Vec2 center = new Vec2(42.0f, 35.0f);
        for (Ingredient ingredient : recipe.m_7527_()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, (int)point.f_82470_, (int)point.f_82471_).addIngredients(ingredient)).setBackground(this.slotDrawable, -1, -1);
            point = LanternMakingRecipeCategory.rotatePointAbout(point, center, angleBetweenEach);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 131, 56).addItemStack(recipe.m_8043_(Proxy.INSTANCE.getClientLevel().m_9598_()));
    }
}

