/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.inventory.BackpackContainer;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TankActions;
import com.tiviacz.travelersbackpack.util.PacketDistributorHelper;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public record ServerboundActionTagPacket(CompoundTag actionTag) {
    public static final int UPGRADE_TAB = 0;
    public static final int OPEN_SCREEN = 1;
    public static final int OPEN_BACKPACK = 2;
    public static final int SORTER = 3;
    public static final int SLEEPING_BAG = 4;
    public static final int FILL_TANK = 5;
    public static final int SWAP_TOOL = 6;
    public static final int TOGGLE_BUTTONS_VISIBILITY = 7;
    public static final int SHOW_TOOL_SLOTS = 8;
    public static final int REMOVE_UPGRADE = 9;
    public static final int OPEN_SETTINGS = 10;
    public static final int SWITCH_HOSE_MODE = 11;
    public static final int SWITCH_HOSE_TANK = 12;
    public static final int TOGGLE_VISIBILITY = 13;
    public static final int ABILITY_SLIDER = 14;
    public static final int EQUIP_BACKPACK = 15;
    public static final int SET_STACK = 16;

    public static ServerboundActionTagPacket decode(FriendlyByteBuf buffer) {
        CompoundTag actionTag = buffer.m_130260_();
        return new ServerboundActionTagPacket(actionTag);
    }

    public static void encode(ServerboundActionTagPacket message, FriendlyByteBuf buffer) {
        buffer.m_130079_(message.actionTag);
    }

    public static void handle(ServerboundActionTagPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            CompoundTag actionTag = message.actionTag();
            int actionType = actionTag.m_128451_("ActionType");
            switch (actionType) {
                case 0: {
                    int slot = actionTag.m_128451_("Arg0");
                    boolean open = actionTag.m_128471_("Arg1");
                    int packetType = actionTag.m_128451_("Arg2");
                    ServerActions.modifyUpgradeTab(player, slot, open, packetType);
                    break;
                }
                case 1: {
                    if (!CapabilityUtils.isWearingBackpack((Player)player)) break;
                    BackpackContainer.openBackpack(player, CapabilityUtils.getWearingBackpack((Player)player), 2);
                    break;
                }
                case 2: {
                    int index = actionTag.m_128451_("Arg0");
                    boolean fromSlot = actionTag.m_128471_("Arg1");
                    ServerActions.openBackpackFromSlot(player, index, fromSlot);
                    break;
                }
                case 3: {
                    int button = actionTag.m_128451_("Arg0");
                    boolean shiftPressed = actionTag.m_128471_("Arg1");
                    ServerActions.sortBackpack((Player)player, button, shiftPressed);
                    break;
                }
                case 4: {
                    BlockPos pos = BlockPos.m_122022_((long)actionTag.m_128454_("Arg0"));
                    boolean isEquipped = actionTag.m_128471_("Arg1");
                    ServerActions.toggleSleepingBag((Player)player, pos, isEquipped);
                    break;
                }
                case 5: {
                    boolean leftTank = actionTag.m_128471_("Arg0");
                    TankActions.fillTank(player, leftTank);
                    break;
                }
                case 6: {
                    double scrollDelta = actionTag.m_128459_("Arg0");
                    ServerActions.swapTool((Player)player, scrollDelta);
                    break;
                }
                case 7: {
                    ServerActions.toggleButtonsVisibility((Player)player);
                    break;
                }
                case 8: {
                    boolean show = actionTag.m_128471_("Arg0");
                    ServerActions.showToolSlots(player, show);
                    break;
                }
                case 9: {
                    int slot = actionTag.m_128451_("Arg0");
                    ServerActions.removeBackpackUpgrade(player, slot);
                    break;
                }
                case 10: {
                    int entityId = actionTag.m_128451_("Arg0");
                    boolean open = actionTag.m_128471_("Arg1");
                    ServerActions.openBackpackSettings(player, entityId, open);
                    break;
                }
                case 11: {
                    double scrollDelta = actionTag.m_128459_("Arg0");
                    ServerActions.switchHoseMode((Player)player, scrollDelta);
                    break;
                }
                case 12: {
                    ServerActions.toggleHoseTank((Player)player);
                    break;
                }
                case 13: {
                    ServerActions.toggleVisibility((Player)player);
                    break;
                }
                case 14: {
                    boolean sliderValue = actionTag.m_128471_("Arg0");
                    ServerActions.switchAbilitySlider(player, sliderValue);
                    break;
                }
                case 15: {
                    boolean equip = actionTag.m_128471_("Arg0");
                    ServerActions.equipBackpack((Player)player, equip);
                    break;
                }
                case 16: {
                    int type = actionTag.m_128451_("Arg0");
                    ItemStack stack = ItemStack.m_41712_((CompoundTag)actionTag.m_128469_("Arg1"));
                    int slot = actionTag.m_128451_("Arg2");
                    ServerActions.setStack((Player)player, type, stack, slot);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void create(int type, Object ... args) {
        PacketDistributorHelper.sendToServer(new ServerboundActionTagPacket(ServerboundActionTagPacket.createPacketTag(type, args)));
    }

    public static CompoundTag createPacketTag(int type, Object ... args) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("ActionType", type);
        for (int i = 0; i < args.length; ++i) {
            String argName = "Arg" + i;
            Object object = args[i];
            if (object instanceof BlockPos) {
                BlockPos blockPos = (BlockPos)object;
                tag.m_128356_(argName, blockPos.m_121878_());
                continue;
            }
            if (args[i] instanceof Boolean) {
                tag.m_128379_(argName, ((Boolean)args[i]).booleanValue());
                continue;
            }
            if (args[i] instanceof Byte) {
                tag.m_128344_(argName, ((Byte)args[i]).byteValue());
                continue;
            }
            if (args[i] instanceof Integer) {
                tag.m_128405_(argName, ((Integer)args[i]).intValue());
                continue;
            }
            if (args[i] instanceof Double) {
                tag.m_128347_(argName, ((Double)args[i]).doubleValue());
                continue;
            }
            object = args[i];
            if (!(object instanceof ItemStack)) continue;
            ItemStack itemstack = (ItemStack)object;
            tag.m_128365_(argName, (Tag)itemstack.m_41739_(new CompoundTag()));
        }
        return tag;
    }
}

