/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.voiding;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterUpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidFilterSettings;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidWidget;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VoidUpgrade
extends FilterUpgradeBase<VoidUpgrade, VoidFilterSettings>
implements IEnable {
    public VoidUpgrade(UpgradeManager manager, int dataHolderSlot, NonNullList<ItemStack> filter, List<String> filterTags) {
        super(manager, dataHolderSlot, new Point(66, 49), (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.voidUpgradeSettings.filterSlotCount.get(), (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.voidUpgradeSettings.slotsInRow.get(), filter, filterTags);
    }

    @Override
    public List<Integer> getFilter() {
        List<Integer> filter = NbtHelper.getOrDefault(this.getUpgradeManager().getUpgradesHandler().getStackInSlot(this.dataHolderSlot), "FilterSettings", List.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1)));
        if (filter.size() != 3) {
            filter = List.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1));
        }
        return filter;
    }

    @Override
    public VoidFilterSettings createFilterSettings(UpgradeManager manager, NonNullList<ItemStack> filter, List<String> filterTags) {
        return new VoidFilterSettings(manager.getWrapper().getStorage(), filter.stream().limit(this.getFilterSlotCount()).filter(stack -> !stack.m_41619_()).toList(), this.getFilter(), filterTags);
    }

    public boolean canVoid(ItemStack stack) {
        return ((VoidFilterSettings)this.getFilterSettings()).matchesFilter(null, stack) && this.isEnabled(this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new VoidWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    @Override
    protected FilterHandler createFilter(NonNullList<ItemStack> stacks, int size) {
        return new FilterHandler(stacks, size){

            protected void onContentsChanged(int slot) {
                VoidUpgrade.this.updateDataHolderUnchecked("Inventory", VoidUpgrade.this.filter);
                ((VoidFilterSettings)VoidUpgrade.this.getFilterSettings()).updateFilter((List)NbtHelper.get(VoidUpgrade.this.getDataHolderStack(), "Inventory"));
                ((VoidFilterSettings)VoidUpgrade.this.getFilterSettings()).updateFilterTags((List)NbtHelper.get(VoidUpgrade.this.getDataHolderStack(), "FilterTags"));
                VoidUpgrade.this.changeListeners.forEach(Runnable::run);
            }
        };
    }
}

