/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.components.Fluids;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.StorageAccessWrapper;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackItemMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ToolSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.sorter.SortSelector;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.ITickableUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.items.upgrades.CraftingUpgradeItem;
import com.tiviacz.travelersbackpack.items.upgrades.TanksUpgradeItem;
import com.tiviacz.travelersbackpack.items.upgrades.UpgradeItem;
import com.tiviacz.travelersbackpack.network.ClientboundSyncItemStackPacket;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import com.tiviacz.travelersbackpack.util.PacketDistributorHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackpackWrapper {
    public static final BackpackWrapper DUMMY = new BackpackWrapper(((TravelersBackpackItem)((Object)ModItems.STANDARD_TRAVELERS_BACKPACK.get())).m_7968_(), 3, null, null);
    protected ItemStack stack;
    public final ItemStackHandler inventory;
    public final ItemStackHandler upgrades;
    public final ItemStackHandler tools;
    public ItemStackHandler upgradesTracker;
    private final UpgradeManager upgradeManager;
    private Player owner;
    public ArrayList<Player> playersUsing = new ArrayList();
    protected Level level;
    private final int screenID;
    private int tanksCapacity = 0;
    public int index = -1;
    public int[] dataLoad = new int[]{1, 1, 1};
    public Runnable saveHandler = () -> {};
    public Runnable abilityHandler = () -> {};
    public BlockPos backpackPos;
    public static final int STORAGE_ID = 0;
    public static final int UPGRADES_ID = 1;
    public static final int TOOLS_ID = 2;

    public BackpackWrapper(ItemStack stack, int screenID, @Nullable Player player, @Nullable Level level, int index) {
        this(stack, screenID, player, level);
        this.index = index;
    }

    public BackpackWrapper(ItemStack stack, int screenID, @Nullable Player player, @Nullable Level level) {
        this(stack, screenID, player, level, CapabilityUtils.LOAD_ALL);
    }

    public BackpackWrapper(ItemStack stack, int screenID, @Nullable Player player, @Nullable Level level, int[] dataLoad) {
        if (player != null) {
            this.playersUsing.add(player);
        }
        if (screenID == 2) {
            this.setBackpackOwner(player);
        }
        this.stack = stack;
        if (!BackpackWrapper.isSizeInitialized(stack)) {
            BackpackWrapper.initializeSize(stack);
        }
        int storageSlots = NbtHelper.getOrDefault(stack, "StorageSlots", Tiers.LEATHER.getStorageSlots());
        int upgradeSlots = NbtHelper.getOrDefault(stack, "UpgradeSlots", Tiers.LEATHER.getUpgradeSlots());
        int toolSlots = NbtHelper.getOrDefault(stack, "ToolSlots", Tiers.LEATHER.getToolSlots());
        this.screenID = screenID;
        this.level = level;
        this.dataLoad = dataLoad;
        this.inventory = this.createHandler(storageSlots, 0);
        this.upgrades = this.createUpgradeHandler(upgradeSlots, 1);
        this.tools = this.createHandler(toolSlots, 2);
        this.upgradesTracker = new ItemStackHandler(this.upgrades.getSlots());
        this.loadHandlers();
        this.setBackpackTankCapacity();
        this.upgradeManager = new UpgradeManager(this);
        if (!NbtHelper.has(stack, "RenderInfo")) {
            this.setRenderInfo(RenderInfo.EMPTY.compoundTag());
        }
        if (NbtHelper.has(stack, "StarterUpgrades")) {
            List upgrades = (List)NbtHelper.get(stack, "StarterUpgrades");
            upgrades.forEach(this::setStarterUpgrade);
            NbtHelper.remove(stack, "StarterUpgrades");
        }
        this.converter(stack, storageSlots, toolSlots);
    }

    public static BackpackWrapper fromStack(ItemStack backpackStack) {
        return new BackpackWrapper(backpackStack, 1, null, null);
    }

    public void setBackpackStack(ItemStack backpack) {
        this.stack = backpack;
        this.getUpgradeManager().getUpgrade(TanksUpgrade.class).ifPresent(tanksUpgrade -> tanksUpgrade.syncClients(backpack));
    }

    public ItemStack getBackpackStack() {
        return this.stack;
    }

    public int getBackpackSlotIndex() {
        return this.index;
    }

    public void setBackpackOwner(Player player) {
        this.owner = player;
    }

    @Nullable
    public Player getBackpackOwner() {
        return this.owner;
    }

    public ArrayList<Player> getPlayersUsing() {
        return this.playersUsing;
    }

    public void addUser(Player player) {
        if (!this.playersUsing.contains(player)) {
            this.playersUsing.add(player);
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public void loadHandler(String dataKey, int defaultSize, ItemStackHandler ... handlers) {
        if (NbtHelper.has(this.stack, dataKey)) {
            CompoundTag contents = NbtHelper.getHandlerNbt(this.stack, dataKey);
            if (contents.m_128441_("Size") && contents.m_128451_("Size") < defaultSize) {
                contents = this.expandContents(contents, defaultSize, this.stack, dataKey);
            }
            for (ItemStackHandler handler : handlers) {
                handler.deserializeNBT(contents);
            }
        }
    }

    public void loadHandlers() {
        if (this.dataLoad[0] == 1) {
            this.loadStorage();
        }
        if (this.dataLoad[1] == 1) {
            this.loadUpgrades();
        }
        if (this.dataLoad[2] == 1) {
            this.loadTools();
        }
    }

    public void loadStorage() {
        this.loadHandler("Inventory", this.getStorageSize(), this.inventory);
    }

    public void loadUpgrades() {
        this.loadHandler("Upgrades", this.getUpgradesSize(), this.upgrades, this.upgradesTracker);
    }

    public void loadTools() {
        this.loadHandler("ToolsInventory", this.getToolSize(), this.tools);
    }

    public void loadAdditionally(int type) {
        if (this.dataLoad[type] == 0) {
            if (type == 0) {
                this.loadStorage();
            }
            if (type == 1) {
                this.loadUpgrades();
            }
            if (type == 2) {
                this.loadTools();
            }
            this.dataLoad[type] = 1;
        }
    }

    public CompoundTag expandContents(CompoundTag contents, int size, ItemStack backpack, String type) {
        if (contents.m_128451_("Size") < size) {
            NonNullList stacks = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
            ListTag tagList = contents.m_128437_("Items", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag itemTags = tagList.m_128728_(i);
                int slot = itemTags.m_128451_("Slot");
                if (slot < 0 || slot >= stacks.size()) continue;
                stacks.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTags));
            }
            CompoundTag expandedContents = NbtHelper.serializeHandler(new ItemStackHandler(stacks));
            backpack.m_41784_().m_128365_(type, (Tag)expandedContents);
            return expandedContents;
        }
        return contents;
    }

    public void setStarterUpgrade(ItemStack upgrade) {
        if (this.level == null) {
            return;
        }
        if (upgrade.m_41720_().m_245993_(this.level.m_246046_())) {
            for (int i = 0; i < this.upgrades.getSlots(); ++i) {
                if (!this.upgrades.getStackInSlot(i).m_41619_()) continue;
                this.upgrades.setStackInSlot(i, upgrade);
                this.upgradesTracker.setStackInSlot(i, upgrade);
                if (!(upgrade.m_41720_() instanceof TanksUpgradeItem)) break;
                this.setRenderInfo(TanksUpgradeItem.writeToRenderData().compoundTag());
                break;
            }
        }
    }

    public int getStorageSize() {
        return NbtHelper.getOrDefault(this.stack, "StorageSlots", Tiers.LEATHER.getStorageSlots());
    }

    public int getUpgradesSize() {
        return NbtHelper.getOrDefault(this.stack, "UpgradeSlots", Tiers.LEATHER.getUpgradeSlots());
    }

    public int getToolSize() {
        return NbtHelper.getOrDefault(this.stack, "ToolSlots", Tiers.LEATHER.getToolSlots());
    }

    public StorageAccessWrapper getStorageForInputOutput() {
        return new StorageAccessWrapper(this, this.getStorage());
    }

    public ItemStackHandler getStorage() {
        return this.inventory;
    }

    public ItemStackHandler getUpgrades() {
        return this.upgrades;
    }

    public ItemStackHandler getTools() {
        return this.tools;
    }

    public UpgradeManager getUpgradeManager() {
        return this.upgradeManager;
    }

    public List<Integer> getUnsortableSlots() {
        return NbtHelper.getOrDefault(this.stack, "UnsortableSlots", List.of());
    }

    public List<Pair<Integer, Pair<ItemStack, Boolean>>> getMemorySlots() {
        return NbtHelper.getOrDefault(this.stack, "MemorySlots", List.of());
    }

    public int getScreenID() {
        return this.screenID;
    }

    public Component getBackpackScreenTitle() {
        return this.stack.m_41788_() ? this.stack.m_41786_() : Component.m_237115_((String)"screen.travelersbackpack.title");
    }

    public void setUnsortableSlots(List<Integer> unsortables) {
        this.setData("UnsortableSlots", unsortables);
    }

    public void setMemorySlots(List<Pair<Integer, Pair<ItemStack, Boolean>>> memory) {
        this.setData("MemorySlots", memory);
    }

    public <T> void setDataAndSync(String dataKey, T value) {
        this.setData(dataKey, value);
        this.sendDataToClients(dataKey);
    }

    public <T> void setData(String dataKey, T value) {
        NbtHelper.set(this.stack, dataKey, value);
        this.saveHandler.run();
        if (dataKey.equals("AbilityEnabled")) {
            this.abilityHandler.run();
        }
    }

    public boolean showToolSlots() {
        return NbtHelper.getOrDefault(this.stack, "ShowToolSlots", false);
    }

    public boolean showMoreButtons() {
        return NbtHelper.getOrDefault(this.stack, "ShowMoreButtons", false);
    }

    public boolean tanksVisible() {
        if (NbtHelper.has(this.stack, "RenderInfo")) {
            return ((RenderInfo)NbtHelper.get(this.stack, "RenderInfo")).hasTanks();
        }
        return this.getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent();
    }

    public int getBackpackTankCapacity() {
        return this.tanksCapacity;
    }

    public void setBackpackPos(BlockPos pos) {
        this.backpackPos = pos;
    }

    public BlockPos getBackpackPos() {
        return this.backpackPos;
    }

    public void setBackpackTankCapacity() {
        int rows = this.getRows() + (this.isExtended() ? 2 : 0);
        this.tanksCapacity = Tiers.of(NbtHelper.getOrDefault(this.stack, "Tier", 0)).getTankCapacityPerRow() * rows;
    }

    public RenderInfo getRenderInfo() {
        return NbtHelper.getOrDefault(this.stack, "RenderInfo", RenderInfo.EMPTY);
    }

    public void setRenderInfo(CompoundTag compound) {
        this.setDataAndSync("RenderInfo", new RenderInfo(compound));
    }

    public void removeRenderInfo() {
        this.setRenderInfo(new CompoundTag());
    }

    public boolean isAbilityEnabled() {
        return NbtHelper.getOrDefault(this.stack, "AbilityEnabled", (Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.forceAbilityEnabled.get());
    }

    public SortSelector.SortType getSortType() {
        int type = NbtHelper.getOrDefault(this.stack, "SortType", 0);
        return SortSelector.SortType.values()[type];
    }

    public void setNextSortType() {
        SortSelector.SortType type = this.getSortType();
        this.setDataAndSync("SortType", type.next().ordinal());
    }

    public boolean hasSleepingBag() {
        return NbtHelper.has(this.stack, "SleepingBagColor");
    }

    public int getSleepingBagColor() {
        return NbtHelper.getOrDefault(this.stack, "SleepingBagColor", DyeColor.RED.m_41060_());
    }

    public void setSleepingBagColor(int colorId) {
        this.setData("SleepingBagColor", colorId);
    }

    public boolean isOwner(Player player) {
        if (this.getBackpackOwner() != null) {
            return this.getBackpackOwner().m_19879_() == player.m_19879_();
        }
        return true;
    }

    public boolean isDyed() {
        return NbtHelper.has(this.stack, "Color");
    }

    public int getDyeColor() {
        return NbtHelper.getOrDefault(this.stack, "Color", DyeColor.RED.m_41060_());
    }

    public int getCooldown() {
        return NbtHelper.getOrDefault(this.stack, "Cooldown", 0);
    }

    public void setCooldown(int cooldownInSeconds) {
        this.setDataAndSync("Cooldown", cooldownInSeconds);
    }

    public void decreaseCooldown() {
        if (this.getCooldown() > 0) {
            int currentCooldown = this.getCooldown();
            NbtHelper.set(this.stack, "Cooldown", currentCooldown - 1);
            this.saveHandler.run();
        }
    }

    public boolean canUpgradeTick() {
        return NbtHelper.has(this.stack, "UpgradeTickInterval");
    }

    public boolean hasTickingUpgrade() {
        return this.upgradeManager.hasTickingUpgrade();
    }

    public int getUpgradeTickInterval() {
        return NbtHelper.getOrDefault(this.stack, "UpgradeTickInterval", 100);
    }

    public void setUpgradeTickInterval(int ticks) {
        this.setDataAndSync("UpgradeTickInterval", ticks);
    }

    public void removeUpgradeTickInterval() {
        NbtHelper.remove(this.stack, "UpgradeTickInterval");
    }

    public boolean isExtended() {
        return this.getStorageSize() > 81;
    }

    public int getSlotsInRow() {
        if (this.isExtended()) {
            return 11;
        }
        return 9;
    }

    public int getRows() {
        return (int)Math.ceil((double)this.getStorageSize() / (double)this.getSlotsInRow());
    }

    public void sendDataToClients(String ... keys) {
        if (this.getScreenID() == 3) {
            return;
        }
        if (this.getScreenID() == 1 && !this.getPlayersUsing().stream().filter(p -> !p.m_9236_().f_46443_).toList().isEmpty()) {
            CompoundTag builder = new CompoundTag();
            ItemStack serverDataHolder = this.getBackpackStack().m_41777_();
            ItemStack serverDataHolderCopy = ItemStackUtils.reduceSize(serverDataHolder);
            for (String key : keys) {
                if (!serverDataHolderCopy.m_41783_().m_128441_(key)) continue;
                builder.m_128365_(key, serverDataHolderCopy.m_41783_().m_128423_(key));
            }
            int slotIndex = this.index == -1 ? this.getPlayersUsing().get((int)0).m_150109_().f_35977_ : this.index;
            PacketDistributorHelper.sendToPlayer((ServerPlayer)this.getPlayersUsing().get(0), new ClientboundSyncItemStackPacket(this.getPlayersUsing().get(0).m_19879_(), slotIndex, this.getBackpackStack(), builder));
            return;
        }
        if (TravelersBackpack.enableIntegration()) {
            if (this.getScreenID() == 2 && !this.getPlayersUsing().stream().filter(p -> !p.m_9236_().f_46443_).toList().isEmpty()) {
                for (Player player : this.getPlayersUsing()) {
                    CompoundTag builder = new CompoundTag();
                    ItemStack serverDataHolder = this.getBackpackStack().m_41777_();
                    ItemStack serverDataHolderCopy = ItemStackUtils.reduceSize(serverDataHolder);
                    for (String key : keys) {
                        if (!serverDataHolderCopy.m_41783_().m_128441_(key)) continue;
                        builder.m_128365_(key, serverDataHolderCopy.m_41783_().m_128423_(key));
                    }
                    PacketDistributorHelper.sendToPlayer((ServerPlayer)player, new ClientboundSyncItemStackPacket(player.m_19879_(), -1, this.getBackpackStack(), builder));
                }
            }
            return;
        }
        if (this.getBackpackOwner() != null) {
            CompoundTag builder = new CompoundTag();
            ItemStack serverDataHolder = CapabilityUtils.getWearingBackpack(this.getBackpackOwner()).m_41777_();
            ItemStack serverDataHolderCopy = ItemStackUtils.reduceSize(serverDataHolder);
            for (String key : keys) {
                if (!serverDataHolderCopy.m_41783_().m_128441_(key)) continue;
                builder.m_128365_(key, serverDataHolderCopy.m_41783_().m_128423_(key));
            }
            CapabilityUtils.getCapability(this.getBackpackOwner()).ifPresent(data -> data.synchronise(builder));
        }
    }

    public Optional<Pair<Integer, Pair<ItemStack, Boolean>>> getMemorizedSlot(int slot) {
        return this.getMemorySlots().stream().filter(pair -> (Integer)pair.getFirst() == slot).findFirst();
    }

    private ItemStackHandler createHandler(int size, final int dataId) {
        return new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                BackpackWrapper.this.setSlotChanged(slot, this.getStackInSlot(slot), dataId);
                if (dataId == 2) {
                    BackpackWrapper.this.sendDataToClients("ToolsInventory");
                }
                BackpackWrapper.this.saveHandler.run();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (dataId == 2) {
                    return ToolSlotItemHandler.isValid(stack);
                }
                return BackpackSlotItemHandler.isItemValid(stack);
            }
        };
    }

    public void setSlotChanged(int index, ItemStack stack, int dataId) {
        switch (dataId) {
            case 0: {
                NbtHelper.update(this.stack, "Inventory", this.getStorage().getSlots(), index, stack);
                break;
            }
            case 1: {
                NbtHelper.update(this.stack, "Upgrades", this.getUpgrades().getSlots(), index, stack);
                break;
            }
            case 2: {
                NbtHelper.update(this.stack, "ToolsInventory", this.getTools().getSlots(), index, stack);
            }
        }
    }

    public void applyLowestTickInterval() {
        int minimalTickInterval = 100;
        for (int i = 0; i < this.upgrades.getSlots(); ++i) {
            ItemStack upgrade = this.upgrades.getStackInSlot(i);
            if (upgrade.m_41619_() || !NbtHelper.getOrDefault(upgrade, "UpgradeEnabled", true).booleanValue() || !NbtHelper.has(upgrade, "Cooldown")) continue;
            minimalTickInterval = Math.min(minimalTickInterval, (Integer)NbtHelper.get(upgrade, "Cooldown"));
        }
        if (!this.canUpgradeTick() || minimalTickInterval != this.getUpgradeTickInterval()) {
            this.setUpgradeTickInterval(minimalTickInterval);
        }
    }

    public void updateMinimalTickInterval(ItemStack newStack) {
        if (this.level != null && this.level.f_46443_) {
            return;
        }
        boolean applyLowestTickInterval = false;
        Item item = newStack.m_41720_();
        if (item instanceof UpgradeItem) {
            UpgradeItem upgradeItem = (UpgradeItem)item;
            if (upgradeItem.isTickingUpgrade()) {
                if (NbtHelper.getOrDefault(newStack, "UpgradeEnabled", true).booleanValue()) {
                    int tickInterval = this.getUpgradeTickInterval();
                    if (NbtHelper.has(newStack, "Cooldown")) {
                        tickInterval = (Integer)NbtHelper.get(newStack, "Cooldown");
                    }
                    if (!this.canUpgradeTick() || tickInterval < this.getUpgradeTickInterval()) {
                        this.setUpgradeTickInterval(tickInterval);
                    } else if (tickInterval > this.getUpgradeTickInterval()) {
                        applyLowestTickInterval = true;
                    }
                } else {
                    applyLowestTickInterval = true;
                }
            }
        } else {
            applyLowestTickInterval = true;
        }
        if (this.canUpgradeTick()) {
            if (!this.hasTickingUpgrade()) {
                this.removeUpgradeTickInterval();
            } else if (applyLowestTickInterval) {
                this.applyLowestTickInterval();
            }
        }
    }

    private ItemStackHandler createUpgradeHandler(int size, final int dataId) {
        return new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                BackpackWrapper.this.setSlotChanged(slot, this.getStackInSlot(slot), dataId);
                if (!BackpackWrapper.this.getPlayersUsing().isEmpty()) {
                    BackpackWrapper.this.getUpgradeManager().detectedChange(BackpackWrapper.this.upgradesTracker, slot);
                }
                BackpackWrapper.this.updateMinimalTickInterval(this.getStackInSlot(slot));
                BackpackWrapper.this.saveHandler.run();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                boolean isValid = true;
                for (int i = 0; i < this.getSlots(); ++i) {
                    if (this.getStackInSlot(i).m_41720_() != stack.m_41720_()) continue;
                    isValid = false;
                    break;
                }
                if (!isValid) {
                    return false;
                }
                if (stack.m_41720_() instanceof TanksUpgradeItem) {
                    isValid = TanksUpgradeItem.canBePutInBackpack(BackpackWrapper.this.getBackpackTankCapacity(), stack);
                }
                if (!this.checkIfUpgradeValid(stack)) {
                    isValid = false;
                }
                return isValid;
            }

            public boolean checkIfUpgradeValid(ItemStack upgradeStack) {
                Item item = upgradeStack.m_41720_();
                if (item instanceof UpgradeItem) {
                    Player player;
                    UpgradeItem upgradeItem = (UpgradeItem)item;
                    Player player2 = player = BackpackWrapper.this.getPlayersUsing().isEmpty() ? null : BackpackWrapper.this.getPlayersUsing().get(0);
                    if (player == null) {
                        return false;
                    }
                    return upgradeItem.m_245993_(player.m_9236_().m_246046_());
                }
                return false;
            }
        };
    }

    public static boolean isSizeInitialized(ItemStack stack) {
        return NbtHelper.has(stack, "StorageSlots") && NbtHelper.has(stack, "UpgradeSlots") && NbtHelper.has(stack, "ToolSlots");
    }

    public static void initializeSize(ItemStack stack) {
        Tiers.Tier tier = Tiers.LEATHER;
        if (NbtHelper.has(stack, "Tier")) {
            tier = Tiers.of((Integer)NbtHelper.get(stack, "Tier"));
        } else {
            NbtHelper.set(stack, "Tier", Tiers.LEATHER.getOrdinal());
        }
        if (!NbtHelper.has(stack, "StorageSlots")) {
            NbtHelper.set(stack, "StorageSlots", tier.getStorageSlots());
        }
        if (!NbtHelper.has(stack, "UpgradeSlots")) {
            NbtHelper.set(stack, "UpgradeSlots", tier.getUpgradeSlots());
        }
        if (!NbtHelper.has(stack, "ToolSlots")) {
            NbtHelper.set(stack, "ToolSlots", tier.getToolSlots());
        }
    }

    public void requestMenuAndScreenUpdate() {
        this.requestMenuUpdate();
        this.requestScreenUpdate();
    }

    public void requestMenuAndScreenUpdate(int slot) {
        this.requestMenuUpdate(slot);
        this.requestScreenUpdate();
    }

    public void requestMenuUpdate() {
        if (!this.getPlayersUsing().isEmpty()) {
            this.getPlayersUsing().stream().filter(player -> player.f_36096_ instanceof BackpackBaseMenu).forEach(player -> ((BackpackBaseMenu)player.f_36096_).rebuildModifiableSlots());
        }
    }

    public void requestMenuUpdate(int slot) {
        if (!this.getPlayersUsing().isEmpty()) {
            this.getPlayersUsing().stream().filter(player -> player.f_36096_ instanceof BackpackBaseMenu).forEach(player -> ((BackpackBaseMenu)player.f_36096_).updateModifiableSlotsPosition(slot));
        }
    }

    public void requestScreenUpdate() {
        Screen screen;
        if (!this.getPlayersUsing().isEmpty() && !this.getPlayersUsing().stream().filter(player -> player.m_9236_().f_46443_).toList().isEmpty() && (screen = Minecraft.m_91087_().f_91080_) instanceof BackpackScreen) {
            BackpackScreen screen2 = (BackpackScreen)screen;
            screen2.updateScreen(false);
        }
    }

    public static void tickForBlockEntity(BackpackBlockEntity backpackBlockEntity) {
        BackpackWrapper wrapper = backpackBlockEntity.getWrapper();
        if (wrapper != DUMMY && wrapper.isAbilityEnabled() && BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, wrapper.getBackpackStack())) {
            boolean decreaseCooldown = BackpackAbilities.ABILITIES.abilityTickBlock(backpackBlockEntity);
            if (wrapper.getCooldown() > 0 && decreaseCooldown) {
                wrapper.decreaseCooldown();
            }
        }
    }

    @Nullable
    public static BackpackWrapper getBackpackWrapper(Player player, ItemStack backpack, int[] dataLoad) {
        if (CapabilityUtils.isWearingBackpack(player)) {
            BackpackItemMenu menu;
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof BackpackItemMenu && (menu = (BackpackItemMenu)abstractContainerMenu).getWrapper().getScreenID() == 2) {
                return menu.getWrapper();
            }
            for (Player otherPlayer : player.m_9236_().m_6907_()) {
                BackpackItemMenu menu2;
                AbstractContainerMenu abstractContainerMenu2 = otherPlayer.f_36096_;
                if (!(abstractContainerMenu2 instanceof BackpackItemMenu) || !(menu2 = (BackpackItemMenu)abstractContainerMenu2).getWrapper().isOwner(player) || menu2.getWrapper().getScreenID() != 2) continue;
                return menu2.getWrapper();
            }
            return new BackpackWrapper(backpack, 2, player, player.m_9236_(), dataLoad);
        }
        return null;
    }

    public static void tick(ItemStack stack, Player player, boolean integration) {
        if (!integration && TravelersBackpack.enableIntegration()) {
            return;
        }
        if (player.m_6084_() && CapabilityUtils.isWearingBackpack(player)) {
            BackpackWrapper wrapper;
            int ticks = (int)player.m_9236_().m_46467_();
            if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, CapabilityUtils.getWearingBackpack(player))) {
                if (BackpackAbilities.isAbilityEnabledInConfig(stack)) {
                    if (NbtHelper.getOrDefault(stack, "AbilityEnabled", (Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.forceAbilityEnabled.get()).booleanValue()) {
                        boolean decreaseCooldown = BackpackAbilities.ABILITIES.abilityTick(stack, player);
                        if (NbtHelper.getOrDefault(stack, "Cooldown", 0) > 0 && ticks % 100 == 0 && decreaseCooldown) {
                            wrapper = CapabilityUtils.getBackpackWrapper(player, stack, CapabilityUtils.NO_ITEMS);
                            int cooldown = wrapper.getCooldown();
                            if (player.m_9236_().f_46443_) {
                                return;
                            }
                            if (cooldown - 100 < 0) {
                                wrapper.setCooldown(0);
                            } else {
                                wrapper.setCooldown(cooldown - 100);
                            }
                        }
                    } else if (NbtHelper.getOrDefault(stack, "Cooldown", 0) > 0 && ticks % 100 == 0) {
                        BackpackWrapper wrapper2 = CapabilityUtils.getBackpackWrapper(player, stack, CapabilityUtils.NO_ITEMS);
                        int cooldown = wrapper2.getCooldown();
                        if (player.m_9236_().f_46443_) {
                            return;
                        }
                        if (cooldown - 100 < 0) {
                            wrapper2.setCooldown(0);
                        } else {
                            wrapper2.setCooldown(cooldown - 100);
                        }
                    }
                }
            } else if (NbtHelper.getOrDefault(stack, "AbilityEnabled", false).booleanValue()) {
                NbtHelper.set(stack, "AbilityEnabled", false);
            }
            if (NbtHelper.has(stack, "UpgradeTickInterval")) {
                int upgradeTicks = (Integer)NbtHelper.get(stack, "UpgradeTickInterval");
                if (upgradeTicks == 0) {
                    return;
                }
                if (ticks % upgradeTicks == 0) {
                    wrapper = CapabilityUtils.getBackpackWrapper(player, stack, CapabilityUtils.UPGRADES_ONLY);
                    wrapper.getUpgradeManager().upgrades.forEach(upgradeBase -> {
                        if (upgradeBase instanceof ITickableUpgrade) {
                            ITickableUpgrade tickable = (ITickableUpgrade)((Object)upgradeBase);
                            boolean tick = true;
                            if (upgradeBase instanceof IEnable) {
                                IEnable enable = (IEnable)((Object)upgradeBase);
                                tick = enable.isEnabled((UpgradeBase<?>)upgradeBase);
                            }
                            if (tick) {
                                tickable.tick(player, player.m_9236_(), player.m_20183_(), ticks);
                            }
                        }
                    });
                }
            }
        }
    }

    public void converter(ItemStack stack, int storageSlots, int toolSlots) {
        if (NbtHelper.has(stack, "Inventory") && storageSlots != ((NonNullList)NbtHelper.get(stack, "Inventory")).size()) {
            stack.m_41783_().m_128365_("Inventory", (Tag)NbtHelper.expandTag(stack, "Inventory", storageSlots));
        }
        if (NbtHelper.has(stack, "ToolsInventory") && toolSlots != ((NonNullList)NbtHelper.get(stack, "ToolsInventory")).size()) {
            stack.m_41783_().m_128365_("ToolsInventory", (Tag)NbtHelper.expandTag(stack, "ToolsInventory", toolSlots));
        }
        if (NbtHelper.has(stack, "LeftTank") || NbtHelper.has(stack, "RightTank")) {
            FluidStack fluidStack;
            CompoundTag oldTank = NbtHelper.has(stack, "LeftTank") ? stack.m_41783_().m_128469_("LeftTank") : new CompoundTag();
            CompoundTag oldTank2 = NbtHelper.has(stack, "RightTank") ? stack.m_41783_().m_128469_("RightTank") : new CompoundTag();
            FluidStack leftFluidStack = FluidStack.EMPTY;
            FluidStack rightFluidStack = FluidStack.EMPTY;
            if (!oldTank.m_128456_() && !(fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)oldTank)).isEmpty()) {
                leftFluidStack = fluidStack;
            }
            if (!oldTank2.m_128456_() && !(fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)oldTank2)).isEmpty()) {
                rightFluidStack = fluidStack;
            }
            ItemStack oldTanks = ((TanksUpgradeItem)((Object)ModItems.TANKS_UPGRADE.get())).m_7968_();
            NbtHelper.set(oldTanks, "Fluids", new Fluids(leftFluidStack, rightFluidStack));
            this.setStarterUpgrade(oldTanks);
            stack.m_41783_().m_128473_("LeftTank");
            stack.m_41783_().m_128473_("RightTank");
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_("CraftingInventory")) {
            ItemStack craftingUpgrade = ((CraftingUpgradeItem)((Object)ModItems.CRAFTING_UPGRADE.get())).m_7968_();
            ItemStackHandler craftingInventory = new ItemStackHandler(9);
            craftingInventory.deserializeNBT(stack.m_41783_().m_128469_("CraftingInventory"));
            NbtHelper.set(craftingUpgrade, "Inventory", craftingInventory);
            this.setStarterUpgrade(craftingUpgrade);
            stack.m_41783_().m_128473_("CraftingInventory");
        }
    }
}

